/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.DisplayBase;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class SrtDisplay
extends DisplayBase {
    private final SrtClient srtClient;
    private final SrtStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public SrtDisplay(Context context, boolean useOpengl, ConnectChecker connectChecker) {
        super(context, useOpengl);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        this.srtClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.srtClient.setAudioCodec(codec);
    }

    @Override
    public SrtStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendVideo(h264Buffer, info);
    }
}

