/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera1Base;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;

public class RtspCamera1
extends Camera1Base {
    private final RtspClient rtspClient;
    private final RtspStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public RtspCamera1(SurfaceView surfaceView, ConnectChecker connectChecker) {
        super(surfaceView);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspCamera1(TextureView textureView, ConnectChecker connectChecker) {
        super(textureView);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public RtspCamera1(OpenGlView openGlView, ConnectChecker connectChecker) {
        super(openGlView);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public RtspCamera1(Context context, ConnectChecker connectChecker) {
        super(context);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @Override
    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        this.rtspClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.rtspClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }
}

