/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.util.Filter;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u001a\u00101\u001a\u0002022\u0006\u00105\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00106\u001a\u0002022\u0006\u00107\u001a\u000208H\u0016J\u000e\u00109\u001a\u0002022\u0006\u00107\u001a\u000208J\b\u0010:\u001a\u000202H\u0016J\u0006\u0010;\u001a\u000202J\u0010\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u0010H\u0016J\b\u0010>\u001a\u00020\nH\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u000208H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u0010H\u0016J\b\u0010E\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u000202H\u0016J\u0012\u0010F\u001a\u0002022\b\u0010G\u001a\u0004\u0018\u00010CH\u0016J\u0012\u0010H\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u0010H\u001a\u0002022\u0006\u00105\u001a\u00020\nH\u0016J\b\u0010I\u001a\u000202H\u0016J\b\u0010J\u001a\u000202H\u0016J\u000e\u0010K\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020\nJ\u0018\u0010N\u001a\u0002022\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\nH\u0016J\u0012\u0010Q\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u001a\u0010Q\u001a\u0002022\u0006\u00105\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u0010R\u001a\u0002022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010S\u001a\u0002022\u0006\u0010T\u001a\u00020\nH\u0016J\u0010\u0010U\u001a\u0002022\u0006\u0010V\u001a\u00020\u0010H\u0016J\u0010\u0010W\u001a\u0002022\u0006\u0010V\u001a\u00020\u0010H\u0016J\u0010\u0010X\u001a\u0002022\u0006\u0010V\u001a\u00020\u0010H\u0016J\u0010\u0010Y\u001a\u0002022\u0006\u0010V\u001a\u00020\u0010H\u0016J\u0016\u0010Z\u001a\u0002022\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\nJ\u000e\u0010[\u001a\u0002022\u0006\u0010M\u001a\u00020\nJ\u0010\u0010\\\u001a\u0002022\u0006\u0010]\u001a\u00020\nH\u0016J\u0010\u0010^\u001a\u0002022\u0006\u0010M\u001a\u00020\nH\u0016J\b\u0010_\u001a\u000202H\u0016J\b\u0010`\u001a\u000202H\u0016J\u0012\u0010a\u001a\u0002022\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010b\u001a\u000202H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/pedro/library/view/GlStreamInterface;", "Ljava/lang/Runnable;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lcom/pedro/library/view/GlInterface;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "aspectRatioMode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "encoderHeight", "", "encoderWidth", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "forceRender", "", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "frameAvailable", "isPortrait", "isPreviewHorizontalFlip", "isPreviewVerticalFlip", "isStreamHorizontalFlip", "isStreamVerticalFlip", "managerRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "muteVideo", "previewHeight", "previewOrientation", "previewWidth", "<set-?>", "running", "getRunning", "()Z", "semaphore", "Ljava/util/concurrent/Semaphore;", "streamOrientation", "surfaceManager", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManagerEncoder", "surfaceManagerPhoto", "surfaceManagerPreview", "sync", "Ljava/lang/Object;", "takePhotoCallback", "Lcom/pedro/library/view/TakePhotoCallback;", "thread", "Ljava/lang/Thread;", "addFilter", "", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "filterPosition", "addMediaCodecSurface", "surface", "Landroid/view/Surface;", "attachPreview", "clearFilters", "deAttachPreview", "enableAA", "aaEnabled", "filtersCount", "getEncoderSize", "Landroid/graphics/Point;", "getSurface", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "isAAEnabled", "isVideoMuted", "onFrameAvailable", "surfaceTexture", "removeFilter", "removeMediaCodecSurface", "run", "setAspectRatioMode", "setCameraOrientation", "orientation", "setEncoderSize", "width", "height", "setFilter", "setForceRender", "setFps", "fps", "setIsPreviewHorizontalFlip", "flip", "setIsPreviewVerticalFlip", "setIsStreamHorizontalFlip", "setIsStreamVerticalFlip", "setPreviewResolution", "setPreviewRotation", "setRotation", "rotation", "setStreamRotation", "start", "stop", "takePhoto", "unMuteVideo", "library_release"})
@RequiresApi(api=18)
public final class GlStreamInterface
implements Runnable,
SurfaceTexture.OnFrameAvailableListener,
GlInterface {
    @NotNull
    private final Context context;
    @Nullable
    private Thread thread;
    private boolean frameAvailable;
    @Nullable
    private TakePhotoCallback takePhotoCallback;
    private boolean running;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerPhoto;
    @NotNull
    private final SurfaceManager surfaceManagerPreview;
    @NotNull
    private final MainRender managerRender;
    @NotNull
    private final Semaphore semaphore;
    @NotNull
    private final Object sync;
    private int encoderWidth;
    private int encoderHeight;
    private int streamOrientation;
    private int previewWidth;
    private int previewHeight;
    private int previewOrientation;
    private boolean isPortrait;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    private boolean forceRender;
    private boolean muteVideo;
    private boolean isPreviewHorizontalFlip;
    private boolean isPreviewVerticalFlip;
    private boolean isStreamHorizontalFlip;
    private boolean isStreamVerticalFlip;
    @NotNull
    private AspectRatioMode aspectRatioMode;

    public GlStreamInterface(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManagerPreview = new SurfaceManager();
        this.managerRender = new MainRender();
        this.semaphore = new Semaphore(0);
        this.sync = new Object();
        this.fpsLimiter = new FpsLimiter();
        this.filterQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
    }

    public final boolean getRunning() {
        return this.running;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    @NotNull
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void setFps(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean forceRender) {
        this.forceRender = forceRender;
    }

    @Override
    @NotNull
    public SurfaceTexture getSurfaceTexture() {
        return this.managerRender.getSurfaceTexture();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return this.managerRender.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCodecSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            if (this.surfaceManager.isReady()) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerEncoder.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void takePhoto(@Nullable TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.thread = new Thread(this);
            this.running = true;
            Thread thread = this.thread;
            if (thread != null) {
                thread.start();
            }
            this.semaphore.acquireUninterruptibly();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        block7: {
            this.running = false;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
            try {
                Thread thread2 = this.thread;
                if (thread2 != null) {
                    thread2.join(100L);
                }
            }
            catch (InterruptedException e) {
                Thread thread3 = this.thread;
                if (thread3 == null) break block7;
                thread3.interrupt();
            }
        }
        this.thread = null;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.surfaceManager.release();
        this.surfaceManager.eglSetup();
        this.surfaceManager.makeCurrent();
        this.managerRender.initGl(this.context, this.encoderWidth, this.encoderHeight, this.encoderWidth, this.encoderHeight);
        this.managerRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surfaceManagerPhoto.release();
        this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        this.semaphore.release();
        try {
            while (this.running) {
                Object object;
                this.fpsLimiter.setFrameStartTs();
                if (this.frameAvailable || this.forceRender) {
                    this.frameAvailable = false;
                    this.surfaceManager.makeCurrent();
                    this.managerRender.updateFrame();
                    this.managerRender.drawOffScreen();
                    this.managerRender.drawScreen(this.encoderWidth, this.encoderHeight, AspectRatioMode.NONE, 0, false, false);
                    this.surfaceManager.swapBuffer();
                    if (!this.filterQueue.isEmpty()) {
                        Filter filter = this.filterQueue.take();
                        FilterAction filterAction = filter.getFilterAction();
                        int n = filter.getPosition();
                        BaseFilterRender baseFilterRender = filter.getBaseFilterRender();
                        Intrinsics.checkNotNullExpressionValue((Object)baseFilterRender, (String)"getBaseFilterRender(...)");
                        this.managerRender.setFilterAction(filterAction, n, baseFilterRender);
                    }
                    object = this.sync;
                    synchronized (object) {
                        int h;
                        int w;
                        boolean $i$a$-synchronized-GlStreamInterface$run$32 = false;
                        boolean limitFps = this.fpsLimiter.limitFPS();
                        if (this.surfaceManagerEncoder.isReady() && !limitFps) {
                            w = this.muteVideo ? 0 : this.encoderWidth;
                            h = this.muteVideo ? 0 : this.encoderHeight;
                            this.surfaceManagerEncoder.makeCurrent();
                            this.managerRender.drawScreenEncoder(w, h, this.isPortrait, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                            this.surfaceManagerEncoder.swapBuffer();
                        }
                        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady()) {
                            this.surfaceManagerPhoto.makeCurrent();
                            this.managerRender.drawScreen(this.encoderWidth, this.encoderHeight, AspectRatioMode.NONE, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                            TakePhotoCallback takePhotoCallback = this.takePhotoCallback;
                            if (takePhotoCallback != null) {
                                takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
                            }
                            this.takePhotoCallback = null;
                            this.surfaceManagerPhoto.swapBuffer();
                        }
                        if (this.surfaceManagerPreview.isReady() && !limitFps) {
                            w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth;
                            h = this.previewHeight == 0 ? this.encoderHeight : this.previewHeight;
                            this.surfaceManagerPreview.makeCurrent();
                            this.managerRender.drawScreenPreview(w, h, this.isPortrait, this.aspectRatioMode, this.previewOrientation, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
                            this.surfaceManagerPreview.swapBuffer();
                        }
                        Unit $i$a$-synchronized-GlStreamInterface$run$32 = Unit.INSTANCE;
                    }
                }
                object = this.sync;
                synchronized (object) {
                    boolean bl = false;
                    long sleep = this.fpsLimiter.getSleepTime();
                    if (sleep > 0L) {
                        this.sync.wait(sleep);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.managerRender.release();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.frameAvailable = true;
            this.sync.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attachPreview(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            if (this.surfaceManager.isReady()) {
                this.isPortrait = CameraHelper.isPortrait((Context)this.context);
                this.surfaceManagerPreview.release();
                this.surfaceManagerPreview.eglSetup(surface, this.surfaceManager);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deAttachPreview() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerPreview.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void setStreamRotation(int orientation) {
        this.streamOrientation = orientation;
    }

    public final void setPreviewResolution(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public final void setPreviewRotation(int orientation) {
        this.previewOrientation = orientation;
    }

    public final void setCameraOrientation(int orientation) {
        this.managerRender.setCameraRotation(orientation);
    }

    @Override
    public void setFilter(int filterPosition, @Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, null));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, null));
    }

    @Override
    public void removeFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.managerRender.filtersCount();
    }

    @Override
    public void enableAA(boolean aaEnabled) {
        this.managerRender.enableAA(aaEnabled);
    }

    @Override
    public void setRotation(int rotation) {
        this.managerRender.setCameraRotation(rotation);
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public boolean isAAEnabled() {
        return this.managerRender.isAAEnabled();
    }

    @Override
    public void setFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    public final void setAspectRatioMode(@NotNull AspectRatioMode aspectRatioMode) {
        Intrinsics.checkNotNullParameter((Object)aspectRatioMode, (String)"aspectRatioMode");
        this.aspectRatioMode = aspectRatioMode;
    }
}

