/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera1Base;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;

public class SrtCamera1
extends Camera1Base {
    private final SrtClient srtClient;
    private final SrtStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public SrtCamera1(SurfaceView surfaceView, ConnectChecker connectChecker) {
        super(surfaceView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtCamera1(TextureView textureView, ConnectChecker connectChecker) {
        super(textureView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(OpenGlView openGlView, ConnectChecker connectChecker) {
        super(openGlView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(LightOpenGlView lightOpenGlView, ConnectChecker connectChecker) {
        super(lightOpenGlView);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @RequiresApi(api=18)
    public SrtCamera1(Context context, ConnectChecker connectChecker) {
        super(context);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    @Override
    public SrtStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        this.srtClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.srtClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.connect(url);
        this.requestKeyFrame();
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendVideo(h264Buffer, info);
    }
}

