/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.StreamBase;
import com.pedro.library.rtsp.RtspStream;
import com.pedro.library.util.sources.AudioManager;
import com.pedro.library.util.sources.VideoManager;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.VideoCodec;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0013\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\"\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u0016H\u0014J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/pedro/library/rtsp/RtspStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Landroid/content/Context;Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "videoSource", "Lcom/pedro/library/util/sources/VideoManager$Source;", "audioSource", "Lcom/pedro/library/util/sources/AudioManager$Source;", "(Landroid/content/Context;Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;Lcom/pedro/library/util/sources/VideoManager$Source;Lcom/pedro/library/util/sources/AudioManager$Source;)V", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "getStreamClient", "()Lcom/pedro/library/util/streamclient/RtspStreamClient;", "streamClientListener", "com/pedro/library/rtsp/RtspStream$streamClientListener$1", "Lcom/pedro/library/rtsp/RtspStream$streamClientListener$1;", "audioInfo", "", "sampleRate", "", "isStereo", "", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "onSpsPpsVpsRtp", "sps", "pps", "vps", "rtpStartStream", "endPoint", "", "rtpStopStream", "setVideoCodec", "videoCodec", "Lcom/pedro/rtsp/rtsp/VideoCodec;", "library_release"})
@RequiresApi(value=21)
public final class RtspStream
extends StreamBase {
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final streamClientListener.1 streamClientListener;
    @NotNull
    private final RtspStreamClient streamClient;

    public RtspStream(@NotNull Context context, @NotNull ConnectCheckerRtsp connectCheckerRtsp, @NotNull VideoManager.Source videoSource, @NotNull AudioManager.Source audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        Intrinsics.checkNotNullParameter((Object)((Object)videoSource), (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSource), (String)"audioSource");
        super(context, videoSource, audioSource);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtspStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyframe();
            }
        };
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @NotNull
    public final RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    public RtspStream(@NotNull Context context, @NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this(context, connectCheckerRtsp, VideoManager.Source.CAMERA2, AudioManager.Source.MICROPHONE);
    }

    public final void setVideoCodec(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"videoCodec");
        String mime = videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc";
        super.setVideoMime(mime);
    }

    @Override
    protected void audioInfo(int sampleRate, boolean isStereo) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void rtpStartStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        RtspClient.connect$default((RtspClient)this.rtspClient, (String)endPoint, (boolean)false, (int)2, null);
    }

    @Override
    protected void rtpStopStream() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

