/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.media.MediaCodec;
import com.pedro.library.base.OnlyAudioBase;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import java.nio.ByteBuffer;

public class RtmpOnlyAudio
extends OnlyAudioBase {
    private final RtmpClient rtmpClient;
    private final RtmpStreamClient streamClient;

    public RtmpOnlyAudio(ConnectCheckerRtmp connectChecker) {
        this.rtmpClient = new RtmpClient(connectChecker);
        this.rtmpClient.setOnlyAudio(true);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, null);
    }

    public RtmpStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }
}

