/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.VideoCodec;
import com.pedro.srt.utils.ConnectCheckerSrt;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class SrtCamera2
extends Camera2Base {
    private final SrtClient srtClient;

    @Deprecated
    public SrtCamera2(SurfaceView surfaceView, ConnectCheckerSrt connectChecker) {
        super(surfaceView);
        this.srtClient = new SrtClient(connectChecker);
    }

    @Deprecated
    public SrtCamera2(TextureView textureView, ConnectCheckerSrt connectChecker) {
        super(textureView);
        this.srtClient = new SrtClient(connectChecker);
    }

    public SrtCamera2(OpenGlView openGlView, ConnectCheckerSrt connectChecker) {
        super(openGlView);
        this.srtClient = new SrtClient(connectChecker);
    }

    public SrtCamera2(LightOpenGlView lightOpenGlView, ConnectCheckerSrt connectChecker) {
        super(lightOpenGlView);
        this.srtClient = new SrtClient(connectChecker);
    }

    public SrtCamera2(Context context, boolean useOpengl, ConnectCheckerSrt connectChecker) {
        super(context, useOpengl);
        this.srtClient = new SrtClient(connectChecker);
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.srtClient.setVideoCodec(videoCodec);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.srtClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.srtClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.srtClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.srtClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.srtClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.srtClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.srtClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.srtClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.srtClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.srtClient.resetDroppedVideoFrames();
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.srtClient.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.setOnlyVideo(!this.audioInitialized);
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    public void setReTries(int reTries) {
        this.srtClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return this.srtClient.shouldRetry(reason);
    }

    @Override
    public void reConnect(long delay, @Nullable String backupUrl) {
        this.srtClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.srtClient.hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendVideo(h264Buffer, info);
    }

    @Override
    public void setLogs(boolean enable) {
        this.srtClient.setLogs(enable);
    }

    @Override
    public void setCheckServerAlive(boolean enable) {
        this.srtClient.setCheckServerAlive(enable);
    }
}

