/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.video;

import android.media.MediaCodec;
import android.util.Pair;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.Obu;
import com.pedro.common.av1.ObuType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VideoEncoderHelper {
    public static Pair<ByteBuffer, ByteBuffer> decodeSpsPpsFromBuffer(ByteBuffer outputBuffer, int length) {
        byte[] csd = new byte[length];
        outputBuffer.get(csd, 0, length);
        outputBuffer.rewind();
        int spsIndex = -1;
        int ppsIndex = -1;
        for (int i = 0; i < length - 4; ++i) {
            if (csd[i] != 0 || csd[i + 1] != 0 || csd[i + 2] != 0 || csd[i + 3] != 1) continue;
            if (spsIndex == -1) {
                spsIndex = i;
                continue;
            }
            ppsIndex = i;
            break;
        }
        if (spsIndex != -1 && ppsIndex != -1) {
            byte[] sps = new byte[ppsIndex];
            System.arraycopy(csd, spsIndex, sps, 0, ppsIndex);
            byte[] pps = new byte[length - ppsIndex];
            System.arraycopy(csd, ppsIndex, pps, 0, length - ppsIndex);
            return new Pair((Object)ByteBuffer.wrap(sps), (Object)ByteBuffer.wrap(pps));
        }
        return null;
    }

    public static List<ByteBuffer> extractVpsSpsPpsFromH265(ByteBuffer csd0byteBuffer) {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        int vpsPosition = -1;
        int spsPosition = -1;
        int ppsPosition = -1;
        int contBufferInitiation = 0;
        int length = csd0byteBuffer.remaining();
        byte[] csdArray = new byte[length];
        csd0byteBuffer.get(csdArray, 0, length);
        csd0byteBuffer.rewind();
        for (int i = 0; i < csdArray.length; ++i) {
            if (contBufferInitiation == 3 && csdArray[i] == 1) {
                if (vpsPosition == -1) {
                    vpsPosition = i - 3;
                } else if (spsPosition == -1) {
                    spsPosition = i - 3;
                } else {
                    ppsPosition = i - 3;
                }
            }
            if (csdArray[i] == 0) {
                ++contBufferInitiation;
                continue;
            }
            contBufferInitiation = 0;
        }
        if (vpsPosition == -1 || spsPosition == -1 || ppsPosition == -1) {
            return byteBufferList;
        }
        byte[] vps = new byte[spsPosition];
        byte[] sps = new byte[ppsPosition - spsPosition];
        byte[] pps = new byte[csdArray.length - ppsPosition];
        for (int i = 0; i < csdArray.length; ++i) {
            if (i < spsPosition) {
                vps[i] = csdArray[i];
                continue;
            }
            if (i < ppsPosition) {
                sps[i - spsPosition] = csdArray[i];
                continue;
            }
            pps[i - ppsPosition] = csdArray[i];
        }
        byteBufferList.add(ByteBuffer.wrap(vps));
        byteBufferList.add(ByteBuffer.wrap(sps));
        byteBufferList.add(ByteBuffer.wrap(pps));
        return byteBufferList;
    }

    public static ByteBuffer extractObuSequence(ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo) {
        if (bufferInfo.flags != 1) {
            return null;
        }
        byte[] av1Data = new byte[buffer.remaining()];
        buffer.get(av1Data);
        Av1Parser av1Parser = new Av1Parser();
        List obuList = av1Parser.getObus(av1Data);
        for (Obu obu : obuList) {
            if (av1Parser.getObuType(obu.getHeader()[0]) != ObuType.SEQUENCE_HEADER) continue;
            return ByteBuffer.wrap(obu.getFullData());
        }
        return null;
    }
}

