/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lcom/pedro/encoder/input/audio/AudioUtils;", "", "<init>", "()V", "applyVolumeAndMix", "", "buffer", "", "volume", "", "buffer2", "volume2", "dst", "applyVolume", "calculateAmplitude", "encoder_release"})
public final class AudioUtils {
    public final void applyVolumeAndMix(@NotNull byte[] buffer, float volume, @NotNull byte[] buffer2, float volume2, @NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer2");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (buffer.length != buffer2.length) {
            return;
        }
        int i = 0;
        int n = buffer.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                short sample1 = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
                short sample2 = (short)(buffer2[i + 1] << 8 | buffer2[i] & 0xFF);
                int adjustedSample1 = (int)((float)sample1 * volume);
                int adjustedSample2 = (int)((float)sample2 * volume2);
                int mixedSample = RangesKt.coerceIn((int)(adjustedSample1 + adjustedSample2), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE) & 0xFFFF;
                dst[i] = (byte)(mixedSample & 0xFF);
                dst[i + 1] = (byte)(mixedSample >> 8 & 0xFF);
                if (i == n2) break;
                i += 2;
            }
        }
    }

    public final void applyVolume(@NotNull byte[] buffer, float volume) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (volume == 1.0f) {
            return;
        }
        int i = 0;
        int n = buffer.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                short sample = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
                int adjustedSample = RangesKt.coerceIn((int)((int)((float)sample * volume)), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE) & 0xFFFF;
                buffer[i] = (byte)(adjustedSample & 0xFF);
                buffer[i + 1] = (byte)(adjustedSample >> 8 & 0xFF);
                if (i == n2) break;
                i += 2;
            }
        }
    }

    public final float calculateAmplitude(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.length % 2 != 0) {
            return 0.0f;
        }
        int amplitude = 0;
        int i = 0;
        int n = buffer.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                short sample;
                int sampleAmplitude;
                if ((sampleAmplitude = Math.abs(sample = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF))) > amplitude) {
                    amplitude = sampleAmplitude;
                }
                if (i == n2) break;
                i += 2;
            }
        }
        return (float)amplitude / 32767.0f * (float)100;
    }
}

