/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.GetFrame;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import java.nio.ByteBuffer;
import java.util.List;

public class AudioEncoder
extends BaseEncoder
implements GetMicrophoneData {
    private final GetAudioData getAudioData;
    private int bitRate = 65536;
    private int sampleRate = 32000;
    public static final int inputSize = 8192;
    private boolean isStereo = true;
    private GetFrame getFrame;
    private long tsBuffer = 0L;

    public AudioEncoder(GetAudioData getAudioData) {
        this.getAudioData = getAudioData;
        this.typeError = CodecUtil.CodecTypeError.AUDIO_CODEC;
        this.type = "audio/mp4a-latm";
        this.TAG = "AudioEncoder";
    }

    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo) {
        if (this.prepared) {
            this.stop();
        }
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
        this.isBufferMode = true;
        try {
            if (this.type.equals("audio/g711-alaw")) {
                this.g711Codec.configure(sampleRate, isStereo ? 2 : 1);
                this.setCallback();
                this.running = false;
                Log.i((String)this.TAG, (String)"prepared");
                this.prepared = true;
                return true;
            }
            MediaCodecInfo encoder = this.chooseEncoder(this.type);
            if (encoder == null) {
                Log.e((String)this.TAG, (String)"Valid encoder not found");
                return false;
            }
            Log.i((String)this.TAG, (String)("Encoder selected " + encoder.getName()));
            this.codec = MediaCodec.createByCodecName((String)encoder.getName());
            int channelCount = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.type, (int)sampleRate, (int)channelCount);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", 8192);
            audioFormat.setInteger("aac-profile", 2);
            this.setCallback();
            this.codec.configure(audioFormat, null, null, 1);
            this.running = false;
            Log.i((String)this.TAG, (String)"prepared");
            this.prepared = true;
            return true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Create AudioEncoder failed.", (Throwable)e);
            this.stop();
            return false;
        }
    }

    public void setGetFrame(GetFrame getFrame) {
        this.getFrame = getFrame;
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo);
    }

    @Override
    public void start(boolean resetTs) {
        if (resetTs) {
            this.tsBuffer = 0L;
        }
        this.shouldReset = resetTs;
        Log.i((String)this.TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        Log.i((String)this.TAG, (String)"stopped");
    }

    @Override
    public boolean reset() {
        this.stop(false);
        boolean result = this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo);
        if (!result) {
            return false;
        }
        this.restart();
        return true;
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        return this.getFrame != null ? this.getFrame.getInputFrame() : (Frame)this.queue.take();
    }

    @Override
    protected long calculatePts(Frame frame, long presentTimeUs) {
        long pts;
        long clockPts = Math.max(0L, frame.getTimeStamp() - presentTimeUs);
        if (this.timestampMode == TimestampMode.CLOCK) {
            pts = clockPts;
        } else {
            if (this.tsBuffer == 0L) {
                this.tsBuffer = clockPts;
            }
            int channels = this.isStereo ? 2 : 1;
            this.tsBuffer += (long)((double)frame.getSize() / (double)((long)(this.sampleRate * channels) * 2L)) * 1000000L;
            if (clockPts - this.tsBuffer > 500000L) {
                this.tsBuffer = clockPts;
            }
            pts = this.tsBuffer;
        }
        return pts;
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.fixTimeStamp(bufferInfo);
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.getAudioData.getAudioData(byteBuffer, bufferInfo);
    }

    @Override
    public void inputPCMData(@NonNull Frame frame) {
        if (this.running && !this.queue.offer(frame)) {
            Log.i((String)this.TAG, (String)"frame discarded");
        }
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = this.codecType == CodecUtil.CodecType.HARDWARE ? CodecUtil.getAllHardwareEncoders("audio/mp4a-latm") : (this.codecType == CodecUtil.CodecType.SOFTWARE ? CodecUtil.getAllSoftwareEncoders("audio/mp4a-latm") : (this.codecType == CodecUtil.CodecType.CBR_PRIORITY ? CodecUtil.getAllEncodersCbrPriority(mime) : CodecUtil.getAllEncoders(mime, true)));
        Log.i((String)this.TAG, (String)(mediaCodecInfoList.size() + " encoders found"));
        if (mediaCodecInfoList.isEmpty()) {
            return null;
        }
        return mediaCodecInfoList.get(0);
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getAudioData.onAudioFormat(mediaFormat);
    }
}

