/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.content.Context;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.input.decoder.AudioInfo;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.input.decoder.VideoInfo;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0011H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010*\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/pedro/encoder/input/decoder/AndroidExtractor;", "Lcom/pedro/encoder/input/decoder/Extractor;", "<init>", "()V", "mediaExtractor", "Landroid/media/MediaExtractor;", "sleepTime", "", "accumulativeTs", "lastExtractorTs", "format", "Landroid/media/MediaFormat;", "selectTrack", "", "type", "Lcom/pedro/common/frame/MediaFrame$Type;", "initialize", "", "path", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "fileDescriptor", "Ljava/io/FileDescriptor;", "readFrame", "", "buffer", "Ljava/nio/ByteBuffer;", "advance", "", "getTimeStamp", "getSleepTime", "ts", "seekTo", "time", "release", "getVideoInfo", "Lcom/pedro/encoder/input/decoder/VideoInfo;", "getAudioInfo", "Lcom/pedro/encoder/input/decoder/AudioInfo;", "getFormat", "reset", "encoder_release"})
public final class AndroidExtractor
implements Extractor {
    @NotNull
    private MediaExtractor mediaExtractor = new MediaExtractor();
    private long sleepTime;
    private long accumulativeTs;
    private volatile long lastExtractorTs;
    @Nullable
    private MediaFormat format;

    @Override
    @NotNull
    public String selectTrack(@NotNull MediaFrame.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.selectTrack("video/");
            case 2 -> this.selectTrack("audio/");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void initialize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            this.reset();
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(path);
        }
        catch (Exception e) {
            throw new IOException(ExtensionsKt.validMessage((Throwable)e));
        }
    }

    @Override
    public void initialize(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            this.reset();
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(context, uri, null);
        }
        catch (Exception e) {
            throw new IOException(ExtensionsKt.validMessage((Throwable)e));
        }
    }

    @Override
    public void initialize(@NotNull FileDescriptor fileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
        try {
            this.reset();
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(fileDescriptor);
        }
        catch (Exception e) {
            throw new IOException(ExtensionsKt.validMessage((Throwable)e));
        }
    }

    @Override
    public int readFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.mediaExtractor.readSampleData(buffer, 0);
    }

    @Override
    public boolean advance() {
        return this.mediaExtractor.advance();
    }

    @Override
    public long getTimeStamp() {
        return this.mediaExtractor.getSampleTime();
    }

    @Override
    public long getSleepTime(long ts) {
        long extractorTs = Math.max(0L, this.getTimeStamp());
        if (extractorTs == 0L) {
            this.lastExtractorTs = 0L;
        }
        this.accumulativeTs += extractorTs - this.lastExtractorTs;
        this.lastExtractorTs = extractorTs;
        this.sleepTime = this.accumulativeTs > ts ? (this.accumulativeTs - ts) / (long)1000 : 0L;
        return this.sleepTime;
    }

    @Override
    public void seekTo(long time) {
        this.mediaExtractor.seekTo(time, 0);
        this.lastExtractorTs = this.getTimeStamp();
    }

    @Override
    public void release() {
        this.mediaExtractor.release();
    }

    @Override
    @NotNull
    public VideoInfo getVideoInfo() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        MediaFormat format = mediaFormat;
        Integer n = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"width");
        if (n == null) {
            throw new IOException("Width info is required");
        }
        int width = n;
        Integer n2 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"height");
        if (n2 == null) {
            throw new IOException("Height info is required");
        }
        int height = n2;
        Long l = ExtensionsKt.getLongSafe((MediaFormat)format, (String)"durationUs");
        long duration = l != null ? l : 0L;
        Integer n3 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"frame-rate");
        int fps = n3 != null ? n3 : 30;
        return new VideoInfo(width, height, fps, duration);
    }

    @Override
    @NotNull
    public AudioInfo getAudioInfo() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        MediaFormat format = mediaFormat;
        Integer n = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"sample-rate");
        if (n == null) {
            throw new IOException("Channels info is required");
        }
        int sampleRate = n;
        Integer n2 = ExtensionsKt.getIntegerSafe((MediaFormat)format, (String)"channel-count");
        if (n2 == null) {
            throw new IOException("SampleRate info is required");
        }
        int channels = n2;
        Long l = ExtensionsKt.getLongSafe((MediaFormat)format, (String)"durationUs");
        long duration = l != null ? l : 0L;
        return new AudioInfo(sampleRate, channels, duration);
    }

    @Override
    @NotNull
    public MediaFormat getFormat() {
        MediaFormat mediaFormat = this.format;
        if (mediaFormat == null) {
            throw new IOException("Extractor track not selected");
        }
        return mediaFormat;
    }

    private final String selectTrack(String type) {
        int n = this.mediaExtractor.getTrackCount();
        for (int i = 0; i < n; ++i) {
            String mime;
            MediaFormat format;
            Intrinsics.checkNotNullExpressionValue((Object)this.mediaExtractor.getTrackFormat(i), (String)"getTrackFormat(...)");
            if (format.getString("mime") == null || !StringsKt.startsWith((String)mime, (String)type, (boolean)true)) continue;
            this.mediaExtractor.selectTrack(i);
            this.format = format;
            return mime;
        }
        throw new IOException("track not found");
    }

    private final void reset() {
        this.sleepTime = 0L;
        this.accumulativeTs = 0L;
        this.lastExtractorTs = 0L;
        this.format = null;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaFrame.Type.values().length];
            try {
                nArray[MediaFrame.Type.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaFrame.Type.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

