/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import android.annotation.SuppressLint;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.pedro.common.TimeUtils;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.AudioPostProcessEffect;
import com.pedro.encoder.input.audio.AudioUtils;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.NoAudioEffect;

@SuppressLint(value={"MissingPermission"})
public class MicrophoneManager {
    private final String TAG = "MicrophoneManager";
    protected AudioRecord audioRecord;
    protected AudioRecord audioRecordDevice;
    private final GetMicrophoneData getMicrophoneData;
    protected byte[] pcmBuffer = new byte[8192];
    protected byte[] pcmBufferDevice = new byte[8192];
    protected byte[] pcmBufferMix = new byte[8192];
    protected byte[] pcmBufferMuted = new byte[8192];
    protected boolean running = false;
    private boolean created = false;
    private int sampleRate = 32000;
    private final int audioFormat = 2;
    private int channel = 12;
    protected boolean muted = false;
    private AudioPostProcessEffect audioPostProcessEffect;
    protected HandlerThread handlerThread;
    protected CustomAudioEffect customAudioEffect = new NoAudioEffect();
    private Mode mode = Mode.MICROPHONE;
    private float microphoneVolume = 1.0f;
    private float internalVolume = 1.0f;
    private final AudioUtils audioUtils = new AudioUtils();

    public MicrophoneManager(GetMicrophoneData getMicrophoneData) {
        this.getMicrophoneData = getMicrophoneData;
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.customAudioEffect = customAudioEffect;
    }

    public void createMicrophone() {
        this.createMicrophone(this.sampleRate, true, false, false);
        Log.i((String)"MicrophoneManager", (String)("Microphone created, " + this.sampleRate + "hz, Stereo"));
    }

    public boolean createMicrophone(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.createMicrophone(0, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean createMicrophone(int audioSource, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        try {
            String chl;
            this.sampleRate = sampleRate;
            this.channel = isStereo ? 12 : 16;
            this.getPcmBufferSize(sampleRate, this.channel);
            this.audioRecord = new AudioRecord(audioSource, sampleRate, this.channel, 2, 40960);
            this.audioPostProcessEffect = new AudioPostProcessEffect(this.audioRecord.getAudioSessionId());
            if (echoCanceler) {
                this.audioPostProcessEffect.enableEchoCanceler();
            }
            if (noiseSuppressor) {
                this.audioPostProcessEffect.enableNoiseSuppressor();
            }
            String string = chl = isStereo ? "Stereo" : "Mono";
            if (this.audioRecord.getState() != 1) {
                throw new IllegalArgumentException("Some parameters specified are not valid");
            }
            Log.i((String)"MicrophoneManager", (String)("Microphone created, " + sampleRate + "hz, " + chl));
            this.mode = Mode.MICROPHONE;
            this.created = true;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"MicrophoneManager", (String)"create microphone error", (Throwable)e);
        }
        return this.created;
    }

    public boolean createInternalMicrophone(AudioPlaybackCaptureConfiguration config, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        try {
            String chl;
            if (Build.VERSION.SDK_INT >= 29) {
                this.sampleRate = sampleRate;
                this.channel = isStereo ? 12 : 16;
                this.getPcmBufferSize(sampleRate, this.channel);
                this.audioRecordDevice = new AudioRecord.Builder().setAudioPlaybackCaptureConfig(config).setAudioFormat(new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRate).setChannelMask(this.channel).build()).setBufferSizeInBytes(40960).build();
                this.audioPostProcessEffect = new AudioPostProcessEffect(this.audioRecordDevice.getAudioSessionId());
                if (echoCanceler) {
                    this.audioPostProcessEffect.enableEchoCanceler();
                }
                if (noiseSuppressor) {
                    this.audioPostProcessEffect.enableNoiseSuppressor();
                }
                String string = chl = isStereo ? "Stereo" : "Mono";
                if (this.audioRecordDevice.getState() != 1) {
                    throw new IllegalArgumentException("Some parameters specified are not valid");
                }
            } else {
                return this.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
            }
            Log.i((String)"MicrophoneManager", (String)("Internal microphone created, " + sampleRate + "hz, " + chl));
            this.mode = Mode.INTERNAL;
            this.created = true;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"MicrophoneManager", (String)"create microphone error", (Throwable)e);
        }
        return this.created;
    }

    public boolean createMixMicrophone(int audioSource, AudioPlaybackCaptureConfiguration config, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        boolean micResult = this.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (!micResult) {
            return false;
        }
        boolean internalResult = this.createInternalMicrophone(config, sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.mode = Mode.MIX;
        return internalResult;
    }

    public boolean createInternalMicrophone(AudioPlaybackCaptureConfiguration config, int sampleRate, boolean isStereo) {
        return this.createInternalMicrophone(config, sampleRate, isStereo, false, false);
    }

    public synchronized void start() {
        this.init();
        this.handlerThread = new HandlerThread("MicrophoneManager");
        this.handlerThread.start();
        Handler handler = new Handler(this.handlerThread.getLooper());
        handler.post(() -> {
            while (this.running) {
                Frame frame = this.read();
                if (frame == null) continue;
                this.getMicrophoneData.inputPCMData(frame);
            }
        });
    }

    private void init() {
        switch (this.mode) {
            case MICROPHONE: {
                if (this.audioRecord != null) {
                    this.audioRecord.startRecording();
                    break;
                }
                throw new IllegalStateException("Error starting, microphone was stopped or not created, use createMicrophone() before start()");
            }
            case INTERNAL: {
                if (this.audioRecordDevice != null) {
                    this.audioRecordDevice.startRecording();
                    break;
                }
                throw new IllegalStateException("Error starting, microphone was stopped or not created, use createMicrophone() before start()");
            }
            case MIX: {
                if (this.audioRecord != null && this.audioRecordDevice != null) {
                    this.audioRecord.startRecording();
                    this.audioRecordDevice.startRecording();
                    break;
                }
                throw new IllegalStateException("Error starting, microphone was stopped or not created, use createMicrophone() before start()");
            }
        }
        this.running = true;
    }

    @RequiresApi(api=23)
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (this.audioRecord == null) {
            Log.w((String)"MicrophoneManager", (String)"audioRecord not created");
            return false;
        }
        return this.audioRecord.setPreferredDevice(deviceInfo);
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    protected Frame read() {
        long timeStamp = TimeUtils.getCurrentTimeMicro();
        switch (this.mode) {
            case MICROPHONE: {
                int size = this.audioRecord.read(this.pcmBuffer, 0, this.pcmBuffer.length);
                if (size < 0) {
                    Log.e((String)"MicrophoneManager", (String)("read error: " + size));
                    return null;
                }
                this.audioUtils.applyVolume(this.pcmBuffer, this.microphoneVolume);
                return new Frame(this.muted ? this.pcmBufferMuted : this.customAudioEffect.process(this.pcmBuffer), 0, size, timeStamp);
            }
            case INTERNAL: {
                int size = this.audioRecordDevice.read(this.pcmBufferDevice, 0, this.pcmBufferDevice.length);
                if (size < 0) {
                    Log.e((String)"MicrophoneManager", (String)("read error: " + size));
                    return null;
                }
                this.audioUtils.applyVolume(this.pcmBufferDevice, this.internalVolume);
                return new Frame(this.muted ? this.pcmBufferMuted : this.customAudioEffect.process(this.pcmBufferDevice), 0, size, timeStamp);
            }
            case MIX: {
                int size = this.audioRecord.read(this.pcmBuffer, 0, this.pcmBuffer.length);
                if (size < 0) {
                    Log.e((String)"MicrophoneManager", (String)("read error: " + size));
                    return null;
                }
                int sizeInternal = this.audioRecordDevice.read(this.pcmBufferDevice, 0, this.pcmBufferDevice.length);
                if (sizeInternal < 0) {
                    Log.e((String)"MicrophoneManager", (String)("read error: " + sizeInternal));
                    return null;
                }
                this.audioUtils.applyVolumeAndMix(this.pcmBuffer, this.microphoneVolume, this.pcmBufferDevice, this.internalVolume, this.pcmBufferMix);
                return new Frame(this.muted ? this.pcmBufferMuted : this.customAudioEffect.process(this.pcmBufferMix), 0, size, timeStamp);
            }
        }
        return null;
    }

    public synchronized void stop() {
        this.running = false;
        this.created = false;
        if (this.handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.handlerThread.quitSafely();
            } else {
                this.handlerThread.quit();
            }
        }
        if (this.audioRecord != null) {
            this.audioRecord.setRecordPositionUpdateListener(null);
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.audioRecordDevice != null) {
            this.audioRecordDevice.setRecordPositionUpdateListener(null);
            this.audioRecordDevice.stop();
            this.audioRecordDevice.release();
            this.audioRecordDevice = null;
        }
        if (this.audioPostProcessEffect != null) {
            this.audioPostProcessEffect.release();
        }
        Log.i((String)"MicrophoneManager", (String)"Microphone stopped");
    }

    private void getPcmBufferSize(int sampleRate, int channel) {
        int minSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channel, (int)2);
        int bufferSize = Math.max(minSize, 8192);
        this.pcmBuffer = new byte[bufferSize];
        this.pcmBufferDevice = new byte[bufferSize];
        this.pcmBufferMix = new byte[bufferSize];
        this.pcmBufferMuted = new byte[bufferSize];
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getAudioFormat() {
        return 2;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setVolume(float audioUtils) {
        this.setMicrophoneVolume(audioUtils);
        this.setInternalVolume(audioUtils);
    }

    public void setMicrophoneVolume(float microphoneVolume) {
        this.microphoneVolume = microphoneVolume;
    }

    public void setInternalVolume(float internalVolume) {
        this.internalVolume = internalVolume;
    }

    public float getMicrophoneVolume() {
        return this.microphoneVolume;
    }

    public float getInternalVolume() {
        return this.internalVolume;
    }

    static enum Mode {
        MICROPHONE,
        INTERNAL,
        MIX;

    }
}

