/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\tJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020\rJ\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010+\u001a\u00020,H\u0007J\u000e\u0010*\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.J\u0006\u0010/\u001a\u00020,J\u000e\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020\u0012J\u0006\u00104\u001a\u00020\u000bJ\u0011\u00105\u001a\b\u0012\u0004\u0012\u00020706\u00a2\u0006\u0002\u00108J\u0006\u00109\u001a\u000207J\u000e\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u000207J\u0006\u0010<\u001a\u00020\u000bJ\u0006\u0010=\u001a\u00020\u0012J\u0006\u0010>\u001a\u00020\u000bJ\u0006\u0010?\u001a\u00020\u000bJ\u0006\u0010@\u001a\u00020\u0012J\u0006\u0010A\u001a\u00020\u000bJ\u0006\u0010B\u001a\u00020\u000bJ\u0006\u0010C\u001a\u00020\u0012J\u0006\u0010D\u001a\u00020\u000bJ*\u0010E\u001a\u00020\u00122\u0006\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\r2\b\b\u0002\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JH\u0007J\u0006\u0010K\u001a\u00020\u0012J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u0002070\u001cH\u0007J\u0012\u0010M\u001a\u00020\u00122\b\u0010;\u001a\u0004\u0018\u000107H\u0007J\u0010\u0010N\u001a\u00020\u00122\b\u0010O\u001a\u0004\u0018\u00010PJ\u000e\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\rJ\u0006\u0010S\u001a\u00020\u0012J\u0006\u0010T\u001a\u00020\u000bJ\u0006\u0010U\u001a\u00020\rJ\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\r0\u001cJ&\u0010W\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020,2\u0006\u0010Y\u001a\u00020,2\u0006\u0010Z\u001a\u00020,2\u0006\u0010[\u001a\u00020,R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/pedro/encoder/input/sources/video/Camera2Source;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "camera", "Lcom/pedro/encoder/input/video/Camera2ApiManager;", "facing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "create", "", "width", "", "height", "fps", "rotation", "start", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "checkResolutionSupported", "switchCamera", "getCameraFacing", "getCameraResolutions", "", "Landroid/util/Size;", "setExposure", "level", "getExposure", "enableLantern", "disableLantern", "isLanternEnabled", "enableAutoFocus", "disableAutoFocus", "isAutoFocusEnabled", "tapToFocus", "event", "Landroid/view/MotionEvent;", "setZoom", "delta", "", "getZoomRange", "Landroid/util/Range;", "getZoom", "enableFaceDetection", "callback", "Lcom/pedro/encoder/input/video/facedetector/FaceDetectorCallback;", "disableFaceDetection", "isFaceDetectionEnabled", "camerasAvailable", "", "", "()[Ljava/lang/String;", "getCurrentCameraId", "openCameraId", "id", "enableOpticalVideoStabilization", "disableOpticalVideoStabilization", "isOpticalVideoStabilizationEnabled", "enableVideoStabilization", "disableVideoStabilization", "isVideoStabilizationEnabled", "enableAutoExposure", "disableAutoExposure", "isAutoExposureEnabled", "addImageListener", "format", "maxImages", "autoClose", "listener", "Lcom/pedro/encoder/input/video/Camera2ApiManager$ImageCallback;", "removeImageListener", "physicalCamerasAvailable", "openPhysicalCamera", "setCameraCallback", "callbacks", "Lcom/pedro/encoder/input/video/CameraCallbacks;", "enableAutoWhiteBalance", "mode", "disableAutoWhiteBalance", "isAutoWhiteBalanceEnabled", "getWhiteBalance", "getAutoWhiteBalanceModesAvailable", "setColorCorrectionGains", "red", "greenEven", "greenOdd", "blue", "encoder_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nCamera2Source.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera2Source.kt\ncom/pedro/encoder/input/sources/video/Camera2Source\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,255:1\n11158#2:256\n11493#2,3:257\n11158#2:260\n11493#2,3:261\n*S KotlinDebug\n*F\n+ 1 Camera2Source.kt\ncom/pedro/encoder/input/sources/video/Camera2Source\n*L\n82#1:256\n82#1:257,3\n83#1:260\n83#1:261,3\n*E\n"})
public final class Camera2Source
extends VideoSource {
    @NotNull
    private final Camera2ApiManager camera;
    @NotNull
    private CameraHelper.Facing facing;

    public Camera2Source(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.camera = new Camera2ApiManager(context);
        this.facing = CameraHelper.Facing.BACK;
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.checkResolutionSupported(width, height);
        if (!result) {
            throw new IllegalArgumentException("Unsupported resolution: " + width + "x" + height);
        }
        return true;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            surfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.camera.prepareCamera(surfaceTexture, this.getWidth(), this.getHeight(), this.getFps(), this.facing);
            this.camera.openCameraFacing(this.facing);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            Camera2ApiManager.closeCamera$default(this.camera, false, 1, null);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRunning() {
        return this.camera.isRunning();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkResolutionSupported(int width, int height) {
        Object[] resolutions;
        if (width % 2 != 0) throw new IllegalArgumentException("width and height values must be divisible by 2");
        if (height % 2 != 0) {
            throw new IllegalArgumentException("width and height values must be divisible by 2");
        }
        Size size = new Size(width, height);
        Object[] objectArray = resolutions = this.facing == CameraHelper.Facing.BACK ? this.camera.getCameraResolutionsBack() : this.camera.getCameraResolutionsFront();
        if (this.camera.getLevelSupported() != 2) {
            void $this$mapTo$iv$iv;
            Object object;
            int n;
            void $this$mapTo$iv$iv2;
            Object[] $this$map$iv = resolutions;
            boolean $i$f$map = false;
            Object[] objectArray2 = $this$map$iv;
            Object[] destination$iv$iv = (Object[])new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv2).length;
            for (n = 0; n < n2; ++n) {
                void item$iv$iv;
                void var14_20 = item$iv$iv = $this$mapTo$iv$iv2[n];
                object = destination$iv$iv;
                boolean bl = false;
                object.add(size.getWidth());
            }
            List widthList = (List)destination$iv$iv;
            Object[] $this$map$iv2 = resolutions;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            int n3 = ((void)$this$mapTo$iv$iv).length;
            for (n2 = 0; n2 < n3; ++n2) {
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[n2];
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(size.getHeight());
            }
            List heightList = (List)destination$iv$iv2;
            Integer n4 = (Integer)CollectionsKt.maxOrNull((Iterable)widthList);
            int maxWidth = n4 != null ? n4 : 0;
            Integer n5 = (Integer)CollectionsKt.maxOrNull((Iterable)heightList);
            int maxHeight = n5 != null ? n5 : 0;
            Integer n6 = (Integer)CollectionsKt.minOrNull((Iterable)widthList);
            int minWidth = n6 != null ? n6 : 0;
            Integer n7 = (Integer)CollectionsKt.minOrNull((Iterable)heightList);
            int minHeight = n7 != null ? n7 : 0;
            n = size.getWidth();
            if (minWidth > n) return false;
            if (n > maxWidth) return false;
            boolean bl = true;
            if (!bl) return false;
            n = size.getHeight();
            if (minHeight > n) return false;
            if (n > maxHeight) return false;
            return true;
        }
        boolean bl = ArraysKt.contains((Object[])resolutions, (Object)size);
        return bl;
    }

    public final void switchCamera() {
        block1: {
            CameraHelper.Facing facing = this.facing = this.facing == CameraHelper.Facing.BACK ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
            if (!this.isRunning()) break block1;
            this.stop();
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                this.start(it);
            }
        }
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    @NotNull
    public final List<Size> getCameraResolutions(@NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        Object[] resolutions = facing == CameraHelper.Facing.FRONT ? this.camera.getCameraResolutionsFront() : this.camera.getCameraResolutionsBack();
        return ArraysKt.toList((Object[])resolutions);
    }

    public final void setExposure(int level) {
        if (this.isRunning()) {
            this.camera.setExposure(level);
        }
    }

    public final int getExposure() {
        return this.isRunning() ? this.camera.getExposure() : 0;
    }

    public final void enableLantern() {
        if (this.isRunning()) {
            this.camera.enableLantern();
        }
    }

    public final void disableLantern() {
        if (this.isRunning()) {
            this.camera.disableLantern();
        }
    }

    public final boolean isLanternEnabled() {
        return this.isRunning() ? this.camera.isLanternEnabled() : false;
    }

    public final boolean enableAutoFocus() {
        if (this.isRunning()) {
            return this.camera.enableAutoFocus();
        }
        return false;
    }

    public final boolean disableAutoFocus() {
        if (this.isRunning()) {
            return this.camera.disableAutoFocus();
        }
        return false;
    }

    public final boolean isAutoFocusEnabled() {
        return this.isRunning() ? this.camera.isAutoFocusEnabled() : false;
    }

    public final boolean tapToFocus(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.camera.tapToFocus(event);
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event, float delta) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            this.camera.setZoom(event, delta);
        }
    }

    public static /* synthetic */ void setZoom$default(Camera2Source camera2Source, MotionEvent motionEvent, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.1f;
        }
        camera2Source.setZoom(motionEvent, f);
    }

    public final void setZoom(float level) {
        if (this.isRunning()) {
            this.camera.setZoom(level);
        }
    }

    @NotNull
    public final Range<Float> getZoomRange() {
        return this.camera.getZoomRange();
    }

    public final float getZoom() {
        return this.camera.getZoom();
    }

    public final boolean enableFaceDetection(@NotNull FaceDetectorCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.isRunning() ? this.camera.enableFaceDetection(callback2) : false;
    }

    public final void disableFaceDetection() {
        if (this.isRunning()) {
            this.camera.disableFaceDetection();
        }
    }

    public final boolean isFaceDetectionEnabled() {
        return this.camera.isFaceDetectionEnabled();
    }

    @NotNull
    public final String[] camerasAvailable() {
        return this.camera.getCamerasAvailable();
    }

    @NotNull
    public final String getCurrentCameraId() {
        return this.camera.getCurrentCameraId();
    }

    public final void openCameraId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.isRunning()) {
            this.camera.reOpenCamera(id);
        }
    }

    public final boolean enableOpticalVideoStabilization() {
        return this.isRunning() ? this.camera.enableOpticalVideoStabilization() : false;
    }

    public final void disableOpticalVideoStabilization() {
        if (this.isRunning()) {
            this.camera.disableOpticalVideoStabilization();
        }
    }

    public final boolean isOpticalVideoStabilizationEnabled() {
        return this.camera.isOpticalStabilizationEnabled();
    }

    public final boolean enableVideoStabilization() {
        return this.isRunning() ? this.camera.enableVideoStabilization() : false;
    }

    public final void disableVideoStabilization() {
        if (this.isRunning()) {
            this.camera.disableVideoStabilization();
        }
    }

    public final boolean isVideoStabilizationEnabled() {
        return this.camera.isVideoStabilizationEnabled();
    }

    public final boolean enableAutoExposure() {
        return this.isRunning() ? this.camera.enableAutoExposure() : false;
    }

    public final void disableAutoExposure() {
        if (this.isRunning()) {
            this.camera.disableAutoExposure();
        }
    }

    public final boolean isAutoExposureEnabled() {
        return this.camera.isAutoExposureEnabled();
    }

    @JvmOverloads
    public final void addImageListener(int format, int maxImages, boolean autoClose, @NotNull Camera2ApiManager.ImageCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        int w = this.getRotation() == 90 || this.getRotation() == 270 ? this.getHeight() : this.getWidth();
        int h = this.getRotation() == 90 || this.getRotation() == 270 ? this.getWidth() : this.getHeight();
        this.camera.addImageListener(w, h, format, maxImages, autoClose, listener);
    }

    public static /* synthetic */ void addImageListener$default(Camera2Source camera2Source, int n, int n2, boolean bl, Camera2ApiManager.ImageCallback imageCallback, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        camera2Source.addImageListener(n, n2, bl, imageCallback);
    }

    public final void removeImageListener() {
        this.camera.removeImageListener();
    }

    @RequiresApi(value=28)
    @NotNull
    public final List<String> physicalCamerasAvailable() {
        return this.camera.getPhysicalCamerasAvailable();
    }

    @RequiresApi(value=28)
    public final void openPhysicalCamera(@Nullable String id) {
        this.camera.openPhysicalCamera(id);
    }

    public final void setCameraCallback(@Nullable CameraCallbacks callbacks) {
        this.camera.setCameraCallbacks(callbacks);
    }

    public final boolean enableAutoWhiteBalance(int mode) {
        return this.camera.enableAutoWhiteBalance(mode);
    }

    public final void disableAutoWhiteBalance() {
        this.camera.disableAutoWhiteBalance();
    }

    public final boolean isAutoWhiteBalanceEnabled() {
        return this.camera.isAutoWhiteBalanceEnabled();
    }

    public final int getWhiteBalance() {
        return this.camera.getWhiteBalance();
    }

    @NotNull
    public final List<Integer> getAutoWhiteBalanceModesAvailable() {
        return this.camera.getAutoWhiteBalanceModesAvailable();
    }

    public final boolean setColorCorrectionGains(float red, float greenEven, float greenOdd, float blue) {
        return this.camera.setColorCorrectionGains(red, greenEven, greenOdd, blue);
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Camera2Source.setZoom$default(this, event, 0.0f, 2, null);
    }

    @JvmOverloads
    public final void addImageListener(int format, int maxImages, @NotNull Camera2ApiManager.ImageCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Camera2Source.addImageListener$default(this, format, maxImages, false, listener, 4, null);
    }
}

