/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.video;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.Obu;
import com.pedro.common.av1.ObuType;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.utils.yuv.YUVUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VideoEncoder
extends BaseEncoder
implements GetCameraData {
    private final GetVideoData getVideoData;
    private boolean spsPpsSetted = false;
    private boolean forceKey = false;
    private ByteBuffer oldSps;
    private ByteBuffer oldPps;
    private ByteBuffer oldVps;
    private Surface inputSurface;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int bitRate = 1228800;
    private int rotation = 90;
    private int iFrameInterval = 2;
    private final FpsLimiter fpsLimiter = new FpsLimiter();
    private FormatVideoEncoder formatVideoEncoder = FormatVideoEncoder.YUV420Dynamical;
    private int profile = -1;
    private int level = -1;

    public VideoEncoder(GetVideoData getVideoData) {
        this.getVideoData = getVideoData;
        this.type = "video/avc";
        this.TAG = "VideoEncoder";
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, int iFrameInterval, FormatVideoEncoder formatVideoEncoder) {
        return this.prepareVideoEncoder(width, height, fps, bitRate, rotation, iFrameInterval, formatVideoEncoder, -1, -1);
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, int iFrameInterval, FormatVideoEncoder formatVideoEncoder, int profile, int level) {
        if (this.prepared) {
            this.stop();
        }
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitRate = bitRate;
        this.rotation = rotation;
        this.iFrameInterval = iFrameInterval;
        this.formatVideoEncoder = formatVideoEncoder;
        this.profile = profile;
        this.level = level;
        this.isBufferMode = true;
        MediaCodecInfo encoder = this.chooseEncoder(this.type);
        try {
            MediaFormat videoFormat;
            String resolution;
            if (encoder != null) {
                Log.i((String)this.TAG, (String)("Encoder selected " + encoder.getName()));
                this.codec = MediaCodec.createByCodecName((String)encoder.getName());
                if (this.formatVideoEncoder == FormatVideoEncoder.YUV420Dynamical) {
                    this.formatVideoEncoder = this.chooseColorDynamically(encoder);
                    if (this.formatVideoEncoder == null) {
                        Log.e((String)this.TAG, (String)"YUV420 dynamical choose failed");
                        return false;
                    }
                }
            } else {
                Log.e((String)this.TAG, (String)"Valid encoder not found");
                return false;
            }
            if (rotation == 90 || rotation == 270) {
                resolution = height + "x" + width;
                videoFormat = MediaFormat.createVideoFormat((String)this.type, (int)height, (int)width);
            } else {
                resolution = width + "x" + height;
                videoFormat = MediaFormat.createVideoFormat((String)this.type, (int)width, (int)height);
            }
            Log.i((String)this.TAG, (String)("Prepare video info: " + this.formatVideoEncoder.name() + ", " + resolution));
            videoFormat.setInteger("color-format", this.formatVideoEncoder.getFormatCodec());
            videoFormat.setInteger("max-input-size", 0);
            videoFormat.setInteger("bitrate", bitRate);
            videoFormat.setInteger("frame-rate", fps);
            videoFormat.setInteger("i-frame-interval", iFrameInterval);
            if (Build.VERSION.SDK_INT >= 21 && CodecUtil.isCBRModeSupported(encoder, this.type)) {
                Log.i((String)this.TAG, (String)"set bitrate mode CBR");
                videoFormat.setInteger("bitrate-mode", 2);
            } else {
                Log.i((String)this.TAG, (String)"bitrate mode CBR not supported using default mode");
            }
            if (this.profile > 0) {
                videoFormat.setInteger("profile", this.profile);
            }
            if (this.level > 0) {
                videoFormat.setInteger("level", this.level);
            }
            this.setCallback();
            this.codec.configure(videoFormat, null, null, 1);
            this.running = false;
            if (formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                this.isBufferMode = false;
                this.inputSurface = this.codec.createInputSurface();
            }
            Log.i((String)this.TAG, (String)"prepared");
            this.prepared = true;
            return true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Create VideoEncoder failed.", (Throwable)e);
            this.stop();
            return false;
        }
    }

    @Override
    public void start(boolean resetTs) {
        this.forceKey = false;
        this.shouldReset = resetTs;
        this.spsPpsSetted = false;
        if (resetTs) {
            this.fpsLimiter.setFPS(this.fps);
        }
        if (this.formatVideoEncoder != FormatVideoEncoder.SURFACE) {
            YUVUtil.preAllocateBuffers(this.width * this.height * 3 / 2);
        }
        Log.i((String)this.TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        this.spsPpsSetted = false;
        if (this.inputSurface != null) {
            this.inputSurface.release();
        }
        this.inputSurface = null;
        this.oldSps = null;
        this.oldPps = null;
        this.oldVps = null;
        Log.i((String)this.TAG, (String)"stopped");
    }

    @Override
    public void reset() {
        this.stop(false);
        this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, this.iFrameInterval, this.formatVideoEncoder, this.profile, this.level);
        this.restart();
    }

    private FormatVideoEncoder chooseColorDynamically(MediaCodecInfo mediaCodecInfo) {
        for (int color : mediaCodecInfo.getCapabilitiesForType((String)this.type).colorFormats) {
            if (color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420PLANAR;
            }
            if (color != FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec()) continue;
            return FormatVideoEncoder.YUV420SEMIPLANAR;
        }
        return null;
    }

    public boolean prepareVideoEncoder() {
        return this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, this.iFrameInterval, this.formatVideoEncoder, this.profile, this.level);
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        if (this.isRunning()) {
            this.bitRate = bitrate;
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate);
            try {
                this.codec.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
            }
        }
    }

    @RequiresApi(api=19)
    public void requestKeyframe() {
        if (this.isRunning()) {
            if (this.spsPpsSetted) {
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                try {
                    this.codec.setParameters(bundle);
                    this.getVideoData.onSpsPpsVps(this.oldSps, this.oldPps, this.oldVps);
                }
                catch (IllegalStateException e) {
                    Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
                }
            } else {
                this.forceKey = true;
            }
        }
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void setInputSurface(Surface inputSurface) {
        this.inputSurface = inputSurface;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getFps() {
        return this.fps;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    @Override
    public void inputYUVData(Frame frame) {
        if (this.running && !this.queue.offer(frame)) {
            Log.i((String)this.TAG, (String)"frame discarded");
        }
    }

    private boolean sendSPSandPPS(MediaFormat mediaFormat) {
        if (this.type.equals("video/av01")) {
            ByteBuffer bufferInfo = mediaFormat.getByteBuffer("csd-0");
            if (bufferInfo != null && bufferInfo.remaining() > 4) {
                this.getVideoData.onSpsPpsVps(bufferInfo, null, null);
                return true;
            }
            return false;
        }
        if (this.type.equals("video/hevc")) {
            List<ByteBuffer> byteBufferList = this.extractVpsSpsPpsFromH265(mediaFormat.getByteBuffer("csd-0"));
            this.oldSps = byteBufferList.get(1);
            this.oldPps = byteBufferList.get(2);
            this.oldVps = byteBufferList.get(0);
            this.getVideoData.onSpsPpsVps(this.oldSps, this.oldPps, this.oldVps);
            return true;
        }
        this.oldSps = mediaFormat.getByteBuffer("csd-0");
        this.oldPps = mediaFormat.getByteBuffer("csd-1");
        this.oldVps = null;
        this.getVideoData.onSpsPpsVps(this.oldSps, this.oldPps, this.oldVps);
        return true;
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = this.codecType == CodecUtil.CodecType.HARDWARE ? CodecUtil.getAllHardwareEncoders(mime, true) : (this.codecType == CodecUtil.CodecType.SOFTWARE ? CodecUtil.getAllSoftwareEncoders(mime, true) : CodecUtil.getAllEncoders(mime, true, true));
        Log.i((String)this.TAG, (String)(mediaCodecInfoList.size() + " encoders found"));
        for (MediaCodecInfo mci : mediaCodecInfoList) {
            Log.i((String)this.TAG, (String)("Encoder " + mci.getName()));
            MediaCodecInfo.CodecCapabilities codecCapabilities = mci.getCapabilitiesForType(mime);
            for (int color : codecCapabilities.colorFormats) {
                Log.i((String)this.TAG, (String)("Color supported: " + color));
                if (!(this.formatVideoEncoder == FormatVideoEncoder.SURFACE ? color == FormatVideoEncoder.SURFACE.getFormatCodec() : color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec() || color == FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec())) continue;
                return mci;
            }
        }
        return null;
    }

    private Pair<ByteBuffer, ByteBuffer> decodeSpsPpsFromBuffer(ByteBuffer outputBuffer, int length) {
        byte[] csd = new byte[length];
        outputBuffer.get(csd, 0, length);
        outputBuffer.rewind();
        int spsIndex = -1;
        int ppsIndex = -1;
        for (int i = 0; i < length - 4; ++i) {
            if (csd[i] != 0 || csd[i + 1] != 0 || csd[i + 2] != 0 || csd[i + 3] != 1) continue;
            if (spsIndex == -1) {
                spsIndex = i;
                continue;
            }
            ppsIndex = i;
            break;
        }
        if (spsIndex != -1 && ppsIndex != -1) {
            byte[] sps = new byte[ppsIndex];
            System.arraycopy(csd, spsIndex, sps, 0, ppsIndex);
            byte[] pps = new byte[length - ppsIndex];
            System.arraycopy(csd, ppsIndex, pps, 0, length - ppsIndex);
            return new Pair((Object)ByteBuffer.wrap(sps), (Object)ByteBuffer.wrap(pps));
        }
        return null;
    }

    private List<ByteBuffer> extractVpsSpsPpsFromH265(ByteBuffer csd0byteBuffer) {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        int vpsPosition = -1;
        int spsPosition = -1;
        int ppsPosition = -1;
        int contBufferInitiation = 0;
        int length = csd0byteBuffer.remaining();
        byte[] csdArray = new byte[length];
        csd0byteBuffer.get(csdArray, 0, length);
        csd0byteBuffer.rewind();
        for (int i = 0; i < csdArray.length; ++i) {
            if (contBufferInitiation == 3 && csdArray[i] == 1) {
                if (vpsPosition == -1) {
                    vpsPosition = i - 3;
                } else if (spsPosition == -1) {
                    spsPosition = i - 3;
                } else {
                    ppsPosition = i - 3;
                }
            }
            if (csdArray[i] == 0) {
                ++contBufferInitiation;
                continue;
            }
            contBufferInitiation = 0;
        }
        byte[] vps = new byte[spsPosition];
        byte[] sps = new byte[ppsPosition - spsPosition];
        byte[] pps = new byte[csdArray.length - ppsPosition];
        for (int i = 0; i < csdArray.length; ++i) {
            if (i < spsPosition) {
                vps[i] = csdArray[i];
                continue;
            }
            if (i < ppsPosition) {
                sps[i - spsPosition] = csdArray[i];
                continue;
            }
            pps[i - ppsPosition] = csdArray[i];
        }
        byteBufferList.add(ByteBuffer.wrap(vps));
        byteBufferList.add(ByteBuffer.wrap(sps));
        byteBufferList.add(ByteBuffer.wrap(pps));
        return byteBufferList;
    }

    private ByteBuffer extractObuSequence(ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo) {
        if (bufferInfo.flags != 1) {
            return null;
        }
        byte[] av1Data = new byte[buffer.remaining()];
        buffer.get(av1Data);
        Av1Parser av1Parser = new Av1Parser();
        List obuList = av1Parser.getObus(av1Data);
        for (Obu obu : obuList) {
            if (av1Parser.getObuType(obu.getHeader()[0]) != ObuType.SEQUENCE_HEADER) continue;
            return ByteBuffer.wrap(obu.getFullData());
        }
        return null;
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        int orientation;
        Frame frame = (Frame)this.queue.take();
        if (frame == null) {
            return null;
        }
        if (this.fpsLimiter.limitFPS()) {
            return this.getInputFrame();
        }
        byte[] buffer = frame.getBuffer();
        boolean isYV12 = frame.getFormat() == 842094169;
        int n = orientation = frame.isFlip() ? frame.getOrientation() + 180 : frame.getOrientation();
        if (orientation >= 360) {
            orientation -= 360;
        }
        buffer = isYV12 ? YUVUtil.rotateYV12(buffer, this.width, this.height, orientation) : YUVUtil.rotateNV21(buffer, this.width, this.height, orientation);
        buffer = isYV12 ? YUVUtil.YV12toYUV420byColor(buffer, this.width, this.height, this.formatVideoEncoder) : YUVUtil.NV21toYUV420byColor(buffer, this.width, this.height, this.formatVideoEncoder);
        frame.setBuffer(buffer);
        return frame;
    }

    @Override
    protected long calculatePts(Frame frame, long presentTimeUs) {
        return Math.max(0L, frame.getTimeStamp() - presentTimeUs);
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getVideoData.onVideoFormat(mediaFormat);
        this.spsPpsSetted = this.sendSPSandPPS(mediaFormat);
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.forceKey && Build.VERSION.SDK_INT >= 19) {
            this.forceKey = false;
            this.requestKeyframe();
        }
        this.fixTimeStamp(bufferInfo);
        if (!this.spsPpsSetted && this.type.equals("video/avc")) {
            Log.i((String)this.TAG, (String)"formatChanged not called, doing manual sps/pps extraction...");
            Pair<ByteBuffer, ByteBuffer> buffers = this.decodeSpsPpsFromBuffer(byteBuffer.duplicate(), bufferInfo.size);
            if (buffers != null) {
                Log.i((String)this.TAG, (String)"manual sps/pps extraction success");
                this.oldSps = (ByteBuffer)buffers.first;
                this.oldPps = (ByteBuffer)buffers.second;
                this.oldVps = null;
                this.getVideoData.onSpsPpsVps(this.oldSps, this.oldPps, this.oldVps);
                this.spsPpsSetted = true;
            } else {
                Log.e((String)this.TAG, (String)"manual sps/pps extraction failed");
            }
        } else if (!this.spsPpsSetted && this.type.equals("video/hevc")) {
            Log.i((String)this.TAG, (String)"formatChanged not called, doing manual vps/sps/pps extraction...");
            List<ByteBuffer> byteBufferList = this.extractVpsSpsPpsFromH265(byteBuffer.duplicate());
            if (byteBufferList.size() == 3) {
                Log.i((String)this.TAG, (String)"manual vps/sps/pps extraction success");
                this.oldSps = byteBufferList.get(1);
                this.oldPps = byteBufferList.get(2);
                this.oldVps = byteBufferList.get(0);
                this.getVideoData.onSpsPpsVps(this.oldSps, this.oldPps, this.oldVps);
                this.spsPpsSetted = true;
            } else {
                Log.e((String)this.TAG, (String)"manual vps/sps/pps extraction failed");
            }
        } else if (!this.spsPpsSetted && this.type.equals("video/av01")) {
            Log.i((String)this.TAG, (String)"formatChanged not called, doing manual av1 extraction...");
            ByteBuffer obuSequence = this.extractObuSequence(byteBuffer.duplicate(), bufferInfo);
            if (obuSequence != null) {
                this.getVideoData.onSpsPpsVps(obuSequence, null, null);
                this.spsPpsSetted = true;
            } else {
                Log.e((String)this.TAG, (String)"manual av1 extraction failed");
            }
        }
        if (this.formatVideoEncoder == FormatVideoEncoder.SURFACE) {
            bufferInfo.presentationTimeUs = System.nanoTime() / 1000L - presentTimeUs;
        }
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.getVideoData.getVideoData(byteBuffer, bufferInfo);
    }
}

