/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodecUtil {
    private static final String TAG = "CodecUtil";
    public static final String H264_MIME = "video/avc";
    public static final String H265_MIME = "video/hevc";
    public static final String AAC_MIME = "audio/mp4a-latm";
    public static final String VORBIS_MIME = "audio/ogg";
    public static final String OPUS_MIME = "audio/opus";

    /*
     * Could not resolve type clashes
     */
    public static List<String> showAllCodecsInfo() {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllCodecs(false);
        ArrayList<String> infos = new ArrayList<String>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            StringBuilder info = new StringBuilder("----------------\n");
            info.append("Name: ").append(mediaCodecInfo.getName()).append("\n");
            for (String type : mediaCodecInfo.getSupportedTypes()) {
                MediaCodecInfo.VideoCapabilities videoCapabilities;
                int n;
                MediaCodecInfo.CodecProfileLevel[] encoderCapabilities;
                info.append("Type: ").append(type).append("\n");
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(type);
                if (Build.VERSION.SDK_INT >= 23) {
                    info.append("Max instances: ").append(codecCapabilities.getMaxSupportedInstances()).append("\n");
                }
                if (mediaCodecInfo.isEncoder()) {
                    info.append("----- Encoder info -----\n");
                    encoderCapabilities = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        encoderCapabilities = codecCapabilities.getEncoderCapabilities();
                        info.append("Complexity range: ").append(encoderCapabilities.getComplexityRange().getLower()).append(" - ").append(encoderCapabilities.getComplexityRange().getUpper()).append("\n");
                    }
                    if (Build.VERSION.SDK_INT >= 28) {
                        info.append("Quality range: ").append(encoderCapabilities.getQualityRange().getLower()).append(" - ").append(encoderCapabilities.getQualityRange().getUpper()).append("\n");
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        info.append("CBR supported: ").append(encoderCapabilities.isBitrateModeSupported(2)).append("\n").append("VBR supported: ").append(encoderCapabilities.isBitrateModeSupported(1)).append("\n").append("CQ supported: ").append(encoderCapabilities.isBitrateModeSupported(0)).append("\n");
                    }
                    info.append("----- -----\n");
                } else {
                    info.append("----- Decoder info -----\n").append("----- -----\n");
                }
                if (codecCapabilities.colorFormats != null && codecCapabilities.colorFormats.length > 0) {
                    info.append("----- Video info -----\n").append("Supported colors: \n");
                    for (MediaCodecInfo.EncoderCapabilities color : (MediaCodecInfo.CodecProfileLevel[])codecCapabilities.colorFormats) {
                        info.append((int)color).append("\n");
                    }
                    encoderCapabilities = codecCapabilities.profileLevels;
                    int n2 = encoderCapabilities.length;
                    for (n = 0; n < n2; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = encoderCapabilities[n];
                        info.append("Profile: ").append(profile.profile).append(", level: ").append(profile.level).append("\n");
                    }
                    videoCapabilities = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        videoCapabilities = codecCapabilities.getVideoCapabilities();
                        info.append("Bitrate range: ").append(videoCapabilities.getBitrateRange().getLower()).append(" - ").append(videoCapabilities.getBitrateRange().getUpper()).append("\n").append("Frame rate range: ").append(videoCapabilities.getSupportedFrameRates().getLower()).append(" - ").append(videoCapabilities.getSupportedFrameRates().getUpper()).append("\n").append("Width range: ").append(videoCapabilities.getSupportedWidths().getLower()).append(" - ").append(videoCapabilities.getSupportedWidths().getUpper()).append("\n").append("Height range: ").append(videoCapabilities.getSupportedHeights().getLower()).append(" - ").append(videoCapabilities.getSupportedHeights().getUpper()).append("\n");
                    }
                    info.append("----- -----\n");
                } else {
                    info.append("----- Audio info -----\n");
                    videoCapabilities = codecCapabilities.profileLevels;
                    int n3 = ((MediaCodecInfo.CodecProfileLevel[])videoCapabilities).length;
                    for (n = 0; n < n3; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = videoCapabilities[n];
                        info.append("Profile: ").append(profile.profile).append(", level: ").append(profile.level).append("\n");
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                        info.append("Bitrate range: ").append(audioCapabilities.getBitrateRange().getLower()).append(" - ").append(audioCapabilities.getBitrateRange().getUpper()).append("\n").append("Channels supported: ").append(audioCapabilities.getMaxInputChannelCount()).append("\n");
                        try {
                            if (audioCapabilities.getSupportedSampleRates() != null && audioCapabilities.getSupportedSampleRates().length > 0) {
                                info.append("Supported sample rate: \n");
                                int[] nArray = audioCapabilities.getSupportedSampleRates();
                                n = nArray.length;
                                for (int i = 0; i < n; ++i) {
                                    int sr = nArray[i];
                                    info.append(sr).append("\n");
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    info.append("----- -----\n");
                }
                if (Build.VERSION.SDK_INT < 23) continue;
                info.append("Max instances: ").append(codecCapabilities.getMaxSupportedInstances()).append("\n");
            }
            info.append("----------------\n");
            infos.add(info.toString());
        }
        return infos;
    }

    public static List<MediaCodecInfo> getAllCodecs(boolean filterBroken) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            MediaCodecInfo[] mediaCodecInfos = mediaCodecList.getCodecInfos();
            mediaCodecInfoList.addAll(Arrays.asList(mediaCodecInfos));
        } else {
            int count = MediaCodecList.getCodecCount();
            for (int i = 0; i < count; ++i) {
                MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
                mediaCodecInfoList.add(mci);
            }
        }
        return filterBroken ? CodecUtil.filterBrokenCodecs(mediaCodecInfoList) : mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllHardwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isHardwareAccelerated(mediaCodecInfo)) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllHardwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isHardwareAccelerated(mediaCodecInfo)) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllSoftwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isSoftwareOnly(mediaCodecInfo)) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllSoftwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isSoftwareOnly(mediaCodecInfo)) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllEncoders(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        List<MediaCodecInfo> mediaCodecInfos = CodecUtil.getAllCodecs(true);
        for (MediaCodecInfo mci : mediaCodecInfos) {
            String[] types;
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllDecoders(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        List<MediaCodecInfo> mediaCodecInfos = CodecUtil.getAllCodecs(true);
        for (MediaCodecInfo mci : mediaCodecInfos) {
            String[] types;
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static boolean isHardwareAccelerated(MediaCodecInfo codecInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isHardwareAccelerated();
        }
        return !CodecUtil.isSoftwareOnly(codecInfo);
    }

    private static boolean isSoftwareOnly(MediaCodecInfo mediaCodecInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            return mediaCodecInfo.isSoftwareOnly();
        }
        String name = mediaCodecInfo.getName().toLowerCase();
        if (name.startsWith("arc.")) {
            return false;
        }
        return name.startsWith("omx.google.") || name.startsWith("omx.ffmpeg.") || name.startsWith("omx.sec.") && name.contains(".sw.") || name.equals("omx.qcom.video.decoder.hevcswvdec") || name.startsWith("c2.android.") || name.startsWith("c2.google.") || !name.startsWith("omx.") && !name.startsWith("c2.");
    }

    private static List<MediaCodecInfo> filterBrokenCodecs(List<MediaCodecInfo> codecs) {
        ArrayList<MediaCodecInfo> listFilter = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : codecs) {
            if (!CodecUtil.isValid(mediaCodecInfo.getName())) continue;
            listFilter.add(mediaCodecInfo);
        }
        return listFilter;
    }

    private static boolean isValid(String name) {
        return !name.equalsIgnoreCase("aacencoder");
    }

    public static enum Force {
        FIRST_COMPATIBLE_FOUND,
        SOFTWARE,
        HARDWARE;

    }
}

