/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.video;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.utils.yuv.YUVUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VideoEncoder
extends BaseEncoder
implements GetCameraData {
    private GetVideoData getVideoData;
    private boolean spsPpsSetted = false;
    private boolean forceKey = false;
    private Surface inputSurface;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int bitRate = 1228800;
    private int rotation = 90;
    private int iFrameInterval = 2;
    private FpsLimiter fpsLimiter = new FpsLimiter();
    private String type = "video/avc";
    private FormatVideoEncoder formatVideoEncoder = FormatVideoEncoder.YUV420Dynamical;
    private int avcProfile = -1;
    private int avcProfileLevel = -1;

    public VideoEncoder(GetVideoData getVideoData) {
        this.getVideoData = getVideoData;
        this.TAG = "VideoEncoder";
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, int iFrameInterval, FormatVideoEncoder formatVideoEncoder) {
        return this.prepareVideoEncoder(width, height, fps, bitRate, rotation, iFrameInterval, formatVideoEncoder, -1, -1);
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, int iFrameInterval, FormatVideoEncoder formatVideoEncoder, int avcProfile, int avcProfileLevel) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitRate = bitRate;
        this.rotation = rotation;
        this.formatVideoEncoder = formatVideoEncoder;
        this.avcProfile = avcProfile;
        this.avcProfileLevel = avcProfileLevel;
        this.isBufferMode = true;
        MediaCodecInfo encoder = this.chooseEncoder(this.type);
        try {
            MediaFormat videoFormat;
            String resolution;
            if (encoder != null) {
                Log.i((String)this.TAG, (String)("Encoder selected " + encoder.getName()));
                this.codec = MediaCodec.createByCodecName((String)encoder.getName());
                if (this.formatVideoEncoder == FormatVideoEncoder.YUV420Dynamical) {
                    this.formatVideoEncoder = this.chooseColorDynamically(encoder);
                    if (this.formatVideoEncoder == null) {
                        Log.e((String)this.TAG, (String)"YUV420 dynamical choose failed");
                        return false;
                    }
                }
            } else {
                Log.e((String)this.TAG, (String)"Valid encoder not found");
                return false;
            }
            if (rotation == 90 || rotation == 270) {
                resolution = height + "x" + width;
                videoFormat = MediaFormat.createVideoFormat((String)this.type, (int)height, (int)width);
            } else {
                resolution = width + "x" + height;
                videoFormat = MediaFormat.createVideoFormat((String)this.type, (int)width, (int)height);
            }
            Log.i((String)this.TAG, (String)("Prepare video info: " + this.formatVideoEncoder.name() + ", " + resolution));
            videoFormat.setInteger("color-format", this.formatVideoEncoder.getFormatCodec());
            videoFormat.setInteger("max-input-size", 0);
            videoFormat.setInteger("bitrate", bitRate);
            videoFormat.setInteger("frame-rate", fps);
            videoFormat.setInteger("i-frame-interval", iFrameInterval);
            if (Build.VERSION.SDK_INT >= 21 && this.isCBRModeSupported(encoder)) {
                Log.i((String)this.TAG, (String)"set bitrate mode CBR");
                videoFormat.setInteger("bitrate-mode", 2);
            } else {
                Log.i((String)this.TAG, (String)"bitrate mode CBR not supported using default mode");
            }
            if (this.avcProfile > 0) {
                videoFormat.setInteger("profile", this.avcProfile);
            }
            if (this.avcProfileLevel > 0) {
                videoFormat.setInteger("level", this.avcProfileLevel);
            }
            this.codec.configure(videoFormat, null, null, 1);
            this.running = false;
            if (formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                this.isBufferMode = false;
                this.inputSurface = this.codec.createInputSurface();
            }
            Log.i((String)this.TAG, (String)"prepared");
            return true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Create VideoEncoder failed.", (Throwable)e);
            this.stop();
            return false;
        }
    }

    @RequiresApi(api=21)
    private boolean isCBRModeSupported(MediaCodecInfo mediaCodecInfo) {
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(this.type);
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = codecCapabilities.getEncoderCapabilities();
        return encoderCapabilities.isBitrateModeSupported(2);
    }

    @Override
    public void start(boolean resetTs) {
        this.forceKey = false;
        this.shouldReset = resetTs;
        this.spsPpsSetted = false;
        if (resetTs) {
            this.fpsLimiter.setFPS(this.fps);
        }
        if (this.formatVideoEncoder != FormatVideoEncoder.SURFACE) {
            YUVUtil.preAllocateBuffers(this.width * this.height * 3 / 2);
        }
        Log.i((String)this.TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        this.spsPpsSetted = false;
        if (this.inputSurface != null) {
            this.inputSurface.release();
        }
        this.inputSurface = null;
        Log.i((String)this.TAG, (String)"stopped");
    }

    public void forceKeyFrame() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.requestKeyframe();
        } else {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.stop(false);
        this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, this.iFrameInterval, this.formatVideoEncoder, this.avcProfile, this.avcProfileLevel);
        this.restart();
    }

    private FormatVideoEncoder chooseColorDynamically(MediaCodecInfo mediaCodecInfo) {
        for (int color : mediaCodecInfo.getCapabilitiesForType((String)this.type).colorFormats) {
            if (color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420PLANAR;
            }
            if (color != FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec()) continue;
            return FormatVideoEncoder.YUV420SEMIPLANAR;
        }
        return null;
    }

    public boolean prepareVideoEncoder() {
        return this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, this.iFrameInterval, this.formatVideoEncoder, this.avcProfile, this.avcProfileLevel);
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        if (this.isRunning()) {
            this.bitRate = bitrate;
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate);
            try {
                this.codec.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
            }
        }
    }

    @RequiresApi(api=19)
    public void requestKeyframe() {
        if (this.isRunning()) {
            if (this.spsPpsSetted) {
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                try {
                    this.codec.setParameters(bundle);
                }
                catch (IllegalStateException e) {
                    Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
                }
            } else {
                this.forceKey = true;
            }
        }
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void setInputSurface(Surface inputSurface) {
        this.inputSurface = inputSurface;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public int getFps() {
        return this.fps;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void inputYUVData(Frame frame) {
        if (this.running && !this.queue.offer(frame)) {
            Log.i((String)this.TAG, (String)"frame discarded");
        }
    }

    private void sendSPSandPPS(MediaFormat mediaFormat) {
        if (this.type.equals("video/hevc")) {
            List<ByteBuffer> byteBufferList = this.extractVpsSpsPpsFromH265(mediaFormat.getByteBuffer("csd-0"));
            this.getVideoData.onSpsPpsVps(byteBufferList.get(1), byteBufferList.get(2), byteBufferList.get(0));
        } else {
            this.getVideoData.onSpsPps(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
        }
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = this.force == CodecUtil.Force.HARDWARE ? CodecUtil.getAllHardwareEncoders(mime) : (this.force == CodecUtil.Force.SOFTWARE ? CodecUtil.getAllSoftwareEncoders(mime) : CodecUtil.getAllEncoders(mime));
        Log.i((String)this.TAG, (String)(mediaCodecInfoList.size() + " encoders found"));
        if (Build.VERSION.SDK_INT >= 21) {
            ArrayList<MediaCodecInfo> cbrPriority = new ArrayList<MediaCodecInfo>();
            for (MediaCodecInfo mci : mediaCodecInfoList) {
                if (!this.isCBRModeSupported(mci)) continue;
                cbrPriority.add(mci);
            }
            mediaCodecInfoList.removeAll(cbrPriority);
            mediaCodecInfoList.addAll(0, cbrPriority);
        }
        for (MediaCodecInfo mci : mediaCodecInfoList) {
            Log.i((String)this.TAG, (String)("Encoder " + mci.getName()));
            MediaCodecInfo.CodecCapabilities codecCapabilities = mci.getCapabilitiesForType(mime);
            for (int color : codecCapabilities.colorFormats) {
                Log.i((String)this.TAG, (String)("Color supported: " + color));
                if (!(this.formatVideoEncoder == FormatVideoEncoder.SURFACE ? color == FormatVideoEncoder.SURFACE.getFormatCodec() : color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec() || color == FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec())) continue;
                return mci;
            }
        }
        return null;
    }

    private Pair<ByteBuffer, ByteBuffer> decodeSpsPpsFromBuffer(ByteBuffer outputBuffer, int length) {
        byte[] mSPS = null;
        byte[] mPPS = null;
        byte[] csd = new byte[length];
        outputBuffer.get(csd, 0, length);
        int spsIndex = -1;
        int ppsIndex = -1;
        for (int i = 0; i < length - 4; ++i) {
            if (csd[i] != 0 || csd[i + 1] != 0 || csd[i + 2] != 0 || csd[i + 3] != 1) continue;
            if (spsIndex == -1) {
                spsIndex = i;
                continue;
            }
            ppsIndex = i;
            break;
        }
        if (spsIndex != -1 && ppsIndex != -1) {
            mSPS = new byte[ppsIndex];
            System.arraycopy(csd, spsIndex, mSPS, 0, ppsIndex);
            mPPS = new byte[length - ppsIndex];
            System.arraycopy(csd, ppsIndex, mPPS, 0, length - ppsIndex);
        }
        if (mSPS != null && mPPS != null) {
            return new Pair((Object)ByteBuffer.wrap(mSPS), (Object)ByteBuffer.wrap(mPPS));
        }
        return null;
    }

    private List<ByteBuffer> extractVpsSpsPpsFromH265(ByteBuffer csd0byteBuffer) {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        int vpsPosition = -1;
        int spsPosition = -1;
        int ppsPosition = -1;
        int contBufferInitiation = 0;
        byte[] csdArray = csd0byteBuffer.array();
        for (int i = 0; i < csdArray.length; ++i) {
            if (contBufferInitiation == 3 && csdArray[i] == 1) {
                if (vpsPosition == -1) {
                    vpsPosition = i - 3;
                } else if (spsPosition == -1) {
                    spsPosition = i - 3;
                } else {
                    ppsPosition = i - 3;
                }
            }
            if (csdArray[i] == 0) {
                ++contBufferInitiation;
                continue;
            }
            contBufferInitiation = 0;
        }
        byte[] vps = new byte[spsPosition];
        byte[] sps = new byte[ppsPosition - spsPosition];
        byte[] pps = new byte[csdArray.length - ppsPosition];
        for (int i = 0; i < csdArray.length; ++i) {
            if (i < spsPosition) {
                vps[i] = csdArray[i];
                continue;
            }
            if (i < ppsPosition) {
                sps[i - spsPosition] = csdArray[i];
                continue;
            }
            pps[i - ppsPosition] = csdArray[i];
        }
        byteBufferList.add(ByteBuffer.wrap(vps));
        byteBufferList.add(ByteBuffer.wrap(sps));
        byteBufferList.add(ByteBuffer.wrap(pps));
        return byteBufferList;
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        int orientation;
        Frame frame = (Frame)this.queue.take();
        if (frame == null) {
            return null;
        }
        if (this.fpsLimiter.limitFPS()) {
            return this.getInputFrame();
        }
        byte[] buffer = frame.getBuffer();
        boolean isYV12 = frame.getFormat() == 842094169;
        int n = orientation = frame.isFlip() ? frame.getOrientation() + 180 : frame.getOrientation();
        if (orientation >= 360) {
            orientation -= 360;
        }
        buffer = isYV12 ? YUVUtil.rotateYV12(buffer, this.width, this.height, orientation) : YUVUtil.rotateNV21(buffer, this.width, this.height, orientation);
        buffer = isYV12 ? YUVUtil.YV12toYUV420byColor(buffer, this.width, this.height, this.formatVideoEncoder) : YUVUtil.NV21toYUV420byColor(buffer, this.width, this.height, this.formatVideoEncoder);
        frame.setBuffer(buffer);
        return frame;
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getVideoData.onVideoFormat(mediaFormat);
        this.sendSPSandPPS(mediaFormat);
        this.spsPpsSetted = true;
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        Pair<ByteBuffer, ByteBuffer> buffers;
        if (this.forceKey && Build.VERSION.SDK_INT >= 19) {
            this.forceKey = false;
            this.requestKeyframe();
        }
        this.fixTimeStamp(bufferInfo);
        if ((bufferInfo.flags & 2) != 0 && !this.spsPpsSetted && (buffers = this.decodeSpsPpsFromBuffer(byteBuffer.duplicate(), bufferInfo.size)) != null) {
            this.getVideoData.onSpsPps((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
            this.spsPpsSetted = true;
        }
        if (this.formatVideoEncoder == FormatVideoEncoder.SURFACE) {
            bufferInfo.presentationTimeUs = System.nanoTime() / 1000L - presentTimeUs;
        }
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.getVideoData.getVideoData(byteBuffer, bufferInfo);
    }
}

