/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Surface;
import com.pedro.encoder.utils.gl.GlUtil;

@RequiresApi(api=18)
public class SurfaceManager {
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLContext eglContext = null;
    private EGLContext eglSharedContext = null;
    private EGLSurface eglSurface = null;
    private EGLDisplay eglDisplay = null;
    private Surface surface;

    public SurfaceManager(Surface surface, SurfaceManager manager) {
        this.surface = surface;
        this.eglSharedContext = manager.eglContext;
        this.eglSetup();
    }

    public SurfaceManager(Surface surface, EGLContext eglContext) {
        this.surface = surface;
        this.eglSharedContext = eglContext;
        this.eglSetup();
    }

    public SurfaceManager(Surface surface) {
        this.surface = surface;
        this.eglSetup();
    }

    public SurfaceManager() {
        this.eglSetup();
    }

    public void makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
            Log.e((String)"Error", (String)"eglMakeCurrent failed");
        }
    }

    public void swapBuffer() {
        EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
    }

    public void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)nsecs);
        GlUtil.checkEglError("eglPresentationTimeANDROID");
    }

    private void eglSetup() {
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] attribList = this.eglSharedContext == null ? new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344} : new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0);
        GlUtil.checkEglError("eglCreateContext RGB888+recordable ES2");
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.eglContext = this.eglSharedContext == null ? EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attrib_list, (int)0) : EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (EGLContext)this.eglSharedContext, (int[])attrib_list, (int)0);
        GlUtil.checkEglError("eglCreateContext");
        if (this.surface == null) {
            int[] surfaceAttribs = new int[]{12375, 1, 12374, 1, 12344};
            this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (int[])surfaceAttribs, (int)0);
        } else {
            int[] surfaceAttribs = new int[]{12344};
            this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (Object)this.surface, (int[])surfaceAttribs, (int)0);
        }
        GlUtil.checkEglError("eglCreateWindowSurface");
    }

    public void release() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        }
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglSurface = EGL14.EGL_NO_SURFACE;
    }

    public EGLContext getEglContext() {
        return this.eglContext;
    }

    public EGLContext getEglSharedContext() {
        return this.eglSharedContext;
    }

    public EGLSurface getEglSurface() {
        return this.eglSurface;
    }

    public EGLDisplay getEglDisplay() {
        return this.eglDisplay;
    }
}

