/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.input.video.Camera2Facing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@RequiresApi(api=21)
public class Camera2ApiManager
extends CameraDevice.StateCallback {
    private final String TAG = "Camera2ApiManager";
    private CameraDevice cameraDevice;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private Surface surfaceEncoder;
    private CameraManager cameraManager;
    private Handler cameraHandler;
    private CameraCaptureSession cameraCaptureSession;
    private boolean prepared = false;
    private int cameraId = -1;
    private Surface preview;

    public Camera2ApiManager(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    public void prepareCamera(SurfaceView surfaceView, Surface surface) {
        this.surfaceView = surfaceView;
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(TextureView textureView, Surface surface) {
        this.textureView = textureView;
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(Surface surface) {
        this.surfaceEncoder = surface;
        this.prepared = true;
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height) {
        surfaceTexture.setDefaultBufferSize(width, height);
        this.surfaceEncoder = new Surface(surfaceTexture);
        this.prepared = true;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private void startPreview(CameraDevice cameraDevice) {
        try {
            ArrayList<Surface> listSurfaces = new ArrayList<Surface>();
            this.preview = this.addPreviewSurface();
            if (this.preview != null) {
                listSurfaces.add(this.preview);
            }
            if (this.surfaceEncoder != null) {
                listSurfaces.add(this.surfaceEncoder);
            }
            cameraDevice.createCaptureSession(listSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2ApiManager.this.cameraCaptureSession = cameraCaptureSession;
                    try {
                        if (Camera2ApiManager.this.surfaceView != null || Camera2ApiManager.this.textureView != null) {
                            cameraCaptureSession.setRepeatingBurst(Arrays.asList(Camera2ApiManager.this.drawPreview(Camera2ApiManager.this.preview), Camera2ApiManager.this.drawInputSurface(Camera2ApiManager.this.surfaceEncoder)), null, Camera2ApiManager.this.cameraHandler);
                        } else {
                            cameraCaptureSession.setRepeatingBurst(Collections.singletonList(Camera2ApiManager.this.drawInputSurface(Camera2ApiManager.this.surfaceEncoder)), null, Camera2ApiManager.this.cameraHandler);
                        }
                        Log.i((String)"Camera2ApiManager", (String)"camera configured");
                    }
                    catch (CameraAccessException | NullPointerException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    cameraCaptureSession.close();
                    Log.e((String)"Camera2ApiManager", (String)"configuration failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private Surface addPreviewSurface() {
        Surface surface = null;
        if (this.surfaceView != null) {
            surface = this.surfaceView.getHolder().getSurface();
        } else if (this.textureView != null) {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            surface = new Surface(texture);
        }
        return surface;
    }

    private CaptureRequest drawPreview(Surface surface) {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.cameraDevice.createCaptureRequest(1);
            captureRequestBuilder.addTarget(surface);
            captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            return captureRequestBuilder.build();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CaptureRequest drawInputSurface(Surface surface) {
        try {
            CaptureRequest.Builder builder = this.cameraDevice.createCaptureRequest(3);
            builder.addTarget(surface);
            return builder.build();
        }
        catch (CameraAccessException | IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)e.getMessage());
            return null;
        }
    }

    public void openCamera() {
        this.openCameraBack();
    }

    public void openCameraBack() {
        this.openCameraFacing(1);
    }

    public void openCameraFront() {
        this.openCameraFacing(0);
    }

    public void openLastCamera() {
        if (this.cameraId == -1) {
            this.openCameraBack();
        } else {
            this.openCameraId(this.cameraId);
        }
    }

    public Size[] getCameraResolutionsBack() {
        try {
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 1) {
                cameraCharacteristics = this.cameraManager.getCameraCharacteristics("1");
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            return streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)e.getMessage());
            return new Size[0];
        }
    }

    public Size[] getCameraResolutionsFront() {
        try {
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 0) {
                cameraCharacteristics = this.cameraManager.getCameraCharacteristics("1");
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            return streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)e.getMessage());
            return new Size[0];
        }
    }

    public void openCameraFacing(@Camera2Facing int cameraFacing) {
        try {
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == cameraFacing) {
                this.openCameraId(0);
            } else {
                this.openCameraId(1);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void openCameraId(Integer cameraId) {
        this.cameraId = cameraId;
        if (this.prepared) {
            HandlerThread cameraHandlerThread = new HandlerThread("Camera2ApiManager Id = " + cameraId);
            cameraHandlerThread.start();
            this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
            try {
                this.cameraManager.openCamera(cameraId.toString(), (CameraDevice.StateCallback)this, this.cameraHandler);
            }
            catch (CameraAccessException | SecurityException e) {
                e.printStackTrace();
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Camera2ApiManager need be prepared, Camera2ApiManager not enabled");
        }
    }

    public void switchCamera() {
        if (this.cameraDevice != null) {
            int cameraId = Integer.parseInt(this.cameraDevice.getId()) == 1 ? 0 : 1;
            this.closeCamera(false);
            this.prepared = true;
            this.openCameraId(cameraId);
        }
    }

    public void closeCamera(boolean reOpen) {
        if (reOpen) {
            try {
                this.cameraCaptureSession.stopRepeating();
                if (this.surfaceView != null || this.textureView != null) {
                    this.cameraCaptureSession.setRepeatingBurst(Collections.singletonList(this.drawPreview(this.preview)), null, this.cameraHandler);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.cameraCaptureSession != null) {
                this.cameraCaptureSession.close();
                this.cameraCaptureSession = null;
            }
            if (this.cameraDevice != null) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (this.cameraHandler != null) {
                this.cameraHandler.getLooper().quitSafely();
                this.cameraHandler = null;
            }
            this.prepared = false;
        }
    }

    public void onOpened(@NonNull CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        Log.i((String)"Camera2ApiManager", (String)"camera opened");
    }

    public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        Log.i((String)"Camera2ApiManager", (String)"camera disconnected");
    }

    public void onError(@NonNull CameraDevice cameraDevice, int i) {
        cameraDevice.close();
        Log.e((String)"Camera2ApiManager", (String)"open failed");
    }
}

