/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import java.io.IOException;

public class TextStreamObject
extends StreamObjectBase {
    private static final String TAG = "TextStreamObject";
    private int numFrames;
    private Bitmap imageBitmap;

    @Override
    public int getWidth() {
        return this.imageBitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.imageBitmap.getHeight();
    }

    public void load(String text, float textSize, int textColor) throws IOException {
        this.numFrames = 1;
        this.imageBitmap = this.textAsBitmap(text, textSize, textColor);
        Log.i((String)TAG, (String)"finish load text");
    }

    @Override
    public void resize(int width, int height) {
        this.imageBitmap = Bitmap.createScaledBitmap((Bitmap)this.imageBitmap, (int)width, (int)height, (boolean)false);
    }

    @Override
    public void recycle() {
        this.imageBitmap.recycle();
    }

    private Bitmap textAsBitmap(String text, float textSize, int textColor) {
        Paint paint = new Paint(1);
        paint.setTextSize(textSize);
        paint.setColor(textColor);
        paint.setTextAlign(Paint.Align.LEFT);
        float baseline = -paint.ascent();
        int width = (int)(paint.measureText(text) + 0.5f);
        int height = (int)(baseline + paint.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawText(text, 0.0f, baseline, paint);
        return image;
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    public Bitmap getImageBitmap() {
        return this.imageBitmap;
    }

    @Override
    public int updateFrame() {
        return 0;
    }
}

