/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import android.view.Surface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoDecoder {
    private final String TAG = "VideoDecoder";
    private final VideoDecoderInterface videoDecoderInterface;
    private MediaExtractor videoExtractor;
    private MediaCodec videoDecoder;
    private MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private boolean decoding;
    private Thread thread;
    private MediaFormat videoFormat;
    private String mime = "";
    private int width;
    private int height;
    private boolean loopMode = false;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.decoding = false;
        this.videoExtractor = new MediaExtractor();
        this.videoExtractor.setDataSource(filePath);
        for (int i = 0; i < this.videoExtractor.getTrackCount() && !this.mime.startsWith("video/"); ++i) {
            this.videoFormat = this.videoExtractor.getTrackFormat(i);
            this.mime = this.videoFormat.getString("mime");
            if (this.mime.startsWith("video/")) {
                this.videoExtractor.selectTrack(i);
                continue;
            }
            this.videoFormat = null;
        }
        if (this.videoFormat != null && this.mime.equals("video/avc")) {
            this.width = this.videoFormat.getInteger("width");
            this.height = this.videoFormat.getInteger("height");
            return true;
        }
        this.mime = "";
        this.videoFormat = null;
        return false;
    }

    public boolean prepareVideo(Surface surface) {
        try {
            this.videoDecoder = MediaCodec.createDecoderByType((String)this.mime);
            this.videoDecoder.configure(this.videoFormat, surface, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)"VideoDecoder", (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    public void start() {
        this.decoding = true;
        this.videoDecoder.start();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)-1);
                VideoDecoder.this.decodeVideo();
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.decoding = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        if (this.videoDecoder != null) {
            this.videoDecoder.stop();
            this.videoDecoder.release();
            this.videoDecoder = null;
        }
        if (this.videoExtractor != null) {
            this.videoExtractor.release();
            this.videoExtractor = null;
        }
    }

    private void decodeVideo() {
        ByteBuffer[] inputBuffers = this.videoDecoder.getInputBuffers();
        long startMs = System.currentTimeMillis();
        while (this.decoding) {
            int outIndex;
            int inIndex = this.videoDecoder.dequeueInputBuffer(10000L);
            if (inIndex >= 0) {
                ByteBuffer buffer = inputBuffers[inIndex];
                int sampleSize = this.videoExtractor.readSampleData(buffer, 0);
                if (sampleSize < 0) {
                    this.videoDecoder.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                    Log.i((String)"VideoDecoder", (String)"end of file in");
                } else {
                    this.videoDecoder.queueInputBuffer(inIndex, 0, sampleSize, this.videoExtractor.getSampleTime(), 0);
                    this.videoExtractor.advance();
                }
            }
            if ((outIndex = this.videoDecoder.dequeueOutputBuffer(this.videoInfo, 10000L)) >= 0) {
                while (this.videoInfo.presentationTimeUs / 1000L > System.currentTimeMillis() - startMs) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.thread.interrupt();
                        break;
                    }
                }
                this.videoDecoder.releaseOutputBuffer(outIndex, this.videoInfo.size != 0);
            }
            if ((this.videoInfo.flags & 4) == 0) continue;
            Log.i((String)"VideoDecoder", (String)"end of file out");
            if (this.loopMode) {
                Log.i((String)"VideoDecoder", (String)"loop mode, restreaming file");
                this.videoExtractor.seekTo(0L, 2);
                this.videoDecoder.flush();
                continue;
            }
            this.videoDecoderInterface.onVideoDecoderFinished();
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

