/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl.watermark;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;

public class WatermarkUtil {
    private int streamWidth;
    private int streamHeight;

    public WatermarkUtil(int streamWidth, int streamHeight) {
        this.streamWidth = streamWidth;
        this.streamHeight = streamHeight;
    }

    public Bitmap createWatermarkBitmap(Bitmap watermark, int positionX, int positionY) {
        Bitmap background = this.createTransparentBitmap(this.streamWidth, this.streamHeight);
        Paint paint = new Paint(2);
        Canvas canvas = new Canvas(background);
        canvas.drawBitmap(watermark, (float)positionX, (float)positionY, paint);
        return background;
    }

    public Bitmap createTransparentBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] allPixels = new int[width * height];
        bitmap.getPixels(allPixels, 0, width, 0, 0, width, height);
        for (int i = 0; i < width * height; ++i) {
            allPixels[i] = 0;
        }
        bitmap.setPixels(allPixels, 0, width, 0, 0, width, height);
        return bitmap;
    }
}

