/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.util.Log;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.watermark.WatermarkUtil;
import java.io.IOException;

public class ImageStreamObject
extends StreamObjectBase {
    private static final String TAG = "ImageStreamObject";
    private int streamWidth;
    private int streamHeight;
    private int numFrames;
    private Bitmap imageBitmap;

    public ImageStreamObject(int streamWidth, int streamHeight) {
        this.streamWidth = streamWidth;
        this.streamHeight = streamHeight;
    }

    public void load(Bitmap imageBitmap) throws IOException {
        this.imageBitmap = imageBitmap;
        this.numFrames = 1;
        this.resize(imageBitmap.getWidth(), imageBitmap.getHeight());
        this.setPosition(0, 0);
        Log.i((String)TAG, (String)"finish load image!!!");
    }

    @Override
    public void resize(int width, int height) {
        this.imageBitmap = Bitmap.createScaledBitmap((Bitmap)this.imageBitmap, (int)width, (int)height, (boolean)false);
    }

    @Override
    public void setPosition(int positionX, int positionY) {
        WatermarkUtil watermarkUtil = new WatermarkUtil(this.streamWidth, this.streamHeight);
        this.imageBitmap = watermarkUtil.createWatermarkBitmap(this.imageBitmap, positionX, positionY);
    }

    @Override
    public void recycle() {
        this.imageBitmap.recycle();
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    public Bitmap getImageBitmap() {
        return this.imageBitmap;
    }

    @Override
    public int updateFrame() {
        return 0;
    }
}

