/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pedro/common/AudioUtils;", "", "<init>", "()V", "ADTS_SIZE", "", "createAdtsHeader", "Ljava/nio/ByteBuffer;", "type", "length", "sampleRate", "channels", "getFrequency", "AUDIO_SAMPLING_RATES", "", "common_release"})
public final class AudioUtils {
    @NotNull
    public static final AudioUtils INSTANCE = new AudioUtils();
    public static final int ADTS_SIZE = 7;
    @NotNull
    private static final int[] AUDIO_SAMPLING_RATES;

    private AudioUtils() {
    }

    @NotNull
    public final ByteBuffer createAdtsHeader(int type, int length, int sampleRate, int channels) {
        byte[] header = new byte[]{-1, -15, (byte)(type - 1 << 6 | this.getFrequency(sampleRate) << 2 | channels >> 2), (byte)((channels & 3) << 6 | length >> 11), (byte)((length & 0x7FF) >> 3), (byte)((byte)((length & 7) << 5) + 31), -4};
        ByteBuffer byteBuffer = ByteBuffer.wrap(header);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    public final int getFrequency(int sampleRate) {
        int frequency = ArraysKt.indexOf((int[])AUDIO_SAMPLING_RATES, (int)sampleRate);
        if (frequency == -1) {
            frequency = 4;
        }
        return frequency;
    }

    static {
        int[] nArray = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
        AUDIO_SAMPLING_RATES = nArray;
    }
}

