/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.TimeUtils;
import com.pedro.common.frame.MediaFrame;
import java.util.Collection;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\rJ\u0006\u0010\u001a\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pedro/common/StreamBlockingQueue;", "", "size", "", "<init>", "(I)V", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lcom/pedro/common/frame/MediaFrame;", "cacheQueue", "cacheTimeFilled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cacheTime", "", "startTs", "trySend", "", "item", "take", "remainingCapacity", "drainTo", "", "destiny", "clear", "setCacheTime", "cache", "getSize", "common_release"})
public final class StreamBlockingQueue {
    @NotNull
    private final PriorityBlockingQueue<MediaFrame> queue;
    @NotNull
    private PriorityBlockingQueue<MediaFrame> cacheQueue;
    @NotNull
    private AtomicBoolean cacheTimeFilled;
    private long cacheTime;
    private long startTs;

    public StreamBlockingQueue(int size) {
        this.queue = new PriorityBlockingQueue(size, (arg_0, arg_1) -> StreamBlockingQueue.queue$lambda$1(StreamBlockingQueue::queue$lambda$0, arg_0, arg_1));
        this.cacheQueue = new PriorityBlockingQueue(200, (arg_0, arg_1) -> StreamBlockingQueue.cacheQueue$lambda$3(StreamBlockingQueue::cacheQueue$lambda$2, arg_0, arg_1));
        this.cacheTimeFilled = new AtomicBoolean(false);
    }

    public final boolean trySend(@NotNull MediaFrame item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.cacheTime > 0L && !this.cacheTimeFilled.get()) {
            long t;
            if (this.startTs == 0L) {
                this.startTs = TimeUtils.getCurrentTimeMillis();
            }
            if ((t = TimeUtils.getCurrentTimeMillis() - this.startTs) >= this.cacheTime) {
                this.cacheTimeFilled.set(true);
            }
        }
        try {
            if (this.cacheTime > 0L) {
                this.cacheQueue.add(item);
                if (this.cacheTimeFilled.get()) {
                    this.queue.add(this.cacheQueue.take());
                }
            } else {
                this.queue.add(item);
            }
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @NotNull
    public final MediaFrame take() {
        MediaFrame mediaFrame = this.queue.take();
        Intrinsics.checkNotNullExpressionValue((Object)mediaFrame, (String)"take(...)");
        return mediaFrame;
    }

    public final int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public final void drainTo(@NotNull StreamBlockingQueue destiny) {
        Intrinsics.checkNotNullParameter((Object)destiny, (String)"destiny");
        this.queue.drainTo((Collection<MediaFrame>)destiny.queue);
        this.cacheQueue.drainTo((Collection<MediaFrame>)destiny.cacheQueue);
    }

    public final void clear() {
        this.queue.clear();
        this.cacheQueue.clear();
        this.startTs = 0L;
        this.cacheTimeFilled.set(false);
    }

    public final void setCacheTime(long cache) {
        this.cacheTime = cache;
        this.cacheQueue = new PriorityBlockingQueue((int)(cache / (long)5), (arg_0, arg_1) -> StreamBlockingQueue.setCacheTime$lambda$5(StreamBlockingQueue::setCacheTime$lambda$4, arg_0, arg_1));
    }

    public final int getSize() {
        return this.queue.size();
    }

    private static final int queue$lambda$0(MediaFrame p0, MediaFrame p1) {
        return ExtensionsKt.compare(p0.getInfo().getTimestamp(), p1.getInfo().getTimestamp());
    }

    private static final int queue$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int cacheQueue$lambda$2(MediaFrame p0, MediaFrame p1) {
        return ExtensionsKt.compare(p0.getInfo().getTimestamp(), p1.getInfo().getTimestamp());
    }

    private static final int cacheQueue$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int setCacheTime$lambda$4(MediaFrame p0, MediaFrame p1) {
        return ExtensionsKt.compare(p0.getInfo().getTimestamp(), p1.getInfo().getTimestamp());
    }

    private static final int setCacheTime$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

