/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.radiorealbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import co.ceryle.radiorealbutton.BackgroundView;
import co.ceryle.radiorealbutton.ConversionHelper;
import co.ceryle.radiorealbutton.R;
import co.ceryle.radiorealbutton.RadioRealButton;
import co.ceryle.radiorealbutton.RoundHelper;
import co.ceryle.radiorealbutton.RoundedCornerLayout;
import java.util.ArrayList;
import java.util.List;

public class RadioRealButtonGroup
extends RoundedCornerLayout
implements RadioRealButton.OnSelectorColorChangedListener {
    private View v_bottomLine;
    private LinearLayout container;
    private LinearLayout selectorContainer;
    private List<View> v_selectors = new ArrayList<View>();
    private List<RadioRealButton> buttons = new ArrayList<RadioRealButton>();
    private Interpolator interpolatorDrawablesEnter;
    private Interpolator interpolatorText;
    private Interpolator interpolatorSelector;
    private Interpolator interpolatorDrawablesExit;
    private Interpolator interpolatorTextExit;
    private int borderSize;
    private int borderColor;
    private int dividerColor;
    private int bottomLineColor;
    private int selectorColor;
    private int animateDrawablesEnter;
    private int animateTextsEnter;
    private int animationType;
    private int animateDrawablesEnterDuration;
    private int animateTextsEnterDuration;
    private int animateSelector;
    private int animateSelectorDuration;
    private int animateSelectorDelay;
    private int animateDrawablesExit;
    private int animateDrawablesExitDuration;
    private int animateTextsExit;
    private int animateTextsExitDuration;
    private int lastPosition;
    private int buttonPadding;
    private int buttonPaddingLeft;
    private int buttonPaddingRight;
    private int buttonPaddingTop;
    private int buttonPaddingBottom;
    private int groupBackgroundColor;
    private int dividerPadding;
    private int dividerSize;
    private int dividerRadius;
    private int bottomLineSize;
    private int bottomLineRadius;
    private int selectorSize;
    private int selectorRadius;
    private int initialPosition;
    private int selectorDividerSize;
    private int selectorDividerRadius;
    private int selectorDividerColor;
    private int selectorDividerPadding;
    private int checkedButtonId;
    private int animateTextsColorExit;
    private int animateTextsColorEnter;
    private int animateTextsColorDuration;
    private int animateTextsColorDurationExit;
    private int animateTextsColorDurationEnter;
    private int animateDrawablesTintExit;
    private int animateDrawablesTintEnter;
    private int animateDrawablesTintDuration;
    private int animateDrawablesTintDurationExit;
    private int animateDrawablesTintDurationEnter;
    private float radius;
    private float animateDrawablesScale;
    private float animateTextsScale;
    private boolean bottomLineBringToFront;
    private boolean selectorBringToFront;
    private boolean selectorAboveOfBottomLine;
    private boolean selectorTop;
    private boolean selectorBottom;
    private boolean hasPadding;
    private boolean hasPaddingLeft;
    private boolean hasPaddingRight;
    private boolean hasPaddingTop;
    private boolean hasPaddingBottom;
    private boolean clickable;
    private boolean enabled;
    private boolean enableDeselection;
    private boolean hasEnabled;
    private boolean hasClickable;
    private boolean hasBorder;
    private boolean hasAnimateDrawables;
    private boolean hasAnimateTexts;
    private boolean hasAnimation;
    private boolean selectorFullSize;
    private boolean hasAnimateTextsColor;
    private boolean hasAnimateDrawablesTint;
    private int numberOfButtons = 0;
    public final int ANIM_TRANSLATE_X = 0;
    public final int ANIM_TRANSLATE_Y = 1;
    public final int ANIM_SCALE_X = 2;
    public final int ANIM_SCALE_Y = 3;
    public final int ANIM_ALPHA = 4;
    private OnClickedButtonListener onClickedButtonListener;
    private OnPositionChangedListener onPositionChangedListener;

    public RadioRealButtonGroup(Context context) {
        super(context);
        this.init(null);
    }

    public RadioRealButtonGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public RadioRealButtonGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("state", super.onSaveInstanceState());
        bundle.putInt("position", this.lastPosition);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            state = bundle.getParcelable("state");
            int position = bundle.getInt("position");
            if (this.lastPosition != position) {
                if (this.animationType == 0) {
                    if (this.initialPosition != -1) {
                        this.v_selectors.get(this.initialPosition).setVisibility(4);
                    }
                    this.v_selectors.get(position).setVisibility(0);
                    this.lastPosition = this.initialPosition = position;
                }
                this.setPosition(position, false);
            }
        }
        super.onRestoreInstanceState(state);
    }

    private void init(AttributeSet attrs) {
        this.getAttributes(attrs);
        this.setBorderAttrs();
        this.initViews();
        this.setBottomLineAttrs();
        this.setSelectorAttrs();
        this.initInterpolations();
        this.setState();
    }

    private void initViews() {
        this.setCornerRadius(this.radius);
        BackgroundView backgroundView = new BackgroundView(this.getContext());
        backgroundView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        backgroundView.setBackgroundColor(this.groupBackgroundColor);
        this.addView(backgroundView);
        this.selectorContainer = new LinearLayout(this.getContext());
        this.selectorContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.selectorContainer.setOrientation(0);
        this.selectorContainer.setShowDividers(2);
        RoundHelper.makeDividerRound(this.selectorContainer, this.selectorDividerColor, this.selectorDividerRadius, this.selectorDividerSize);
        if (Build.VERSION.SDK_INT >= 14) {
            this.selectorContainer.setDividerPadding(this.selectorDividerPadding);
        }
        this.addView((View)this.selectorContainer);
        this.container = new LinearLayout(this.getContext());
        this.container.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.container.setOrientation(0);
        this.container.setShowDividers(2);
        RoundHelper.makeDividerRound(this.container, this.dividerColor, this.dividerRadius, this.dividerSize);
        if (Build.VERSION.SDK_INT >= 14) {
            this.container.setDividerPadding(this.dividerPadding);
        }
        this.addView((View)this.container);
        this.v_bottomLine = new View(this.getContext());
        this.v_bottomLine.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, 3));
        this.addView(this.v_bottomLine);
    }

    private void setBottomLineAttrs() {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.v_bottomLine.getLayoutParams();
        layoutParams.height = this.bottomLineSize;
        if (this.bottomLineBringToFront) {
            this.v_bottomLine.bringToFront();
        }
        this.updateViewBottomLine();
    }

    private void setSelectorAttrs() {
        FrameLayout.LayoutParams selectorParams = (FrameLayout.LayoutParams)this.selectorContainer.getLayoutParams();
        FrameLayout.LayoutParams bottomLineParams = (FrameLayout.LayoutParams)this.v_bottomLine.getLayoutParams();
        if (this.selectorBringToFront) {
            this.selectorContainer.bringToFront();
        }
        if (!this.selectorFullSize) {
            selectorParams.height = this.selectorSize;
        }
        int topMargin = 0;
        int bottomMargin = 0;
        if (this.selectorTop) {
            selectorParams.gravity = 48;
            bottomLineParams.gravity = 48;
            topMargin = this.bottomLineSize;
        } else if (this.selectorBottom) {
            selectorParams.gravity = 80;
            bottomLineParams.gravity = 80;
            bottomMargin = this.bottomLineSize;
        }
        if (this.selectorAboveOfBottomLine) {
            selectorParams.setMargins(0, topMargin, 0, bottomMargin);
        }
    }

    private void initInterpolations() {
        Class[] interpolations = new Class[]{FastOutSlowInInterpolator.class, BounceInterpolator.class, LinearInterpolator.class, DecelerateInterpolator.class, CycleInterpolator.class, AnticipateInterpolator.class, AccelerateDecelerateInterpolator.class, AccelerateInterpolator.class, AnticipateOvershootInterpolator.class, FastOutLinearInInterpolator.class, LinearOutSlowInInterpolator.class, OvershootInterpolator.class};
        try {
            this.interpolatorText = (Interpolator)interpolations[this.animateTextsEnter].newInstance();
            this.interpolatorDrawablesEnter = (Interpolator)interpolations[this.animateDrawablesEnter].newInstance();
            this.interpolatorSelector = (Interpolator)interpolations[this.animateSelector].newInstance();
            this.interpolatorTextExit = (Interpolator)interpolations[this.animateTextsExit].newInstance();
            this.interpolatorDrawablesExit = (Interpolator)interpolations[this.animateDrawablesExit].newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBorderAttrs() {
        this.setStroke(this.hasBorder);
        this.setStrokeColor(this.borderColor);
        this.setStrokeSize(this.borderSize);
    }

    private void getAttributes(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.RadioRealButtonGroup);
        this.hasAnimateTextsColor = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColorTo);
        this.animateTextsColorExit = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColorFrom, -7829368);
        this.animateTextsColorEnter = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColorTo, -16777216);
        int animateTextsColorDuration = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColor_duration, 500) / 2;
        this.animateTextsColorDurationExit = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColorFrom_duration, animateTextsColorDuration);
        this.animateTextsColorDurationEnter = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_textColorTo_duration, animateTextsColorDuration);
        this.hasAnimateDrawablesTint = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColorTo);
        this.animateDrawablesTintExit = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColorFrom, -7829368);
        this.animateDrawablesTintEnter = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColorTo, -16777216);
        int animateDrawablesTintDuration = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColor_duration, 500) / 2;
        this.animateDrawablesTintDurationExit = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColorFrom_duration, animateDrawablesTintDuration);
        this.animateDrawablesTintDurationEnter = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_tintColorTo_duration, animateDrawablesTintDuration);
        this.bottomLineColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_bottomLineColor, -7829368);
        this.bottomLineSize = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_bottomLineSize, 0);
        this.bottomLineBringToFront = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_bottomLineBringToFront, false);
        this.bottomLineRadius = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_bottomLineRadius, 0);
        this.selectorColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_selectorColor, -7829368);
        this.selectorBringToFront = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_selectorBringToFront, false);
        this.selectorAboveOfBottomLine = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_selectorAboveOfBottomLine, false);
        this.selectorSize = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_selectorSize, 12);
        this.selectorRadius = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_selectorRadius, 0);
        this.animateSelector = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateSelector, 0);
        this.animateSelectorDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateSelector_duration, 500);
        this.animateSelectorDelay = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateSelector_delay, 0);
        this.dividerSize = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_dividerSize, 0);
        boolean hasDividerSize = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_dividerSize);
        this.dividerRadius = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_dividerRadius, 0);
        this.dividerPadding = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_dividerPadding, 30);
        this.dividerColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_dividerColor, 0);
        this.selectorDividerSize = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_selectorDividerSize, this.dividerSize);
        if (!hasDividerSize) {
            this.dividerSize = this.selectorDividerSize;
        }
        this.selectorDividerRadius = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_selectorDividerRadius, 0);
        this.selectorDividerPadding = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_selectorDividerPadding, 0);
        this.selectorDividerColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_selectorDividerColor, 0);
        this.radius = ta.getDimension(R.styleable.RadioRealButtonGroup_rrbg_radius, 0.0f);
        this.animateDrawablesEnter = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_enter, 0);
        this.hasAnimateDrawables = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_enter);
        this.animateDrawablesExit = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_exit, 0);
        int animateDrawablesDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_duration, 500) / 2;
        this.animateDrawablesEnterDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_enterDuration, animateDrawablesDuration);
        this.animateDrawablesExitDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_exitDuration, animateDrawablesDuration);
        this.animateDrawablesScale = ta.getFloat(R.styleable.RadioRealButtonGroup_rrbg_animateDrawables_scale, 1.2f);
        this.animateTextsEnter = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_enter, 0);
        this.hasAnimateTexts = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_enter);
        this.animateTextsExit = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_exit, 0);
        int animateTextsDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_duration, 500) / 2;
        this.animateTextsEnterDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_enterDuration, animateTextsDuration);
        this.animateTextsExitDuration = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_exitDuration, animateTextsDuration);
        this.animateTextsScale = ta.getFloat(R.styleable.RadioRealButtonGroup_rrbg_animateTexts_scale, 1.2f);
        this.lastPosition = this.initialPosition = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_checkedPosition, -1);
        this.checkedButtonId = ta.getResourceId(R.styleable.RadioRealButtonGroup_rrbg_checkedButton, -1);
        this.buttonPadding = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_buttonsPadding, 0);
        this.buttonPaddingLeft = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingLeft, 0);
        this.buttonPaddingRight = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingRight, 0);
        this.buttonPaddingTop = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingTop, 0);
        this.buttonPaddingBottom = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingBottom, 0);
        this.hasPadding = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_buttonsPadding);
        this.hasPaddingLeft = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingLeft);
        this.hasPaddingRight = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingRight);
        this.hasPaddingTop = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingTop);
        this.hasPaddingBottom = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_buttonsPaddingBottom);
        this.groupBackgroundColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_backgroundColor, -1);
        this.selectorTop = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_selectorTop, false);
        this.selectorBottom = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_selectorBottom, true);
        this.borderSize = ta.getDimensionPixelSize(R.styleable.RadioRealButtonGroup_rrbg_borderSize, ConversionHelper.dpToPx(this.getContext(), 1.0f));
        this.borderColor = ta.getColor(R.styleable.RadioRealButtonGroup_rrbg_borderColor, -16777216);
        boolean hasBorderSize = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_borderSize);
        boolean hasBorderColor = ta.hasValue(R.styleable.RadioRealButtonGroup_rrbg_borderColor);
        this.hasBorder = hasBorderColor || hasBorderSize;
        this.clickable = ta.getBoolean(R.styleable.RadioRealButtonGroup_android_clickable, true);
        this.hasClickable = ta.hasValue(R.styleable.RadioRealButtonGroup_android_clickable);
        this.enabled = ta.getBoolean(R.styleable.RadioRealButtonGroup_android_enabled, true);
        this.hasEnabled = ta.hasValue(R.styleable.RadioRealButtonGroup_android_enabled);
        this.animationType = ta.getInt(R.styleable.RadioRealButtonGroup_rrbg_selectorAnimationType, 0);
        this.enableDeselection = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_enableDeselection, false);
        this.hasAnimation = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_animate, true);
        this.selectorFullSize = ta.getBoolean(R.styleable.RadioRealButtonGroup_rrbg_selectorFullSize, false);
        ta.recycle();
    }

    private void setButtonPadding(RadioRealButton button) {
        if (this.hasPadding) {
            button.setPaddings(this.buttonPadding, this.buttonPadding, this.buttonPadding, this.buttonPadding);
        } else if (this.hasPaddingBottom || this.hasPaddingTop || this.hasPaddingLeft || this.hasPaddingRight) {
            button.setPaddings(this.buttonPaddingLeft, this.buttonPaddingTop, this.buttonPaddingRight, this.buttonPaddingBottom);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof RadioRealButton) {
            RadioRealButton button = (RadioRealButton)child;
            int position = this.buttons.size();
            int id = button.getId();
            if (this.lastPosition == -1) {
                if (this.checkedButtonId != -1 && this.checkedButtonId == id) {
                    this.lastPosition = this.initialPosition = position;
                } else if (this.checkedButtonId == -1 && button.isChecked()) {
                    this.lastPosition = this.initialPosition = position;
                }
            }
            if (this.lastPosition == position) {
                button.setChecked(true);
                if (this.hasAnimateDrawables) {
                    button.bounceDrawable(this.animateDrawablesScale);
                }
                if (this.hasAnimateTexts) {
                    button.bounceText(this.animateTextsScale);
                }
                if (button.hasTextColorTo()) {
                    button.setCheckedTextColor(button.getTextColorTo());
                } else if (this.hasAnimateTextsColor) {
                    button.setCheckedTextColor(this.animateTextsColorEnter);
                }
                if (button.hasDrawableTintTo()) {
                    button.setCheckedDrawableTint(button.getDrawableTintTo());
                } else if (this.hasAnimateDrawablesTint) {
                    button.setCheckedDrawableTint(this.animateDrawablesTintEnter);
                }
            } else {
                button.setChecked(false);
                if (!button.hasTextColor() && this.hasAnimateTextsColor) {
                    button.setTextColor(this.animateTextsColorExit);
                }
                if (!button.hasDrawableTint() && this.hasAnimateDrawablesTint) {
                    button.setDrawableTint(this.animateDrawablesTintExit);
                }
            }
            this.initButtonListener(button, position);
            this.setButtonPadding(button);
            this.container.addView((View)button);
            this.createSelectorItem(position, button);
            this.buttons.add(button);
            this.numberOfButtons = this.buttons.size();
        } else {
            super.addView(child, index, params);
        }
    }

    private void createSelectorItem(int position, RadioRealButton button) {
        BackgroundView view = new BackgroundView(this.getContext());
        int height = this.selectorSize;
        if (this.selectorFullSize) {
            height = -1;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, height, 1.0f));
        boolean value = false;
        if (position == this.lastPosition) {
            value = true;
        }
        switch (this.animationType) {
            case 2: {
                view.setScaleX((float)value);
                break;
            }
            case 3: {
                view.setScaleY((float)value);
                break;
            }
            case 0: {
                if (value) break;
                view.setVisibility(4);
                break;
            }
            case 1: {
                view.setTranslationY(value ? (float)value : (float)this.selectorSize);
                break;
            }
            case 4: {
                view.setAlpha((float)value);
            }
        }
        button.setOnSelectorColorChangedListener(this, position);
        this.updateViewSelectorColor(view, button.hasSelectorColor() ? button.getSelectorColor() : this.selectorColor);
        this.v_selectors.add(view);
        this.selectorContainer.addView((View)view);
    }

    private void initButtonListener(RadioRealButton button, final int position) {
        boolean isClickable = button.isClickable();
        boolean isEnabled = button.isEnabled();
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RadioRealButtonGroup.this.makeSelection(position, true, RadioRealButtonGroup.this.hasAnimation);
            }
        });
        if (this.hasEnabled || this.hasClickable) {
            button.setClickable(this.clickable && this.enabled);
        } else if (button.hasClickable()) {
            button.setClickable(isClickable);
        } else if (button.hasEnabled()) {
            button.setEnabled(isEnabled);
        }
    }

    public int getNumberOfButtons() {
        return this.numberOfButtons;
    }

    public void setPosition(int position) {
        this.makeSelection(position, false, this.hasAnimation);
    }

    public void setPosition(int position, boolean hasAnimation) {
        this.makeSelection(position, false, hasAnimation);
    }

    public void deselect() {
        this.deselect(this.hasAnimation);
    }

    public void deselect(boolean hasAnimation) {
        if (this.lastPosition == -1 || !this.buttons.get(this.lastPosition).isChecked()) {
            return;
        }
        this.makeSelection(this.lastPosition, false, hasAnimation, true);
    }

    private boolean isInRange(int value) {
        return value >= 0 && value < this.numberOfButtons;
    }

    private void makeSelection(int position, boolean isToggledByTouch, boolean hasAnimation) {
        this.makeSelection(position, isToggledByTouch, hasAnimation, this.enableDeselection);
    }

    private void makeSelection(int position, boolean isToggledByTouch, boolean hasAnimation, boolean enableDeselection) {
        RadioRealButton buttonOut;
        if (!this.enabled && !this.clickable) {
            return;
        }
        RadioRealButton buttonIn = this.isInRange(position) ? this.buttons.get(position) : null;
        RadioRealButton radioRealButton = buttonOut = this.isInRange(this.lastPosition) ? this.buttons.get(this.lastPosition) : null;
        if (buttonIn == null || !buttonIn.isClickable() || !buttonIn.isEnabled()) {
            return;
        }
        this.moveSelector(position, hasAnimation, enableDeselection);
        this.animateTextAndDrawable(position, hasAnimation, buttonIn, buttonOut, enableDeselection);
        if (!enableDeselection) {
            buttonIn.setChecked(true);
            if (null != buttonOut) {
                buttonOut.setChecked(false);
            }
        } else if (this.lastPosition == position && buttonIn.isChecked()) {
            buttonIn.setChecked(false);
            position = -1;
        } else {
            buttonIn.setChecked(true);
        }
        if (null != this.onClickedButtonListener && isToggledByTouch) {
            this.onClickedButtonListener.onClickedButton(buttonIn, position);
        }
        if (null != this.onPositionChangedListener && (this.lastPosition != position || enableDeselection)) {
            this.onPositionChangedListener.onPositionChanged(buttonIn, position, this.lastPosition);
        }
        this.lastPosition = position;
    }

    public int getPosition() {
        return this.lastPosition;
    }

    private void animateTextAndDrawable(int toPosition, boolean hasAnimation, RadioRealButton buttonIn, RadioRealButton buttonOut, boolean enableDeselection) {
        if (this.lastPosition == toPosition && enableDeselection) {
            if (buttonIn.isChecked()) {
                this.animateExit(buttonIn, hasAnimation);
            } else {
                this.animateEnter(buttonIn, hasAnimation);
            }
        } else {
            if (null != buttonOut) {
                this.animateExit(buttonOut, hasAnimation);
            }
            if (null != buttonIn) {
                this.animateEnter(buttonIn, hasAnimation);
            }
        }
    }

    private void animateColorTransitions(RadioRealButton button, boolean hasAnimation, boolean onEnter) {
        int textDuration = onEnter ? this.animateTextsColorDurationEnter : this.animateTextsColorDurationExit;
        int drawableDuration = onEnter ? this.animateDrawablesTintDurationEnter : this.animateDrawablesTintDurationExit;
        button.colorTransitionText(this.hasAnimateTextsColor, this.animateTextsColorExit, this.animateTextsColorEnter, textDuration, hasAnimation, onEnter);
        button.colorTransitionDrawable(this.hasAnimateDrawablesTint, this.animateDrawablesTintExit, this.animateDrawablesTintEnter, drawableDuration, hasAnimation, onEnter);
    }

    private void animateExit(RadioRealButton button, boolean hasAnimation) {
        if (this.hasAnimateTexts) {
            button.bounceText(1.0f, this.animateTextsExitDuration, this.interpolatorTextExit, hasAnimation);
        }
        if (this.hasAnimateDrawables) {
            button.bounceDrawable(1.0f, this.animateDrawablesExitDuration, this.interpolatorDrawablesExit, hasAnimation);
        }
        this.animateColorTransitions(button, hasAnimation, false);
    }

    private void animateEnter(RadioRealButton button, boolean hasAnimation) {
        if (this.hasAnimateTexts) {
            button.bounceText(this.animateTextsScale, this.animateTextsEnterDuration, this.interpolatorText, hasAnimation);
        }
        if (this.hasAnimateDrawables) {
            button.bounceDrawable(this.animateDrawablesScale, this.animateDrawablesEnterDuration, this.interpolatorDrawablesEnter, hasAnimation);
        }
        this.animateColorTransitions(button, hasAnimation, true);
    }

    private void moveSelector(int toPosition, boolean hasAnimation, boolean enableDeselection) {
        if (toPosition == this.lastPosition && !enableDeselection) {
            return;
        }
        String[] properties = new String[]{"translationX", "translationY", "scaleX", "scaleY", "alpha", "translationY"};
        if (this.animationType == 0) {
            this.animateSelectorSliding(toPosition, properties[this.animationType], hasAnimation, enableDeselection);
        } else {
            this.animateSelector(toPosition, properties[this.animationType], hasAnimation, enableDeselection);
        }
    }

    private void animateSelector(int toPosition, String property, boolean hasAnimation, boolean enableDeselection) {
        int value1 = 0;
        int value2 = 1;
        if (this.animationType == 1) {
            value1 = this.selectorSize;
            value2 = 0;
        }
        if (enableDeselection && toPosition == this.lastPosition && !this.buttons.get(toPosition).isChecked()) {
            int temp = value1;
            value1 = value2;
            value2 = temp;
        }
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator to = this.createAnimator(this.v_selectors.get(toPosition), property, value2, false, hasAnimation);
        if (this.lastPosition > -1) {
            ObjectAnimator from = this.createAnimator(this.v_selectors.get(this.lastPosition), property, value1, true, hasAnimation);
            set.playTogether(new Animator[]{to, from});
        } else {
            set.play((Animator)to);
        }
        set.start();
    }

    private void animateSelectorSliding(int toPosition, String property, boolean hasAnimation, boolean enableDeselection) {
        boolean isViewDrawn;
        boolean bl = isViewDrawn = this.buttons.size() > 0 && this.buttons.get(0).getWidth() > 0;
        if (!isViewDrawn) {
            if (this.initialPosition != -1) {
                this.v_selectors.get(this.initialPosition).setVisibility(4);
            }
            this.v_selectors.get(toPosition).setVisibility(0);
            this.initialPosition = toPosition;
            return;
        }
        if (this.initialPosition < 0) {
            this.initialPosition = 0;
            View view = this.v_selectors.get(this.initialPosition);
            view.setTranslationX((float)(-this.buttons.get(this.initialPosition).getMeasuredWidth()));
            view.setVisibility(0);
        }
        if (enableDeselection && toPosition == this.lastPosition && this.buttons.get(toPosition).isChecked()) {
            toPosition = this.lastPosition > this.numberOfButtons / 2 ? this.numberOfButtons : -1;
        }
        float position = toPosition - this.initialPosition;
        float value = (float)this.buttons.get(this.initialPosition).getMeasuredWidth() * position + (float)this.dividerSize * position;
        ObjectAnimator animator = this.createAnimator(this.v_selectors.get(this.initialPosition), property, value, false, hasAnimation);
        animator.start();
    }

    private ObjectAnimator createAnimator(View view, String property, float value, boolean hasDelay, boolean hasDuration) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)property, (float[])new float[]{value});
        animator.setInterpolator((TimeInterpolator)this.interpolatorSelector);
        if (hasDuration) {
            animator.setDuration((long)this.animateSelectorDuration);
        } else {
            animator.setDuration(0L);
        }
        if (hasDelay) {
            animator.setStartDelay((long)this.animateSelectorDelay);
        }
        return animator;
    }

    private void setRippleState(boolean state) {
        for (RadioRealButton b : this.buttons) {
            b.setClickable(state);
        }
    }

    private void setState() {
        if (this.hasEnabled) {
            this.setEnabled(this.enabled);
        } else if (this.hasClickable) {
            this.setClickable(this.clickable);
        }
    }

    private void setEnabledAlpha(boolean enabled) {
        float alpha = 1.0f;
        if (!enabled) {
            alpha = 0.5f;
        }
        this.setAlpha(alpha);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setEnabledAlpha(enabled);
        this.setRippleState(enabled);
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
        this.setRippleState(clickable);
    }

    public void setOnClickedButtonListener(OnClickedButtonListener onClickedButtonListener) {
        this.onClickedButtonListener = onClickedButtonListener;
    }

    public void setOnPositionChangedListener(OnPositionChangedListener onPositionChangedListener) {
        this.onPositionChangedListener = onPositionChangedListener;
    }

    public void setOnLongClickedButtonListener(final OnLongClickedButtonListener onLongClickedButtonListener) {
        for (int i = 0; i < this.numberOfButtons; ++i) {
            final int buttonPosition = i;
            this.buttons.get(i).setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return onLongClickedButtonListener == null || onLongClickedButtonListener.onLongClickedButton((RadioRealButton)v, buttonPosition);
                }
            });
        }
    }

    public int getAnimateTextsColorExit() {
        return this.animateTextsColorExit;
    }

    public void setAnimateTextsColorExit(int animateTextsColorExit) {
        this.animateTextsColorExit = animateTextsColorExit;
    }

    public int getAnimateTextsColorEnter() {
        return this.animateTextsColorEnter;
    }

    public void setAnimateTextsColorEnter(int animateTextsColorEnter) {
        this.animateTextsColorEnter = animateTextsColorEnter;
    }

    public int getAnimateTextsColorDuration() {
        return this.animateTextsColorDuration;
    }

    public void setAnimateTextsColorDuration(int animateTextsColorDuration) {
        this.animateTextsColorDuration = animateTextsColorDuration;
    }

    public int getAnimateDrawablesTintExit() {
        return this.animateDrawablesTintExit;
    }

    public void setAnimateDrawablesTintExit(int animateDrawablesTintExit) {
        this.animateDrawablesTintExit = animateDrawablesTintExit;
    }

    public int getAnimateDrawablesTintEnter() {
        return this.animateDrawablesTintEnter;
    }

    public void setAnimateDrawablesTintEnter(int animateDrawablesTintEnter) {
        this.animateDrawablesTintEnter = animateDrawablesTintEnter;
    }

    public int getAnimateDrawablesTintColorDuration() {
        return this.animateDrawablesTintDuration;
    }

    public void setAnimateDrawablesTintColorDuration(int animateDrawablesTintColorDuration) {
        this.animateDrawablesTintDuration = animateDrawablesTintColorDuration;
    }

    public List<RadioRealButton> getButtons() {
        return this.buttons;
    }

    public Interpolator getInterpolatorDrawablesEnter() {
        return this.interpolatorDrawablesEnter;
    }

    public void setInterpolatorDrawablesEnter(Interpolator interpolatorDrawablesEnter) {
        this.interpolatorDrawablesEnter = interpolatorDrawablesEnter;
    }

    public Interpolator getInterpolatorText() {
        return this.interpolatorText;
    }

    public void setInterpolatorText(Interpolator interpolatorText) {
        this.interpolatorText = interpolatorText;
    }

    public Interpolator getInterpolatorSelector() {
        return this.interpolatorSelector;
    }

    public void setInterpolatorSelector(Interpolator interpolatorSelector) {
        this.interpolatorSelector = interpolatorSelector;
    }

    public Interpolator getInterpolatorDrawablesExit() {
        return this.interpolatorDrawablesExit;
    }

    public void setInterpolatorDrawablesExit(Interpolator interpolatorDrawablesExit) {
        this.interpolatorDrawablesExit = interpolatorDrawablesExit;
    }

    public Interpolator getInterpolatorTextExit() {
        return this.interpolatorTextExit;
    }

    public void setInterpolatorTextExit(Interpolator interpolatorTextExit) {
        this.interpolatorTextExit = interpolatorTextExit;
    }

    public int getAnimateTextsEnter() {
        return this.animateTextsEnter;
    }

    public void setAnimateTextsEnter(int animateTextsEnter) {
        this.animateTextsEnter = animateTextsEnter;
    }

    public int getAnimationType() {
        return this.animationType;
    }

    public void setAnimationType(int animationType) {
        this.animationType = animationType;
    }

    public int getAnimateDrawablesEnterDuration() {
        return this.animateDrawablesEnterDuration;
    }

    public void setAnimateDrawablesEnterDuration(int animateDrawablesEnterDuration) {
        this.animateDrawablesEnterDuration = animateDrawablesEnterDuration;
    }

    public int getAnimateTextsEnterDuration() {
        return this.animateTextsEnterDuration;
    }

    public void setAnimateTextsEnterDuration(int animateTextsEnterDuration) {
        this.animateTextsEnterDuration = animateTextsEnterDuration;
    }

    public int getAnimateSelector() {
        return this.animateSelector;
    }

    public void setAnimateSelector(int animateSelector) {
        this.animateSelector = animateSelector;
    }

    public int getAnimateSelectorDuration() {
        return this.animateSelectorDuration;
    }

    public void setAnimateSelectorDuration(int animateSelectorDuration) {
        this.animateSelectorDuration = animateSelectorDuration;
    }

    public int getAnimateSelectorDelay() {
        return this.animateSelectorDelay;
    }

    public void setAnimateSelectorDelay(int animateSelectorDelay) {
        this.animateSelectorDelay = animateSelectorDelay;
    }

    public int getAnimateDrawablesExitDuration() {
        return this.animateDrawablesExitDuration;
    }

    public void setAnimateDrawablesExitDuration(int animateDrawablesExitDuration) {
        this.animateDrawablesExitDuration = animateDrawablesExitDuration;
    }

    public int getAnimateTextsExit() {
        return this.animateTextsExit;
    }

    public void setAnimateTextsExit(int animateTextsExit) {
        this.animateTextsExit = animateTextsExit;
    }

    public int getAnimateTextsExitDuration() {
        return this.animateTextsExitDuration;
    }

    public void setAnimateTextsExitDuration(int animateTextsExitDuration) {
        this.animateTextsExitDuration = animateTextsExitDuration;
    }

    private void setButtonsPadding(int left, int top, int right, int bottom) {
        this.buttonPaddingLeft = left;
        this.buttonPaddingTop = top;
        this.buttonPaddingRight = right;
        this.buttonPaddingBottom = bottom;
        for (RadioRealButton button : this.buttons) {
            this.setButtonPadding(button);
        }
    }

    public int getButtonsPadding() {
        return this.buttonPadding;
    }

    public int getButtonsPaddingLeft() {
        return this.buttonPaddingLeft;
    }

    public int getButtonsPaddingRight() {
        return this.buttonPaddingRight;
    }

    public int getButtonsPaddingTop() {
        return this.buttonPaddingTop;
    }

    public int getButtonsPaddingBottom() {
        return this.buttonPaddingBottom;
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public void setDividerPadding(int dividerPadding) {
        this.dividerPadding = dividerPadding;
        if (Build.VERSION.SDK_INT >= 14) {
            this.container.setDividerPadding(dividerPadding);
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
        RoundHelper.makeDividerRound(this.container, this.dividerColor, this.dividerRadius, dividerSize);
    }

    public int getDividerRadius() {
        return this.dividerRadius;
    }

    public void setDividerRadius(int dividerRadius) {
        this.dividerRadius = dividerRadius;
        RoundHelper.makeDividerRound(this.container, this.dividerColor, dividerRadius, this.dividerSize);
    }

    public int getBottomLineSize() {
        return this.bottomLineSize;
    }

    public void setBottomLineSize(int bottomLineSize) {
        this.bottomLineSize = bottomLineSize;
        this.setBottomLineAttrs();
    }

    public int getBottomLineRadius() {
        return this.bottomLineRadius;
    }

    public void setBottomLineRadius(int bottomLineRadius) {
        this.bottomLineRadius = bottomLineRadius;
        this.updateViewBottomLine();
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        this.setBorderAttrs();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.setBorderAttrs();
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        RoundHelper.makeDividerRound(this.container, dividerColor, this.dividerRadius, this.dividerSize);
    }

    public int getBottomLineColor() {
        return this.bottomLineColor;
    }

    public void setBottomLineColor(int bottomLineColor) {
        this.bottomLineColor = bottomLineColor;
        this.updateViewBottomLine();
    }

    private void updateViewBottomLine() {
        RoundHelper.makeRound(this.v_bottomLine, this.bottomLineColor, this.bottomLineRadius, this.bottomLineRadius);
    }

    public int getSelectorColor() {
        return this.selectorColor;
    }

    private void updateViewSelectorColor(View view, int color) {
        this.updateViewSelector(view, color, this.selectorRadius, this.selectorSize);
    }

    public void setSelectorColor(int selectorColor) {
        this.selectorColor = selectorColor;
        for (View selector : this.v_selectors) {
            this.updateViewSelectorColor(selector, selectorColor);
        }
    }

    @Override
    public void onSelectorColorChanged(int position, int selectorColor) {
        this.updateViewSelectorColor(this.v_selectors.get(position), selectorColor);
    }

    private void updateViewSelector(View view, int color, int radius, int size) {
        RoundHelper.makeRound(view, color, radius, this.selectorFullSize ? null : Integer.valueOf(size));
    }

    private void updateViewSelector(View view) {
        this.updateViewSelector(view, this.selectorColor, this.selectorRadius, this.selectorSize);
    }

    public int getSelectorSize() {
        return this.selectorSize;
    }

    public void setSelectorSize(int selectorSize) {
        this.selectorSize = selectorSize;
        this.selectorContainer.getLayoutParams().height = selectorSize;
        for (View selector : this.v_selectors) {
            this.updateViewSelector(selector);
            selector.getLayoutParams().height = selectorSize;
            selector.requestLayout();
        }
    }

    public int getSelectorRadius() {
        return this.selectorRadius;
    }

    public void setSelectorRadius(int selectorRadius) {
        this.selectorRadius = selectorRadius;
        for (View selector : this.v_selectors) {
            this.updateViewSelector(selector);
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.setCornerRadius(radius);
    }

    public float getAnimateDrawablesScale() {
        return this.animateDrawablesScale;
    }

    public void setAnimateDrawablesScale(float animateDrawablesScale) {
        this.animateDrawablesScale = animateDrawablesScale;
    }

    public float getAnimateTextsScale() {
        return this.animateTextsScale;
    }

    public void setAnimateTextsScale(float animateTextsScale) {
        this.animateTextsScale = animateTextsScale;
    }

    public boolean isBottomLineOnFront() {
        return this.bottomLineBringToFront;
    }

    public void setBottomLineToFront(boolean bottomLineBringToFront) {
        this.bottomLineBringToFront = bottomLineBringToFront;
        this.setBottomLineAttrs();
    }

    public boolean isSelectorOnFront() {
        return this.selectorBringToFront;
    }

    public void setSelectorToFront(boolean selectorBringToFront) {
        this.selectorBringToFront = selectorBringToFront;
        this.setSelectorAttrs();
    }

    public boolean isSelectorAboveOfBottomLine() {
        return this.selectorAboveOfBottomLine;
    }

    public void setSelectorAboveOfBottomLine(boolean selectorAboveOfBottomLine) {
        this.selectorAboveOfBottomLine = selectorAboveOfBottomLine;
        this.setSelectorAttrs();
    }

    public boolean isSelectorTop() {
        return this.selectorTop;
    }

    public void setSelectorTop(boolean selectorTop) {
        this.selectorTop = selectorTop;
    }

    public boolean isSelectorBottom() {
        return this.selectorBottom;
    }

    public void setSelectorBottom(boolean selectorBottom) {
        this.selectorBottom = selectorBottom;
    }

    public boolean hasPadding() {
        return this.hasPadding;
    }

    public boolean hasPaddingLeft() {
        return this.hasPaddingLeft;
    }

    public boolean hasPaddingRight() {
        return this.hasPaddingRight;
    }

    public boolean hasPaddingTop() {
        return this.hasPaddingTop;
    }

    public boolean hasPaddingBottom() {
        return this.hasPaddingBottom;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDeselection() {
        return this.enableDeselection;
    }

    public void setDeselection(boolean deselection) {
        this.enableDeselection = deselection;
    }

    public static interface OnLongClickedButtonListener {
        public boolean onLongClickedButton(RadioRealButton var1, int var2);
    }

    public static interface OnPositionChangedListener {
        public void onPositionChanged(RadioRealButton var1, int var2, int var3);
    }

    public static interface OnClickedButtonListener {
        public void onClickedButton(RadioRealButton var1, int var2);
    }
}

