/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.utils;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class PaintUtil {
    private static final int DEFAULT_CORNER_COLOR = -1;
    private static final String SEMI_TRANSPARENT = "#AAFFFFFF";
    private static final String DEFAULT_BACKGROUND_COLOR_ID = "#B0000000";
    private static final float DEFAULT_LINE_THICKNESS_DP = 3.0f;
    private static final float DEFAULT_CORNER_THICKNESS_DP = 5.0f;
    private static final float DEFAULT_GUIDELINE_THICKNESS_PX = 1.0f;

    public static Paint newBorderPaint(Context context) {
        float lineThicknessPx = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        Paint borderPaint = new Paint();
        borderPaint.setColor(Color.parseColor((String)SEMI_TRANSPARENT));
        borderPaint.setStrokeWidth(lineThicknessPx);
        borderPaint.setStyle(Paint.Style.STROKE);
        return borderPaint;
    }

    public static Paint newGuidelinePaint() {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)SEMI_TRANSPARENT));
        paint.setStrokeWidth(1.0f);
        return paint;
    }

    public static Paint newRotateBottomImagePaint() {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setStrokeWidth(3.0f);
        return paint;
    }

    public static Paint newBackgroundPaint(Context context) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)DEFAULT_BACKGROUND_COLOR_ID));
        return paint;
    }

    public static Paint newCornerPaint(Context context) {
        float lineThicknessPx = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        Paint cornerPaint = new Paint();
        cornerPaint.setColor(-1);
        cornerPaint.setStrokeWidth(lineThicknessPx);
        cornerPaint.setStyle(Paint.Style.STROKE);
        return cornerPaint;
    }

    public static float getCornerThickness() {
        return 5.0f;
    }

    public static float getLineThickness() {
        return 3.0f;
    }
}

