/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import bolts.Continuation;
import bolts.Task;
import com.facebook.AccessToken;
import com.parse.AuthenticationCallback;
import com.parse.FacebookController;
import com.parse.LogInCallback;
import com.parse.ParseException;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class ParseFacebookUtils {
    private static final String AUTH_TYPE = "facebook";
    private static final Object lock = new Object();
    static boolean isInitialized;
    static FacebookController controller;
    static ParseUserDelegate userDelegate;

    public static boolean isLinked(ParseUser user) {
        return user.isLinked(AUTH_TYPE);
    }

    public static void initialize(Context context) {
        ParseFacebookUtils.initialize(context, 64206);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Context context, int callbackRequestCodeOffset) {
        Object object = lock;
        synchronized (object) {
            ParseFacebookUtils.getController().initialize(context, callbackRequestCodeOffset);
            userDelegate.registerAuthenticationCallback(AUTH_TYPE, new AuthenticationCallback(){

                public boolean onRestore(Map<String, String> authData) {
                    try {
                        ParseFacebookUtils.getController().setAuthData(authData);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            });
            isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInitialization() {
        Object object = lock;
        synchronized (object) {
            if (!isInitialized) {
                throw new IllegalStateException("You must call ParseFacebookUtils.initialize() before using ParseFacebookUtils");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FacebookController getController() {
        Object object = lock;
        synchronized (object) {
            if (controller == null) {
                controller = new FacebookController();
            }
            return controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        Object object = lock;
        synchronized (object) {
            if (controller != null) {
                return controller.onActivityResult(requestCode, resultCode, data);
            }
            return false;
        }
    }

    public static Task<ParseUser> logInInBackground(AccessToken accessToken) {
        ParseFacebookUtils.checkInitialization();
        return userDelegate.logInWithInBackground(AUTH_TYPE, ParseFacebookUtils.getController().getAuthData(accessToken));
    }

    public static Task<ParseUser> logInInBackground(AccessToken accessToken, LogInCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(accessToken), callback, true);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(activity, null, permissions, FacebookController.LoginAuthorizationType.READ);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Activity activity, Collection<String> permissions, LogInCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithReadPermissionsInBackground(activity, permissions), callback, true);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(activity, null, permissions, FacebookController.LoginAuthorizationType.PUBLISH);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Activity activity, Collection<String> permissions, LogInCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithPublishPermissionsInBackground(activity, permissions), callback, true);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(null, fragment, permissions, FacebookController.LoginAuthorizationType.READ);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Fragment fragment, Collection<String> permissions, LogInCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithReadPermissionsInBackground(fragment, permissions), callback, true);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(null, fragment, permissions, FacebookController.LoginAuthorizationType.PUBLISH);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Fragment fragment, Collection<String> permissions, LogInCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithPublishPermissionsInBackground(fragment, permissions), callback, true);
    }

    private static Task<ParseUser> logInAsync(Activity activity, Fragment fragment, Collection<String> permissions, FacebookController.LoginAuthorizationType authorizationType) {
        ParseFacebookUtils.checkInitialization();
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        return ParseFacebookUtils.getController().authenticateAsync(activity, fragment, authorizationType, permissions).onSuccessTask((Continuation)new Continuation<Map<String, String>, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Map<String, String>> task) throws Exception {
                return userDelegate.logInWithInBackground(ParseFacebookUtils.AUTH_TYPE, (Map)task.getResult());
            }
        });
    }

    public static Task<Void> linkInBackground(ParseUser user, AccessToken accessToken) {
        ParseFacebookUtils.checkInitialization();
        return user.linkWithInBackground(AUTH_TYPE, ParseFacebookUtils.getController().getAuthData(accessToken));
    }

    public static Task<Void> linkInBackground(ParseUser user, AccessToken accessToken, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkInBackground(user, accessToken), callback, true);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, activity, null, permissions, FacebookController.LoginAuthorizationType.READ);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithReadPermissionsInBackground(user, activity, permissions), callback, true);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, activity, null, permissions, FacebookController.LoginAuthorizationType.PUBLISH);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithPublishPermissionsInBackground(user, activity, permissions), callback, true);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, null, fragment, permissions, FacebookController.LoginAuthorizationType.READ);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithReadPermissionsInBackground(user, fragment, permissions), callback, true);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, null, fragment, permissions, FacebookController.LoginAuthorizationType.PUBLISH);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithPublishPermissionsInBackground(user, fragment, permissions), callback, true);
    }

    private static Task<Void> linkAsync(final ParseUser user, Activity activity, Fragment fragment, Collection<String> permissions, FacebookController.LoginAuthorizationType authorizationType) {
        ParseFacebookUtils.checkInitialization();
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        return ParseFacebookUtils.getController().authenticateAsync(activity, fragment, authorizationType, permissions).onSuccessTask((Continuation)new Continuation<Map<String, String>, Task<Void>>(){

            public Task<Void> then(Task<Map<String, String>> task) throws Exception {
                return user.linkWithInBackground(ParseFacebookUtils.AUTH_TYPE, (Map)task.getResult());
            }
        });
    }

    public static Task<Void> unlinkInBackground(ParseUser user) {
        ParseFacebookUtils.checkInitialization();
        return user.unlinkFromInBackground(AUTH_TYPE);
    }

    public static Task<Void> unlinkInBackground(ParseUser user, SaveCallback callback) {
        return ParseFacebookUtils.callbackOnMainThreadAsync(ParseFacebookUtils.unlinkInBackground(user), callback, false);
    }

    private static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, LogInCallback callback, boolean reportCancellation) {
        return ParseFacebookUtils.callbackOnMainThreadInternalAsync(task, callback, reportCancellation);
    }

    private static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, SaveCallback callback, boolean reportCancellation) {
        return ParseFacebookUtils.callbackOnMainThreadInternalAsync(task, callback, reportCancellation);
    }

    private static <T> Task<T> callbackOnMainThreadInternalAsync(Task<T> task, final Object callback, final boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        final Task.TaskCompletionSource tcs = Task.create();
        task.continueWith(new Continuation<T, Void>(){

            public Void then(final Task<T> task) throws Exception {
                if (task.isCancelled() && !reportCancellation) {
                    tcs.setCancelled();
                    return null;
                }
                Task.UI_THREAD_EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Exception error = task.getError();
                            if (error != null && !(error instanceof ParseException)) {
                                error = new ParseException((Throwable)error);
                            }
                            if (callback instanceof SaveCallback) {
                                ((SaveCallback)callback).done((ParseException)error);
                            } else if (callback instanceof LogInCallback) {
                                ((LogInCallback)callback).done((ParseUser)task.getResult(), (ParseException)error);
                            }
                        }
                        finally {
                            if (task.isCancelled()) {
                                tcs.setCancelled();
                            } else if (task.isFaulted()) {
                                tcs.setError(task.getError());
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    private ParseFacebookUtils() {
    }

    static {
        userDelegate = new ParseUserDelegateImpl();
    }

    private static class ParseUserDelegateImpl
    implements ParseUserDelegate {
        private ParseUserDelegateImpl() {
        }

        @Override
        public void registerAuthenticationCallback(String authType, AuthenticationCallback callback) {
            ParseUser.registerAuthenticationCallback((String)authType, (AuthenticationCallback)callback);
        }

        @Override
        public Task<ParseUser> logInWithInBackground(String authType, Map<String, String> authData) {
            return ParseUser.logInWithInBackground((String)authType, authData);
        }
    }

    static interface ParseUserDelegate {
        public void registerAuthenticationCallback(String var1, AuthenticationCallback var2);

        public Task<ParseUser> logInWithInBackground(String var1, Map<String, String> var2);
    }
}

