/*
 * Decompiled with CFR 0.152.
 */
package com.parse.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import bolts.Task;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;

class FacebookController {
    private static final DateFormat PRECISE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    private static final DateFormat IMPRECISE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    public static final int DEFAULT_AUTH_ACTIVITY_CODE = 64206;
    private static final String KEY_USER_ID = "id";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_EXPIRATION_DATE = "expiration_date";
    private static final String KEY_REFRESH_DATE = "last_refresh_date";
    private static final String KEY_PERMISSIONS = "permissions";
    private final FacebookSdkDelegate facebookSdkDelegate;
    private CallbackManager callbackManager;

    FacebookController(FacebookSdkDelegate facebookSdkDelegate) {
        this.facebookSdkDelegate = facebookSdkDelegate;
    }

    FacebookController() {
        this(new FacebookSdkDelegateImpl());
    }

    public void initialize(Context context, int callbackRequestCodeOffset) {
        this.facebookSdkDelegate.initialize(context, callbackRequestCodeOffset);
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean ret = false;
        if (this.callbackManager != null) {
            ret = this.callbackManager.onActivityResult(requestCode, resultCode, data);
            this.callbackManager = null;
        }
        return ret;
    }

    public Task<Map<String, String>> authenticateAsync(Activity activity, Fragment fragment, LoginAuthorizationType authorizationType, Collection<String> permissions) {
        if (this.callbackManager != null) {
            return Task.forError((Exception)new RuntimeException("Unable to authenticate when another authentication is in process"));
        }
        final Task.TaskCompletionSource tcs = Task.create();
        LoginManager manager = this.facebookSdkDelegate.getLoginManager();
        this.callbackManager = this.facebookSdkDelegate.createCallbackManager();
        manager.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                AccessToken accessToken = loginResult.getAccessToken();
                Map<String, String> authData = FacebookController.this.getAuthData(accessToken);
                tcs.trySetResult(authData);
            }

            public void onCancel() {
                tcs.trySetCancelled();
            }

            public void onError(FacebookException e) {
                tcs.trySetError((Exception)e);
            }
        });
        if (LoginAuthorizationType.PUBLISH.equals((Object)authorizationType)) {
            if (fragment != null) {
                manager.logInWithPublishPermissions(fragment, permissions);
            } else {
                manager.logInWithPublishPermissions(activity, permissions);
            }
        } else if (fragment != null) {
            manager.logInWithReadPermissions(fragment, permissions);
        } else {
            manager.logInWithReadPermissions(activity, permissions);
        }
        return tcs.getTask();
    }

    public Map<String, String> getAuthData(AccessToken accessToken) {
        HashMap<String, String> authData = new HashMap<String, String>();
        authData.put(KEY_USER_ID, accessToken.getUserId());
        authData.put(KEY_ACCESS_TOKEN, accessToken.getToken());
        authData.put(KEY_EXPIRATION_DATE, PRECISE_DATE_FORMAT.format(accessToken.getExpires()));
        authData.put(KEY_REFRESH_DATE, PRECISE_DATE_FORMAT.format(accessToken.getLastRefresh()));
        Set permissionSet = accessToken.getPermissions();
        String valueToInsert = TextUtils.join((CharSequence)",", (Iterable)permissionSet);
        authData.put(KEY_PERMISSIONS, valueToInsert);
        return authData;
    }

    public void setAuthData(Map<String, String> authData) throws ParseException {
        AccessToken currentAccessToken;
        if (authData == null) {
            this.facebookSdkDelegate.getLoginManager().logOut();
            return;
        }
        String token = authData.get(KEY_ACCESS_TOKEN);
        String userId = authData.get(KEY_USER_ID);
        String lastRefreshDateString = authData.get(KEY_REFRESH_DATE);
        Date lastRefreshDate = null;
        if (lastRefreshDateString != null) {
            lastRefreshDate = this.parseDateString(lastRefreshDateString);
        }
        if ((currentAccessToken = this.facebookSdkDelegate.getCurrentAccessToken()) != null) {
            String currToken = currentAccessToken.getToken();
            String currUserId = currentAccessToken.getUserId();
            Date currLastRefreshDate = currentAccessToken.getLastRefresh();
            if (currToken != null && currToken.equals(token) && currUserId != null && currUserId.equals(userId)) {
                return;
            }
            if (currLastRefreshDate != null && lastRefreshDate != null && currLastRefreshDate.after(lastRefreshDate)) {
                return;
            }
        }
        String permissionsCommaDelineated = authData.get(KEY_PERMISSIONS);
        HashSet<String> permissions = null;
        if (permissionsCommaDelineated != null && !permissionsCommaDelineated.isEmpty()) {
            String[] permissionsArray = permissionsCommaDelineated.split(",");
            permissions = new HashSet<String>(Arrays.asList(permissionsArray));
        }
        AccessToken accessToken = new AccessToken(token, this.facebookSdkDelegate.getApplicationId(), userId, permissions, null, null, AccessTokenSource.DEVICE_AUTH, this.parseDateString(authData.get(KEY_EXPIRATION_DATE)), null, null);
        this.facebookSdkDelegate.setCurrentAccessToken(accessToken);
    }

    private Date parseDateString(String source) throws ParseException {
        try {
            return PRECISE_DATE_FORMAT.parse(source);
        }
        catch (ParseException e) {
            return IMPRECISE_DATE_FORMAT.parse(source);
        }
    }

    static {
        PRECISE_DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
        IMPRECISE_DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    private static class FacebookSdkDelegateImpl
    implements FacebookSdkDelegate {
        private FacebookSdkDelegateImpl() {
        }

        @Override
        public void initialize(Context context, int callbackRequestCodeOffset) {
            FacebookSdk.sdkInitialize((Context)context, (int)callbackRequestCodeOffset);
        }

        @Override
        public String getApplicationId() {
            return FacebookSdk.getApplicationId();
        }

        @Override
        public AccessToken getCurrentAccessToken() {
            return AccessToken.getCurrentAccessToken();
        }

        @Override
        public void setCurrentAccessToken(AccessToken token) {
            AccessToken.setCurrentAccessToken((AccessToken)token);
        }

        @Override
        public CallbackManager createCallbackManager() {
            return CallbackManager.Factory.create();
        }

        @Override
        public LoginManager getLoginManager() {
            return LoginManager.getInstance();
        }
    }

    static interface FacebookSdkDelegate {
        public void initialize(Context var1, int var2);

        public String getApplicationId();

        public AccessToken getCurrentAccessToken();

        public void setCurrentAccessToken(AccessToken var1);

        public CallbackManager createCallbackManager();

        public LoginManager getLoginManager();
    }

    public static enum LoginAuthorizationType {
        READ,
        PUBLISH;

    }
}

