/*
 * Decompiled with CFR 0.152.
 */
package com.paramsen.noise;

import com.paramsen.noise.NoiseNativeBridge;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/paramsen/noise/Noise;", "Ljava/io/Closeable;", "configPointer", "", "isReal", "", "(JZ)V", "close", "", "fft", "", "src", "dst", "Companion", "noise_release"})
public final class Noise
implements Closeable {
    private final long configPointer;
    private final boolean isReal;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final float[] fft(@NotNull float[] src, @NotNull float[] dst) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        if (this.isReal) {
            boolean bl = dst.length == src.length + 2;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot compute FFT, dst length must equal src length + 2";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            NoiseNativeBridge.INSTANCE.real(src, dst, this.configPointer);
        } else {
            boolean bl = src.length == dst.length;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "Cannot compute FFT, dst length must equal src length";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            NoiseNativeBridge.INSTANCE.imaginary(src, dst, this.configPointer);
        }
        return dst;
    }

    @Override
    public void close() {
        if (this.isReal) {
            NoiseNativeBridge.INSTANCE.realConfigDispose(this.configPointer);
        } else {
            NoiseNativeBridge.INSTANCE.imaginaryConfigDispose(this.configPointer);
        }
    }

    private Noise(long configPointer, boolean isReal) {
        this.configPointer = configPointer;
        this.isReal = isReal;
    }

    public /* synthetic */ Noise(long configPointer, boolean isReal, DefaultConstructorMarker $constructor_marker) {
        this(configPointer, isReal);
    }

    @JvmStatic
    @NotNull
    public static final Noise real(int inputLength) {
        return Companion.real(inputLength);
    }

    @JvmStatic
    @NotNull
    public static final Noise imaginary(int inputLength) {
        return Companion.imaginary(inputLength);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/paramsen/noise/Noise$Companion;", "", "()V", "imaginary", "Lcom/paramsen/noise/Noise;", "inputLength", "", "real", "noise_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Noise real(int inputLength) {
            return new Noise(NoiseNativeBridge.INSTANCE.realConfig(inputLength), true, null);
        }

        @JvmStatic
        @NotNull
        public final Noise imaginary(int inputLength) {
            return new Noise(NoiseNativeBridge.INSTANCE.imaginaryConfig(inputLength), false, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

