/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal.viewpager;

import android.view.View;
import androidx.viewpager2.widget.ViewPager2;
import com.github.appintro.AppIntroPageTransformerType;
import com.github.appintro.internal.LogHelper;
import com.github.appintro.internal.viewpager.ViewPagerTransformerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/appintro/internal/viewpager/ViewPagerTransformer;", "Landroidx/viewpager2/widget/ViewPager2$PageTransformer;", "transformType", "Lcom/github/appintro/AppIntroPageTransformerType;", "(Lcom/github/appintro/AppIntroPageTransformerType;)V", "descriptionPF", "", "imagePF", "titlePF", "applyParallax", "", "page", "Landroid/view/View;", "position", "", "viewId", "", "parallaxFactor", "logLabel", "", "computeParallax", "transformDepth", "transformFade", "transformPage", "transformParallax", "titleViewId", "imageViewId", "descriptionViewId", "transformSlideOver", "transformZoom", "Companion", "appintro_release"})
public final class ViewPagerTransformer
implements ViewPager2.PageTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppIntroPageTransformerType transformType;
    private double titlePF;
    private double imagePF;
    private double descriptionPF;
    @NotNull
    private static final String TAG = LogHelper.INSTANCE.makeLogTag(Reflection.getOrCreateKotlinClass(ViewPagerTransformer.class));

    public ViewPagerTransformer(@NotNull AppIntroPageTransformerType transformType) {
        Intrinsics.checkNotNullParameter((Object)transformType, (String)"transformType");
        this.transformType = transformType;
    }

    public void transformPage(@NotNull View page, float position) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        AppIntroPageTransformerType appIntroPageTransformerType = this.transformType;
        if (Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Flow.INSTANCE)) {
            page.setRotationY(position * -30.0f);
        } else if (Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.SlideOver.INSTANCE)) {
            this.transformSlideOver(position, page);
        } else if (Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Depth.INSTANCE)) {
            this.transformDepth(position, page);
        } else if (Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Zoom.INSTANCE)) {
            this.transformZoom(position, page);
        } else if (Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Fade.INSTANCE)) {
            this.transformFade(position, page);
        } else if (appIntroPageTransformerType instanceof AppIntroPageTransformerType.Parallax) {
            this.titlePF = ((AppIntroPageTransformerType.Parallax)this.transformType).getTitleParallaxFactor();
            this.imagePF = ((AppIntroPageTransformerType.Parallax)this.transformType).getImageParallaxFactor();
            this.descriptionPF = ((AppIntroPageTransformerType.Parallax)this.transformType).getDescriptionParallaxFactor();
            this.transformParallax(position, page, ((AppIntroPageTransformerType.Parallax)this.transformType).getTitleViewId(), ((AppIntroPageTransformerType.Parallax)this.transformType).getImageViewId(), ((AppIntroPageTransformerType.Parallax)this.transformType).getDescriptionViewId());
        }
    }

    private final void transformParallax(float position, View page, int titleViewId, int imageViewId, int descriptionViewId) {
        if (position > -1.0f && position < 1.0f) {
            try {
                this.applyParallax(page, position, titleViewId, this.titlePF, "title");
                this.applyParallax(page, position, imageViewId, this.imagePF, "image");
                this.applyParallax(page, position, descriptionViewId, this.descriptionPF, "description");
            }
            catch (IllegalStateException e) {
                LogHelper.e(TAG, "Failed to apply parallax effect", e);
            }
        }
    }

    private final void applyParallax(View page, float position, int viewId, double parallaxFactor, String logLabel) {
        Function0<Unit> function0;
        View view = page.findViewById(viewId);
        if (view != null) {
            View it = view;
            boolean bl = false;
            it.setTranslationX(this.computeParallax(page, position, parallaxFactor));
            function0 = Unit.INSTANCE;
        } else {
            function0 = new Function0<Unit>(logLabel){
                final /* synthetic */ String $logLabel;
                {
                    this.$logLabel = $logLabel;
                    super(0);
                }

                public final void invoke() {
                    LogHelper.e$default(ViewPagerTransformer.access$getTAG$cp(), "Could not parallax animate view '" + this.$logLabel + "' as the provided view ID can't be found in the layout", null, 4, null);
                }
            };
        }
    }

    private final float computeParallax(View page, float position, double parallaxFactor) {
        return (float)((double)(-position) * ((double)page.getWidth() / parallaxFactor));
    }

    private final void transformFade(float position, View page) {
        if (position <= -1.0f || position >= 1.0f) {
            page.setTranslationX((float)page.getWidth());
            page.setAlpha(0.0f);
            page.setClickable(false);
        } else if (position == 0.0f) {
            page.setTranslationX(0.0f);
            page.setAlpha(1.0f);
            page.setClickable(true);
        } else {
            page.setTranslationX((float)page.getWidth() * -position);
            page.setAlpha(1.0f - Math.abs(position));
        }
    }

    private final void transformZoom(float position, View page) {
        if (position >= -1.0f && position <= 1.0f) {
            ViewPagerTransformerKt.access$setScaleXY(page, Math.max(0.85f, 1.0f - Math.abs(position)));
            page.setAlpha(0.5f + (ViewPagerTransformerKt.access$getScaleXY(page) - 0.85f) / 0.14999998f * 0.5f);
            float vMargin = (float)page.getHeight() * (1.0f - ViewPagerTransformerKt.access$getScaleXY(page)) / (float)2;
            float hMargin = (float)page.getWidth() * (1.0f - ViewPagerTransformerKt.access$getScaleXY(page)) / (float)2;
            if (position < 0.0f) {
                page.setTranslationX(hMargin - vMargin / (float)2);
            } else {
                page.setTranslationX(-hMargin + vMargin / (float)2);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformDepth(float position, View page) {
        if (position > 0.0f && position < 1.0f) {
            page.setAlpha(1.0f - position);
            ViewPagerTransformerKt.access$setScaleXY(page, 0.75f + 0.25f * (1.0f - Math.abs(position)));
            page.setTranslationX((float)page.getWidth() * -position);
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformSlideOver(float position, View page) {
        if (position < 0.0f && position > -1.0f) {
            ViewPagerTransformerKt.access$setScaleXY(page, Math.abs(Math.abs(position) - 1.0f) * 0.14999998f + 0.85f);
            page.setAlpha(Math.max(0.35f, 1.0f - Math.abs(position)));
            int pageWidth = page.getWidth();
            float translateValue = position * (float)(-pageWidth);
            if (translateValue > (float)(-pageWidth)) {
                page.setTranslationX(translateValue);
            } else {
                page.setTranslationX(0.0f);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/appintro/internal/viewpager/ViewPagerTransformer$Companion;", "", "()V", "TAG", "", "appintro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

