/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal;

import android.content.Context;
import android.gesture.GestureOverlayView;
import android.view.MotionEvent;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.github.appintro.AppIntroBase;
import com.github.appintro.AppIntroPageTransformerType;
import com.github.appintro.AppIntroViewPagerListener;
import com.github.appintro.internal.LayoutUtil;
import com.github.appintro.internal.viewpager.PagerAdapter;
import com.github.appintro.internal.viewpager.ViewPagerTransformer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#J\u0006\u0010&\u001a\u00020\u001eJ\u0006\u0010'\u001a\u00020\u001eJ\u0012\u0010(\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u000e\u0010)\u001a\u00020\r2\u0006\u0010%\u001a\u00020#J\u000e\u0010*\u001a\u00020\r2\u0006\u0010%\u001a\u00020#J\u0018\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J\u0014\u0010.\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e00J\r\u00101\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b2J\u0019\u00103\u001a\u00020\u001e2\n\u00104\u001a\u00060\u001bR\u00020\u001cH\u0000\u00a2\u0006\u0002\b5J\u000e\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;J\u0018\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020#2\b\b\u0002\u0010>\u001a\u00020\rJ\u000e\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020#J\u0010\u0010A\u001a\u00020\u001e2\b\u0010B\u001a\u0004\u0018\u00010CJ\b\u0010D\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0018\u00010\u001bR\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/github/appintro/internal/AppIntroViewPagerController;", "", "viewPager", "Landroidx/viewpager2/widget/ViewPager2;", "viewPagerGestureOverlay", "Landroid/gesture/GestureOverlayView;", "(Landroidx/viewpager2/widget/ViewPager2;Landroid/gesture/GestureOverlayView;)V", "currentTouchDownX", "", "currentTouchDownY", "illegallyRequestedNextPageLastCalled", "", "isFullPagingEnabled", "", "()Z", "setFullPagingEnabled", "(Z)V", "isPermissionSlide", "setPermissionSlide", "lastTouchValue", "onNextPageRequestedListener", "Lcom/github/appintro/AppIntroViewPagerListener;", "getOnNextPageRequestedListener", "()Lcom/github/appintro/AppIntroViewPagerListener;", "setOnNextPageRequestedListener", "(Lcom/github/appintro/AppIntroViewPagerListener;)V", "pageChangeCallback", "Lcom/github/appintro/AppIntroBase$OnPageChangeCallback;", "Lcom/github/appintro/AppIntroBase;", "addPagerTouchInterceptor", "", "canPerformTouchEvent", "event", "Landroid/view/MotionEvent;", "getCurrentItem", "", "getCurrentSlideNumber", "size", "goToNextSlide", "goToPreviousSlide", "handleOnTouchEvent", "isFirstSlide", "isLastSlide", "isSwipeForward", "oldX", "newX", "post", "function", "Lkotlin/Function0;", "reCenterCurrentSlide", "reCenterCurrentSlide$appintro_release", "registerOnPageChangeCallback", "callback", "registerOnPageChangeCallback$appintro_release", "setAdapter", "pagerAdapter", "Lcom/github/appintro/internal/viewpager/PagerAdapter;", "setAppIntroPageTransformer", "appIntroTransformer", "Lcom/github/appintro/AppIntroPageTransformerType;", "setCurrentViewPagerItem", "position", "smoothScrool", "setOffscreenPageLimit", "offscreenPageLimit", "setPageTransformer", "pageTransformer", "Landroidx/viewpager2/widget/ViewPager2$PageTransformer;", "userIllegallyRequestNextPage", "Companion", "appintro_release"})
public final class AppIntroViewPagerController {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewPager2 viewPager;
    @NotNull
    private final GestureOverlayView viewPagerGestureOverlay;
    private boolean isFullPagingEnabled;
    private boolean isPermissionSlide;
    @Nullable
    private AppIntroViewPagerListener onNextPageRequestedListener;
    private float currentTouchDownX;
    private float currentTouchDownY;
    private long illegallyRequestedNextPageLastCalled;
    @Nullable
    private AppIntroBase.OnPageChangeCallback pageChangeCallback;
    private float lastTouchValue;
    private static final int ON_ILLEGALLY_REQUESTED_NEXT_PAGE_MAX_INTERVAL = 1000;

    public AppIntroViewPagerController(@NotNull ViewPager2 viewPager, @NotNull GestureOverlayView viewPagerGestureOverlay) {
        Intrinsics.checkNotNullParameter((Object)viewPager, (String)"viewPager");
        Intrinsics.checkNotNullParameter((Object)viewPagerGestureOverlay, (String)"viewPagerGestureOverlay");
        this.viewPager = viewPager;
        this.viewPagerGestureOverlay = viewPagerGestureOverlay;
        this.isFullPagingEnabled = true;
        this.addPagerTouchInterceptor();
    }

    public final boolean isFullPagingEnabled() {
        return this.isFullPagingEnabled;
    }

    public final void setFullPagingEnabled(boolean bl) {
        this.isFullPagingEnabled = bl;
    }

    public final boolean isPermissionSlide() {
        return this.isPermissionSlide;
    }

    public final void setPermissionSlide(boolean bl) {
        this.isPermissionSlide = bl;
    }

    @Nullable
    public final AppIntroViewPagerListener getOnNextPageRequestedListener() {
        return this.onNextPageRequestedListener;
    }

    public final void setOnNextPageRequestedListener(@Nullable AppIntroViewPagerListener appIntroViewPagerListener) {
        this.onNextPageRequestedListener = appIntroViewPagerListener;
    }

    public final void goToNextSlide() {
        ViewPager2 $this$goToNextSlide_u24lambda_u240 = this.viewPager;
        boolean bl = false;
        $this$goToNextSlide_u24lambda_u240.endFakeDrag();
        Context context = $this$goToNextSlide_u24lambda_u240.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setCurrentViewPagerItem(!LayoutUtil.isRtl(context) ? $this$goToNextSlide_u24lambda_u240.getCurrentItem() + 1 : $this$goToNextSlide_u24lambda_u240.getCurrentItem() - 1, true);
    }

    public final void goToPreviousSlide() {
        ViewPager2 $this$goToPreviousSlide_u24lambda_u241 = this.viewPager;
        boolean bl = false;
        $this$goToPreviousSlide_u24lambda_u241.endFakeDrag();
        Context context = $this$goToPreviousSlide_u24lambda_u241.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setCurrentViewPagerItem(!LayoutUtil.isRtl(context) ? $this$goToPreviousSlide_u24lambda_u241.getCurrentItem() - 1 : $this$goToPreviousSlide_u24lambda_u241.getCurrentItem() + 1, true);
    }

    public final boolean isFirstSlide(int size) {
        ViewPager2 $this$isFirstSlide_u24lambda_u242 = this.viewPager;
        boolean bl = false;
        Context context = $this$isFirstSlide_u24lambda_u242.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? $this$isFirstSlide_u24lambda_u242.getCurrentItem() - size + 1 == 0 : $this$isFirstSlide_u24lambda_u242.getCurrentItem() == 0;
    }

    public final boolean isLastSlide(int size) {
        ViewPager2 $this$isLastSlide_u24lambda_u243 = this.viewPager;
        boolean bl = false;
        Context context = $this$isLastSlide_u24lambda_u243.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? $this$isLastSlide_u24lambda_u243.getCurrentItem() == 0 : $this$isLastSlide_u24lambda_u243.getCurrentItem() - size + 1 == 0;
    }

    public final int getCurrentSlideNumber(int size) {
        ViewPager2 $this$getCurrentSlideNumber_u24lambda_u244 = this.viewPager;
        boolean bl = false;
        Context context = $this$getCurrentSlideNumber_u24lambda_u244.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? size - $this$getCurrentSlideNumber_u24lambda_u244.getCurrentItem() : $this$getCurrentSlideNumber_u24lambda_u244.getCurrentItem() + 1;
    }

    public final void setCurrentViewPagerItem(int position, boolean smoothScrool) {
        block1: {
            ViewPager2 $this$setCurrentViewPagerItem_u24lambda_u245 = this.viewPager;
            boolean bl = false;
            $this$setCurrentViewPagerItem_u24lambda_u245.endFakeDrag();
            int oldItem = $this$setCurrentViewPagerItem_u24lambda_u245.getCurrentItem();
            this.viewPager.setCurrentItem(position, smoothScrool);
            if (oldItem != 0 || position != 0) break block1;
            AppIntroBase.OnPageChangeCallback onPageChangeCallback = this.pageChangeCallback;
            if (onPageChangeCallback != null) {
                onPageChangeCallback.onPageSelected(0);
            }
        }
    }

    public static /* synthetic */ void setCurrentViewPagerItem$default(AppIntroViewPagerController appIntroViewPagerController, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        appIntroViewPagerController.setCurrentViewPagerItem(n, bl);
    }

    private final boolean canPerformTouchEvent(MotionEvent event) {
        block7: {
            boolean canRequestNextPage;
            block6: {
                if (!this.isFullPagingEnabled || event == null) {
                    return false;
                }
                if (event.getAction() != 0) break block6;
                this.currentTouchDownX = event.getX();
                this.currentTouchDownY = event.getY();
                break block7;
            }
            if (event.getAction() == 1) {
                this.viewPager.performClick();
            }
            AppIntroViewPagerListener appIntroViewPagerListener = this.onNextPageRequestedListener;
            boolean bl = canRequestNextPage = appIntroViewPagerListener != null ? appIntroViewPagerListener.onCanRequestNextPage() : true;
            if (!canRequestNextPage && this.isSwipeForward(this.currentTouchDownX, event.getX())) {
                if (this.userIllegallyRequestNextPage()) {
                    AppIntroViewPagerListener appIntroViewPagerListener2 = this.onNextPageRequestedListener;
                    if (appIntroViewPagerListener2 != null) {
                        appIntroViewPagerListener2.onIllegallyRequestedNextPage();
                    }
                }
                return false;
            }
            if (!this.isPermissionSlide || !this.isSwipeForward(this.currentTouchDownX, event.getX())) break block7;
            AppIntroViewPagerListener appIntroViewPagerListener3 = this.onNextPageRequestedListener;
            if (appIntroViewPagerListener3 != null) {
                appIntroViewPagerListener3.onUserRequestedPermissionsDialog();
            }
        }
        return this.isFullPagingEnabled;
    }

    private final boolean handleOnTouchEvent(MotionEvent event) {
        Integer n;
        if (!this.canPerformTouchEvent(event)) {
            return false;
        }
        MotionEvent motionEvent = event;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
        if (n2 != null && n2 == 0) {
            this.lastTouchValue = event.getX();
            if (!this.viewPager.isFakeDragging()) {
                this.viewPager.beginFakeDrag();
            }
        } else {
            boolean bl;
            Integer n3 = n;
            int n4 = 2;
            if (n3 != null && n3 == n4) {
                float value = event.getX();
                float delta = value - this.lastTouchValue;
                this.viewPager.fakeDragBy(delta);
                this.lastTouchValue = value;
                return true;
            }
            Integer n5 = n;
            n4 = 3;
            if (n5 != null && n5 == n4) {
                bl = true;
            } else {
                Integer n6 = n;
                n4 = 1;
                bl = n6 != null && n6 == n4;
            }
            if (bl) {
                this.viewPager.endFakeDrag();
            }
        }
        return true;
    }

    private final boolean isSwipeForward(float oldX, float newX) {
        ViewPager2 $this$isSwipeForward_u24lambda_u246 = this.viewPager;
        boolean bl = false;
        Context context = $this$isSwipeForward_u24lambda_u246.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? newX > oldX : oldX > newX;
    }

    private final boolean userIllegallyRequestNextPage() {
        if (System.currentTimeMillis() - this.illegallyRequestedNextPageLastCalled >= 1000L) {
            this.illegallyRequestedNextPageLastCalled = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private final void addPagerTouchInterceptor() {
        this.viewPager.setUserInputEnabled(false);
        this.viewPagerGestureOverlay.addOnGestureListener(new GestureOverlayView.OnGestureListener(this){
            final /* synthetic */ AppIntroViewPagerController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onGestureStarted(@Nullable GestureOverlayView overlayView, @Nullable MotionEvent event) {
                AppIntroViewPagerController.access$handleOnTouchEvent(this.this$0, event);
            }

            public void onGesture(@Nullable GestureOverlayView overlayView, @Nullable MotionEvent event) {
                AppIntroViewPagerController.access$handleOnTouchEvent(this.this$0, event);
            }

            public void onGestureEnded(@Nullable GestureOverlayView overlayView, @Nullable MotionEvent event) {
                AppIntroViewPagerController.access$handleOnTouchEvent(this.this$0, event);
            }

            public void onGestureCancelled(@Nullable GestureOverlayView overlayView, @Nullable MotionEvent event) {
                AppIntroViewPagerController.access$handleOnTouchEvent(this.this$0, event);
            }
        });
    }

    public final void reCenterCurrentSlide$appintro_release() {
        ViewPager2 $this$reCenterCurrentSlide_u24lambda_u247 = this.viewPager;
        boolean bl = false;
        int item = $this$reCenterCurrentSlide_u24lambda_u247.getCurrentItem();
        this.setCurrentViewPagerItem(Math.max(item - 1, 0), false);
        this.setCurrentViewPagerItem(item, false);
    }

    public final void registerOnPageChangeCallback$appintro_release(@NotNull AppIntroBase.OnPageChangeCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)((Object)callback2), (String)"callback");
        this.viewPager.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)callback2);
        this.pageChangeCallback = callback2;
    }

    public final void setAppIntroPageTransformer(@NotNull AppIntroPageTransformerType appIntroTransformer) {
        Intrinsics.checkNotNullParameter((Object)appIntroTransformer, (String)"appIntroTransformer");
        ViewPager2 $this$setAppIntroPageTransformer_u24lambda_u248 = this.viewPager;
        boolean bl = false;
        $this$setAppIntroPageTransformer_u24lambda_u248.setPageTransformer((ViewPager2.PageTransformer)new ViewPagerTransformer(appIntroTransformer));
    }

    public final void setPageTransformer(@Nullable ViewPager2.PageTransformer pageTransformer) {
        ViewPager2 $this$setPageTransformer_u24lambda_u249 = this.viewPager;
        boolean bl = false;
        $this$setPageTransformer_u24lambda_u249.setPageTransformer(pageTransformer);
    }

    public final void setOffscreenPageLimit(int offscreenPageLimit) {
        this.viewPager.setOffscreenPageLimit(offscreenPageLimit);
    }

    public final void setAdapter(@NotNull PagerAdapter pagerAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)pagerAdapter), (String)"pagerAdapter");
        this.viewPager.setAdapter((RecyclerView.Adapter)pagerAdapter);
    }

    public final void post(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.viewPager.post(() -> AppIntroViewPagerController.post$lambda$10(function));
    }

    public final int getCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    private static final void post$lambda$10(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ boolean access$handleOnTouchEvent(AppIntroViewPagerController $this, MotionEvent event) {
        return $this.handleOnTouchEvent(event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/appintro/internal/AppIntroViewPagerController$Companion;", "", "()V", "ON_ILLEGALLY_REQUESTED_NEXT_PAGE_MAX_INTERVAL", "", "appintro_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

