/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.os.Bundle;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.github.appintro.R;
import com.github.appintro.SlideBackgroundColorHolder;
import com.github.appintro.SlideSelectionListener;
import com.github.appintro.internal.LogHelper;
import com.github.appintro.internal.TypefaceContainer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J&\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001fH\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u001dH\u0016J\u0012\u0010-\u001a\u00020\u001d2\b\b\u0001\u0010.\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00068eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/appintro/AppIntroBaseFragment;", "Landroidx/fragment/app/Fragment;", "Lcom/github/appintro/SlideSelectionListener;", "Lcom/github/appintro/SlideBackgroundColorHolder;", "()V", "bgDrawable", "", "<set-?>", "defaultBackgroundColor", "getDefaultBackgroundColor$annotations", "getDefaultBackgroundColor", "()I", "defaultBackgroundColorRes", "getDefaultBackgroundColorRes", "descColor", "descColorRes", "descTypeface", "Lcom/github/appintro/internal/TypefaceContainer;", "description", "", "drawable", "layoutId", "getLayoutId", "logTAG", "title", "titleColor", "titleColorRes", "titleTypeface", "onActivityCreated", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreate", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onPause", "onResume", "onSaveInstanceState", "outState", "onSlideDeselected", "onSlideSelected", "setBackgroundColor", "backgroundColor", "appintro_release"})
public abstract class AppIntroBaseFragment
extends Fragment
implements SlideSelectionListener,
SlideBackgroundColorHolder {
    @NotNull
    private final String logTAG = LogHelper.makeLogTag(AppIntroBaseFragment.class);
    private int drawable;
    private int bgDrawable;
    @ColorInt
    private int titleColor;
    @ColorRes
    private int titleColorRes;
    @ColorInt
    private int descColor;
    @ColorRes
    private int descColorRes;
    @ColorInt
    private int defaultBackgroundColor;
    @ColorRes
    private int defaultBackgroundColorRes;
    @Nullable
    private String title;
    @Nullable
    private String description;
    @Nullable
    private TypefaceContainer titleTypeface;
    @Nullable
    private TypefaceContainer descTypeface;

    @LayoutRes
    protected abstract int getLayoutId();

    @Override
    public final int getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @Deprecated(message="`defaultBackgroundColor` has been deprecated to support configuration changes", replaceWith=@ReplaceWith(expression="defaultBackgroundColorRes", imports={}))
    public static /* synthetic */ void getDefaultBackgroundColor$annotations() {
    }

    @Override
    public final int getDefaultBackgroundColorRes() {
        return this.defaultBackgroundColorRes;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        Bundle args = this.getArguments();
        if (args != null && args.size() != 0) {
            this.drawable = args.getInt("drawable");
            this.title = args.getString("title");
            this.description = args.getString("desc");
            this.bgDrawable = args.getInt("bg_drawable");
            String argsTitleTypeface = args.getString("title_typeface");
            String argsDescTypeface = args.getString("desc_typeface");
            int argsTitleTypefaceRes = args.getInt("title_typeface_res");
            int argsDescTypefaceRes = args.getInt("desc_typeface_res");
            this.titleTypeface = new TypefaceContainer(argsTitleTypeface, argsTitleTypefaceRes);
            this.descTypeface = new TypefaceContainer(argsDescTypeface, argsDescTypefaceRes);
            this.defaultBackgroundColor = args.getInt("bg_color");
            this.defaultBackgroundColorRes = args.getInt("bg_color_res");
            this.titleColor = args.getInt("title_color", 0);
            this.titleColorRes = args.getInt("title_color_res", 0);
            this.descColor = args.getInt("desc_color", 0);
            this.descColorRes = args.getInt("desc_color_res", 0);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.drawable = savedInstanceState.getInt("drawable");
            this.title = savedInstanceState.getString("title");
            this.description = savedInstanceState.getString("desc");
            this.titleTypeface = new TypefaceContainer(savedInstanceState.getString("title_typeface"), savedInstanceState.getInt("title_typeface_res", 0));
            this.descTypeface = new TypefaceContainer(savedInstanceState.getString("desc_typeface"), savedInstanceState.getInt("desc_typeface_res", 0));
            this.defaultBackgroundColor = savedInstanceState.getInt("bg_color");
            this.defaultBackgroundColorRes = savedInstanceState.getInt("bg_color_res");
            this.bgDrawable = savedInstanceState.getInt("bg_drawable");
            this.titleColor = savedInstanceState.getInt("title_color");
            this.titleColorRes = savedInstanceState.getInt("title_color_res");
            this.descColor = savedInstanceState.getInt("desc_color");
            this.descColorRes = savedInstanceState.getInt("desc_color_res");
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        View view = inflater.inflate(this.getLayoutId(), container, false);
        TextView titleText = (TextView)view.findViewById(R.id.title);
        TextView descriptionText = (TextView)view.findViewById(R.id.description);
        ImageView slideImage = (ImageView)view.findViewById(R.id.image);
        ConstraintLayout mainLayout = (ConstraintLayout)view.findViewById(R.id.main);
        titleText.setText((CharSequence)this.title);
        descriptionText.setText((CharSequence)this.description);
        if (this.titleColorRes != 0) {
            titleText.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)this.titleColorRes));
        } else if (this.titleColor != 0) {
            titleText.setTextColor(this.titleColor);
        }
        if (this.descColorRes != 0) {
            descriptionText.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)this.descColorRes));
        } else if (this.descColor != 0) {
            descriptionText.setTextColor(this.descColor);
        }
        TypefaceContainer typefaceContainer = this.titleTypeface;
        if (typefaceContainer != null) {
            typefaceContainer.applyTo(titleText);
        }
        TypefaceContainer typefaceContainer2 = this.descTypeface;
        if (typefaceContainer2 != null) {
            typefaceContainer2.applyTo(descriptionText);
        }
        slideImage.setImageResource(this.drawable);
        if (this.bgDrawable != 0) {
            ConstraintLayout constraintLayout = mainLayout;
            if (constraintLayout != null) {
                constraintLayout.setBackgroundResource(this.bgDrawable);
            }
        } else if (this.defaultBackgroundColorRes != 0) {
            ConstraintLayout constraintLayout = mainLayout;
            if (constraintLayout != null) {
                constraintLayout.setBackgroundColor(ContextCompat.getColor((Context)this.requireContext(), (int)this.defaultBackgroundColorRes));
            }
        } else {
            ConstraintLayout constraintLayout = mainLayout;
            if (constraintLayout != null) {
                constraintLayout.setBackgroundColor(this.defaultBackgroundColor);
            }
        }
        titleText.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        descriptionText.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        return view;
    }

    public void onResume() {
        super.onResume();
        View view = this.getView();
        ImageView it = view != null ? (ImageView)view.findViewById(R.id.image) : null;
        boolean bl = false;
        if (it instanceof Animatable) {
            ((Animatable)it).start();
        }
    }

    public void onPause() {
        super.onPause();
        View view = this.getView();
        ImageView it = view != null ? (ImageView)view.findViewById(R.id.image) : null;
        boolean bl = false;
        if (it instanceof Animatable) {
            ((Animatable)it).start();
        }
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putInt("drawable", this.drawable);
        outState.putInt("bg_drawable", this.bgDrawable);
        outState.putString("title", this.title);
        outState.putString("desc", this.description);
        outState.putInt("bg_color", this.defaultBackgroundColor);
        outState.putInt("bg_color_res", this.defaultBackgroundColorRes);
        outState.putInt("title_color", this.titleColor);
        outState.putInt("title_color_res", this.titleColorRes);
        outState.putInt("desc_color", this.descColor);
        outState.putInt("desc_color_res", this.descColorRes);
        if (this.titleTypeface != null) {
            TypefaceContainer typefaceContainer = this.titleTypeface;
            outState.putString("title_typeface", typefaceContainer != null ? typefaceContainer.getTypeFaceUrl() : null);
            TypefaceContainer typefaceContainer2 = this.titleTypeface;
            outState.putInt("title_typeface_res", typefaceContainer2 != null ? typefaceContainer2.getTypeFaceResource() : 0);
        }
        if (this.descTypeface != null) {
            TypefaceContainer typefaceContainer = this.descTypeface;
            outState.putString("desc_typeface", typefaceContainer != null ? typefaceContainer.getTypeFaceUrl() : null);
            TypefaceContainer typefaceContainer3 = this.descTypeface;
            outState.putInt("desc_typeface_res", typefaceContainer3 != null ? typefaceContainer3.getTypeFaceResource() : 0);
        }
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onSlideDeselected() {
        LogHelper.d(this.logTAG, "Slide " + this.title + " has been deselected.");
    }

    @Override
    public void onSlideSelected() {
        LogHelper.d(this.logTAG, "Slide " + this.title + " has been selected.");
    }

    @Override
    public void setBackgroundColor(@ColorInt int backgroundColor) {
        block0: {
            View view = this.getView();
            if (view == null || (view = (ConstraintLayout)view.findViewById(R.id.main)) == null) break block0;
            view.setBackgroundColor(backgroundColor);
        }
    }
}

