/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro.internal.viewpager;

import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.github.paolorotolo.appintro.internal.viewpager.TransformType;
import com.github.paolorotolo.appintro.internal.viewpager.ViewPagerTransformer$WhenMappings;
import com.github.paolorotolo.appintro.internal.viewpager.ViewPagerTransformerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/paolorotolo/appintro/internal/viewpager/ViewPagerTransformer;", "Landroidx/viewpager/widget/ViewPager$PageTransformer;", "transformType", "Lcom/github/paolorotolo/appintro/internal/viewpager/TransformType;", "(Lcom/github/paolorotolo/appintro/internal/viewpager/TransformType;)V", "transformDepth", "", "position", "", "page", "Landroid/view/View;", "transformFade", "transformPage", "transformSlideOver", "transformZoom", "appintro_release"})
public final class ViewPagerTransformer
implements ViewPager.PageTransformer {
    private final TransformType transformType;

    public void transformPage(@NotNull View page, float position) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        switch (ViewPagerTransformer$WhenMappings.$EnumSwitchMapping$0[this.transformType.ordinal()]) {
            case 1: {
                page.setRotationY(position * -30.0f);
                break;
            }
            case 2: {
                this.transformSlideOver(position, page);
                break;
            }
            case 3: {
                this.transformDepth(position, page);
                break;
            }
            case 4: {
                this.transformZoom(position, page);
                break;
            }
            case 5: {
                this.transformFade(position, page);
            }
        }
    }

    private final void transformFade(float position, View page) {
        if (position <= -1.0f || position >= 1.0f) {
            page.setTranslationX((float)page.getWidth());
            page.setAlpha(0.0f);
            page.setClickable(false);
        } else if (position == 0.0f) {
            page.setTranslationX(0.0f);
            page.setAlpha(1.0f);
            page.setClickable(true);
        } else {
            page.setTranslationX((float)page.getWidth() * -position);
            page.setAlpha(1.0f - Math.abs(position));
        }
    }

    private final void transformZoom(float position, View page) {
        if (position >= (float)-1 && position <= 1.0f) {
            ViewPagerTransformerKt.access$setScaleXY$p(page, Math.max(0.85f, 1.0f - Math.abs(position)));
            page.setAlpha(0.5f + (ViewPagerTransformerKt.access$getScaleXY$p(page) - 0.85f) / 0.14999998f * 0.5f);
            float vMargin = (float)page.getHeight() * (1.0f - ViewPagerTransformerKt.access$getScaleXY$p(page)) / (float)2;
            float hMargin = (float)page.getWidth() * (1.0f - ViewPagerTransformerKt.access$getScaleXY$p(page)) / (float)2;
            if (position < 0.0f) {
                page.setTranslationX(hMargin - vMargin / (float)2);
            } else {
                page.setTranslationX(-hMargin + vMargin / (float)2);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformDepth(float position, View page) {
        if (position > 0.0f && position < 1.0f) {
            page.setAlpha(1.0f - position);
            ViewPagerTransformerKt.access$setScaleXY$p(page, 0.75f + 0.25f * (1.0f - Math.abs(position)));
            page.setTranslationX((float)page.getWidth() * -position);
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformSlideOver(float position, View page) {
        if (position < 0.0f && position > (float)-1) {
            ViewPagerTransformerKt.access$setScaleXY$p(page, Math.abs(Math.abs(position) - 1.0f) * 0.14999998f + 0.85f);
            page.setAlpha(Math.max(0.35f, 1.0f - Math.abs(position)));
            int pageWidth = page.getWidth();
            float translateValue = position * (float)(-pageWidth);
            if (translateValue > (float)(-pageWidth)) {
                page.setTranslationX(translateValue);
            } else {
                page.setTranslationX(0.0f);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    public ViewPagerTransformer(@NotNull TransformType transformType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)transformType), (String)"transformType");
        this.transformType = transformType;
    }
}

