/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.github.paolorotolo.appintro.util.LogHelper;
import java.util.Hashtable;

public class CustomFontCache {
    private static final String TAG = LogHelper.makeLogTag(CustomFontCache.class);
    private static final Hashtable<String, Typeface> fCache = new Hashtable();

    public static Typeface get(String tfn, Context ctx) {
        Typeface tf = fCache.get(tfn);
        if (tf == null) {
            try {
                tf = Typeface.createFromAsset((AssetManager)ctx.getAssets(), (String)tfn);
                if (tf != null) {
                    fCache.put(tfn, tf);
                }
                return tf;
            }
            catch (Exception e) {
                if ("".equals(tfn)) {
                    LogHelper.w(TAG, e, "Empty path");
                } else {
                    LogHelper.w(TAG, e, tfn);
                }
                return null;
            }
        }
        return tf;
    }
}

