/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.liveevent;

import android.annotation.SuppressLint;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.github.panpf.liveevent.Listener;
import java.util.Map;

@SuppressLint(value={"RestrictedApi"})
public class LiveEvent<T> {
    final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    static final Object NOT_SET = new Object();
    private SafeIterableMap<Listener<? super T>, ListenerWrapper> mListeners = new SafeIterableMap();
    int mActiveCount = 0;
    private volatile Object mData;
    volatile Object mPendingData = NOT_SET;
    private int mVersion;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;
    private final Runnable mPostValueRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object newValue;
            Object object = LiveEvent.this.mDataLock;
            synchronized (object) {
                newValue = LiveEvent.this.mPendingData;
                LiveEvent.this.mPendingData = NOT_SET;
            }
            LiveEvent.this.setValue(newValue);
        }
    };

    public LiveEvent(T value) {
        this.mData = value;
        this.mVersion = 0;
    }

    public LiveEvent() {
        this.mData = NOT_SET;
        this.mVersion = -1;
    }

    private void considerNotify(ListenerWrapper listener) {
        if (!listener.mActive) {
            return;
        }
        if (!listener.shouldBeActive()) {
            listener.activeStateChanged(false);
            return;
        }
        if (listener.mLastVersion >= this.mVersion) {
            return;
        }
        listener.mLastVersion = this.mVersion;
        listener.mListener.onChanged(this.mData);
    }

    void dispatchingValue(@Nullable ListenerWrapper initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            SafeIterableMap.IteratorWithAdditions iterator = this.mListeners.iteratorWithAdditions();
            while (iterator.hasNext()) {
                this.considerNotify((ListenerWrapper)((Map.Entry)iterator.next()).getValue());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @MainThread
    public void listen(@NonNull LifecycleOwner owner, @NonNull Listener<? super T> listener) {
        LiveEvent.assertMainThread("listen");
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundListener wrapper = new LifecycleBoundListener(owner, listener);
        wrapper.mLastVersion = this.mVersion;
        ListenerWrapper existing = (ListenerWrapper)this.mListeners.putIfAbsent(listener, (Object)wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same listener with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void listenSticky(@NonNull LifecycleOwner owner, @NonNull Listener<? super T> listener) {
        LiveEvent.assertMainThread("listen");
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundListener wrapper = new LifecycleBoundListener(owner, listener);
        ListenerWrapper existing = (ListenerWrapper)this.mListeners.putIfAbsent(listener, (Object)wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same listener with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void listenForever(@NonNull Listener<? super T> listener) {
        LiveEvent.assertMainThread("listenForever");
        AlwaysActiveListener wrapper = new AlwaysActiveListener(listener);
        wrapper.mLastVersion = this.mVersion;
        ListenerWrapper existing = (ListenerWrapper)this.mListeners.putIfAbsent(listener, (Object)wrapper);
        if (existing instanceof LifecycleBoundListener) {
            throw new IllegalArgumentException("Cannot add the same listener with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void listenForeverSticky(@NonNull Listener<? super T> listener) {
        LiveEvent.assertMainThread("listenForever");
        AlwaysActiveListener wrapper = new AlwaysActiveListener(listener);
        ListenerWrapper existing = (ListenerWrapper)this.mListeners.putIfAbsent(listener, (Object)wrapper);
        if (existing instanceof LifecycleBoundListener) {
            throw new IllegalArgumentException("Cannot add the same listener with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void removeListener(@NonNull Listener<? super T> listener) {
        LiveEvent.assertMainThread("removeListener");
        ListenerWrapper removed = (ListenerWrapper)this.mListeners.remove(listener);
        if (removed == null) {
            return;
        }
        removed.detachListener();
        removed.activeStateChanged(false);
    }

    @MainThread
    public void removeListener(@NonNull LifecycleOwner owner) {
        LiveEvent.assertMainThread("removeListener");
        for (Map.Entry entry : this.mListeners) {
            if (!((ListenerWrapper)entry.getValue()).isAttachedTo(owner)) continue;
            this.removeListener((Listener)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postValue(T value) {
        boolean postTask;
        Object object = this.mDataLock;
        synchronized (object) {
            postTask = this.mPendingData == NOT_SET;
            this.mPendingData = value;
        }
        if (!postTask) {
            return;
        }
        ArchTaskExecutor.getInstance().postToMainThread(this.mPostValueRunnable);
    }

    @MainThread
    public void setValue(T value) {
        LiveEvent.assertMainThread("setValue");
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasListeners() {
        return this.mListeners.size() > 0;
    }

    public boolean hasActiveListeners() {
        return this.mActiveCount > 0;
    }

    static void assertMainThread(String methodName) {
        if (!ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot invoke " + methodName + " on a background thread");
        }
    }

    private class AlwaysActiveListener
    extends ListenerWrapper {
        AlwaysActiveListener(Listener<? super T> listener) {
            super(listener);
        }

        @Override
        boolean shouldBeActive() {
            return true;
        }
    }

    private abstract class ListenerWrapper {
        final Listener<? super T> mListener;
        boolean mActive;
        int mLastVersion = -1;

        ListenerWrapper(Listener<? super T> listener) {
            this.mListener = listener;
        }

        abstract boolean shouldBeActive();

        boolean isAttachedTo(LifecycleOwner owner) {
            return false;
        }

        void detachListener() {
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.mActive) {
                return;
            }
            this.mActive = newActive;
            boolean wasInactive = LiveEvent.this.mActiveCount == 0;
            LiveEvent.this.mActiveCount = LiveEvent.this.mActiveCount + (this.mActive ? 1 : -1);
            if (wasInactive && this.mActive) {
                LiveEvent.this.onActive();
            }
            if (LiveEvent.this.mActiveCount == 0 && !this.mActive) {
                LiveEvent.this.onInactive();
            }
            if (this.mActive) {
                LiveEvent.this.dispatchingValue(this);
            }
        }
    }

    class LifecycleBoundListener
    extends ListenerWrapper
    implements LifecycleEventObserver {
        @NonNull
        final LifecycleOwner mOwner;

        LifecycleBoundListener(LifecycleOwner owner, Listener<? super T> listener) {
            super(listener);
            this.mOwner = owner;
        }

        @Override
        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (this.mOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                LiveEvent.this.removeListener(this.mListener);
                return;
            }
            this.activeStateChanged(this.shouldBeActive());
        }

        @Override
        boolean isAttachedTo(LifecycleOwner owner) {
            return this.mOwner == owner;
        }

        @Override
        void detachListener() {
            this.mOwner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }
}

