/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.activity.monitor;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.github.panpf.activity.monitor.OnActivityCreatedListener;
import com.github.panpf.activity.monitor.OnActivityDestroyedListener;
import com.github.panpf.activity.monitor.OnActivityLifecycleChangedListener;
import com.github.panpf.activity.monitor.OnActivityPausedListener;
import com.github.panpf.activity.monitor.OnActivityResumedListener;
import com.github.panpf.activity.monitor.OnActivitySaveInstanceStateListener;
import com.github.panpf.activity.monitor.OnActivityStartedListener;
import com.github.panpf.activity.monitor.OnActivityStoppedListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ActivityLifecycleMonitor {
    @NonNull
    private static final Object LIST_EDIT_LOCK = new Object();
    private static final Object COUNT_EDIT_LOCK = new Object();
    @NonNull
    private static final ActivityLifecycleMonitor INSTANCE = new ActivityLifecycleMonitor();
    @NonNull
    private List<WeakReference<Activity>> createdActivityReverseList = new LinkedList<WeakReference<Activity>>();
    @NonNull
    private List<WeakReference<Activity>> startedActivityReverseList = new LinkedList<WeakReference<Activity>>();
    @NonNull
    private List<WeakReference<Activity>> resumedActivityReverseList = new LinkedList<WeakReference<Activity>>();
    @Nullable
    private LinkedList<OnActivityCreatedListener> createdListeners;
    @Nullable
    private LinkedList<OnActivityStartedListener> startedListeners;
    @Nullable
    private LinkedList<OnActivityResumedListener> resumedListeners;
    @Nullable
    private LinkedList<OnActivityPausedListener> pausedListeners;
    @Nullable
    private LinkedList<OnActivityStoppedListener> stoppedListeners;
    @Nullable
    private LinkedList<OnActivityDestroyedListener> destroyedListeners;
    @Nullable
    private LinkedList<OnActivitySaveInstanceStateListener> saveInstanceStateListeners;
    @Nullable
    private LinkedList<OnActivityLifecycleChangedListener> lifecycleChangedListeners;

    private ActivityLifecycleMonitor() {
    }

    static void init(@NonNull Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksImpl(INSTANCE));
    }

    public static boolean isRunningForeground() {
        return ActivityLifecycleMonitor.getStartedCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCreatedCount() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            return ActivityLifecycleMonitor.INSTANCE.createdActivityReverseList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStartedCount() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            return ActivityLifecycleMonitor.INSTANCE.startedActivityReverseList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResumedCount() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            return ActivityLifecycleMonitor.INSTANCE.resumedActivityReverseList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Activity> getCreatedActivityList() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> createdActivityStack = ActivityLifecycleMonitor.INSTANCE.createdActivityReverseList;
            if (createdActivityStack.isEmpty()) {
                return null;
            }
            ArrayList<Activity> activityList = new ArrayList<Activity>(createdActivityStack.size());
            for (WeakReference<Activity> reference : createdActivityStack) {
                Activity activity = (Activity)reference.get();
                if (activity == null) continue;
                activityList.add(activity);
            }
            Collections.reverse(activityList);
            return activityList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Activity> getStartedActivityList() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> startedActivityStack = ActivityLifecycleMonitor.INSTANCE.startedActivityReverseList;
            if (startedActivityStack.isEmpty()) {
                return null;
            }
            ArrayList<Activity> activityList = new ArrayList<Activity>(startedActivityStack.size());
            for (WeakReference<Activity> reference : startedActivityStack) {
                Activity activity = (Activity)reference.get();
                if (activity == null) continue;
                activityList.add(activity);
            }
            Collections.reverse(activityList);
            return activityList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Activity> getResumedActivityList() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> resumedActivityStack = ActivityLifecycleMonitor.INSTANCE.resumedActivityReverseList;
            if (resumedActivityStack.isEmpty()) {
                return null;
            }
            ArrayList<Activity> activityList = new ArrayList<Activity>(resumedActivityStack.size());
            for (WeakReference<Activity> reference : resumedActivityStack) {
                Activity activity = (Activity)reference.get();
                if (activity == null) continue;
                activityList.add(activity);
            }
            Collections.reverse(activityList);
            return activityList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getLastCreatedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> createdActivityStack = ActivityLifecycleMonitor.INSTANCE.createdActivityReverseList;
            WeakReference<Activity> lastCreatedActivityRef = !createdActivityStack.isEmpty() ? createdActivityStack.get(0) : null;
            return lastCreatedActivityRef != null ? (Activity)lastCreatedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getLastStartedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> startedActivityStack = ActivityLifecycleMonitor.INSTANCE.startedActivityReverseList;
            WeakReference<Activity> lastStartedActivityRef = !startedActivityStack.isEmpty() ? startedActivityStack.get(0) : null;
            return lastStartedActivityRef != null ? (Activity)lastStartedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getLastResumedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> resumedActivityStack = ActivityLifecycleMonitor.INSTANCE.resumedActivityReverseList;
            WeakReference<Activity> lastResumedActivityRef = !resumedActivityStack.isEmpty() ? resumedActivityStack.get(0) : null;
            return lastResumedActivityRef != null ? (Activity)lastResumedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getFirstCreatedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> createdActivityStack = ActivityLifecycleMonitor.INSTANCE.createdActivityReverseList;
            WeakReference<Activity> lastCreatedActivityRef = !createdActivityStack.isEmpty() ? createdActivityStack.get(createdActivityStack.size() - 1) : null;
            return lastCreatedActivityRef != null ? (Activity)lastCreatedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getFirstStartedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> startedActivityStack = ActivityLifecycleMonitor.INSTANCE.startedActivityReverseList;
            WeakReference<Activity> lastStartedActivityRef = !startedActivityStack.isEmpty() ? startedActivityStack.get(startedActivityStack.size() - 1) : null;
            return lastStartedActivityRef != null ? (Activity)lastStartedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Activity getFirstResumedActivity() {
        Object object = COUNT_EDIT_LOCK;
        synchronized (object) {
            List<WeakReference<Activity>> resumedActivityStack = ActivityLifecycleMonitor.INSTANCE.resumedActivityReverseList;
            WeakReference<Activity> lastResumedActivityRef = !resumedActivityStack.isEmpty() ? resumedActivityStack.get(resumedActivityStack.size() - 1) : null;
            return lastResumedActivityRef != null ? (Activity)lastResumedActivityRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityCreatedListener(@NonNull OnActivityCreatedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityCreatedListener> createdListeners = ActivityLifecycleMonitor.INSTANCE.createdListeners;
            if (createdListeners != null) {
                createdListeners.add(listener);
            } else {
                LinkedList<OnActivityCreatedListener> newCreatedListeners = new LinkedList<OnActivityCreatedListener>();
                newCreatedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.createdListeners = newCreatedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityCreatedListener(@NonNull OnActivityCreatedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityCreatedListener> createdListeners = ActivityLifecycleMonitor.INSTANCE.createdListeners;
            if (createdListeners != null) {
                createdListeners.remove(listener);
            }
        }
    }

    public static void observeActivityCreated(@NonNull LifecycleOwner owner, @NonNull OnActivityCreatedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityCreatedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new CreatedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityStartedListener(@NonNull OnActivityStartedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityStartedListener> startedListeners = ActivityLifecycleMonitor.INSTANCE.startedListeners;
            if (startedListeners != null) {
                startedListeners.add(listener);
            } else {
                LinkedList<OnActivityStartedListener> newStartedListeners = new LinkedList<OnActivityStartedListener>();
                newStartedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.startedListeners = newStartedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityStartedListener(@NonNull OnActivityStartedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityStartedListener> startedListeners = ActivityLifecycleMonitor.INSTANCE.startedListeners;
            if (startedListeners != null) {
                startedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityStarted(@NonNull LifecycleOwner owner, @NonNull OnActivityStartedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityStartedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new StartedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityResumedListener(@NonNull OnActivityResumedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityResumedListener> resumedListeners = ActivityLifecycleMonitor.INSTANCE.resumedListeners;
            if (resumedListeners != null) {
                resumedListeners.add(listener);
            } else {
                LinkedList<OnActivityResumedListener> newResumedListeners = new LinkedList<OnActivityResumedListener>();
                newResumedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.resumedListeners = newResumedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityResumedListener(@NonNull OnActivityResumedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityResumedListener> resumedListeners = ActivityLifecycleMonitor.INSTANCE.resumedListeners;
            if (resumedListeners != null) {
                resumedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityResumed(@NonNull LifecycleOwner owner, @NonNull OnActivityResumedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityResumedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new ResumedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityPausedListener(@NonNull OnActivityPausedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityPausedListener> pausedListeners = ActivityLifecycleMonitor.INSTANCE.pausedListeners;
            if (pausedListeners != null) {
                pausedListeners.add(listener);
            } else {
                LinkedList<OnActivityPausedListener> newPausedListeners = new LinkedList<OnActivityPausedListener>();
                newPausedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.pausedListeners = newPausedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityPausedListener(@NonNull OnActivityPausedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityPausedListener> pausedListeners = ActivityLifecycleMonitor.INSTANCE.pausedListeners;
            if (pausedListeners != null) {
                pausedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityPaused(@NonNull LifecycleOwner owner, @NonNull OnActivityPausedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityPausedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new PausedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityStoppedListener(@NonNull OnActivityStoppedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityStoppedListener> stoppedListeners = ActivityLifecycleMonitor.INSTANCE.stoppedListeners;
            if (stoppedListeners != null) {
                stoppedListeners.add(listener);
            } else {
                LinkedList<OnActivityStoppedListener> newStoppedListeners = new LinkedList<OnActivityStoppedListener>();
                newStoppedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.stoppedListeners = newStoppedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityStoppedListener(@NonNull OnActivityStoppedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityStoppedListener> stoppedListeners = ActivityLifecycleMonitor.INSTANCE.stoppedListeners;
            if (stoppedListeners != null) {
                stoppedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityStopped(@NonNull LifecycleOwner owner, @NonNull OnActivityStoppedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityStoppedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new StoppedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityDestroyedListener(@NonNull OnActivityDestroyedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityDestroyedListener> destroyedListeners = ActivityLifecycleMonitor.INSTANCE.destroyedListeners;
            if (destroyedListeners != null) {
                destroyedListeners.add(listener);
            } else {
                LinkedList<OnActivityDestroyedListener> newDestroyedListeners = new LinkedList<OnActivityDestroyedListener>();
                newDestroyedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.destroyedListeners = newDestroyedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityDestroyedListener(@NonNull OnActivityDestroyedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityDestroyedListener> destroyedListeners = ActivityLifecycleMonitor.INSTANCE.destroyedListeners;
            if (destroyedListeners != null) {
                destroyedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityDestroyed(@NonNull LifecycleOwner owner, @NonNull OnActivityDestroyedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityDestroyedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyedAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivitySaveInstanceStateListener(@NonNull OnActivitySaveInstanceStateListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivitySaveInstanceStateListener> saveInstanceStateListeners = ActivityLifecycleMonitor.INSTANCE.saveInstanceStateListeners;
            if (saveInstanceStateListeners != null) {
                saveInstanceStateListeners.add(listener);
            } else {
                LinkedList<OnActivitySaveInstanceStateListener> newSaveInstanceStateListeners = new LinkedList<OnActivitySaveInstanceStateListener>();
                newSaveInstanceStateListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.saveInstanceStateListeners = newSaveInstanceStateListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivitySaveInstanceStateListener(@NonNull OnActivitySaveInstanceStateListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivitySaveInstanceStateListener> saveInstanceStateListeners = ActivityLifecycleMonitor.INSTANCE.saveInstanceStateListeners;
            if (saveInstanceStateListeners != null) {
                saveInstanceStateListeners.remove(listener);
            }
        }
    }

    public static void observeActivitySaveInstanceState(@NonNull LifecycleOwner owner, @NonNull OnActivitySaveInstanceStateListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivitySaveInstanceStateListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new SaveInstanceStateAutoUnregisterObserver(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityLifecycleChangedListener(@NonNull OnActivityLifecycleChangedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityLifecycleChangedListener> lifecycleChangedListeners = ActivityLifecycleMonitor.INSTANCE.lifecycleChangedListeners;
            if (lifecycleChangedListeners != null) {
                lifecycleChangedListeners.add(listener);
            } else {
                LinkedList<OnActivityLifecycleChangedListener> newLifecycleChangedListeners = new LinkedList<OnActivityLifecycleChangedListener>();
                newLifecycleChangedListeners.add(listener);
                ActivityLifecycleMonitor.INSTANCE.lifecycleChangedListeners = newLifecycleChangedListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityLifecycleChangedListener(@NonNull OnActivityLifecycleChangedListener listener) {
        Object object = LIST_EDIT_LOCK;
        synchronized (object) {
            LinkedList<OnActivityLifecycleChangedListener> lifecycleChangedListeners = ActivityLifecycleMonitor.INSTANCE.lifecycleChangedListeners;
            if (lifecycleChangedListeners != null) {
                lifecycleChangedListeners.remove(listener);
            }
        }
    }

    public static void observeActivityLifecycleChanged(@NonNull LifecycleOwner owner, @NonNull OnActivityLifecycleChangedListener listener) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("LifecycleOwner state is DESTROYED");
        }
        ActivityLifecycleMonitor.registerActivityLifecycleChangedListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new LifecycleChangedAutoUnregisterObserver(listener));
    }

    private static class LifecycleChangedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityLifecycleChangedListener listener;

        LifecycleChangedAutoUnregisterObserver(@NonNull OnActivityLifecycleChangedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityLifecycleChangedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class SaveInstanceStateAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivitySaveInstanceStateListener listener;

        SaveInstanceStateAutoUnregisterObserver(@NonNull OnActivitySaveInstanceStateListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivitySaveInstanceStateListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class DestroyedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityDestroyedListener listener;

        DestroyedAutoUnregisterObserver(@NonNull OnActivityDestroyedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityDestroyedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class StoppedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityStoppedListener listener;

        StoppedAutoUnregisterObserver(@NonNull OnActivityStoppedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityStoppedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class PausedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityPausedListener listener;

        PausedAutoUnregisterObserver(@NonNull OnActivityPausedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityPausedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class ResumedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityResumedListener listener;

        ResumedAutoUnregisterObserver(@NonNull OnActivityResumedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityResumedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class StartedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityStartedListener listener;

        StartedAutoUnregisterObserver(@NonNull OnActivityStartedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityStartedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class CreatedAutoUnregisterObserver
    implements LifecycleEventObserver {
        @NonNull
        private OnActivityCreatedListener listener;

        CreatedAutoUnregisterObserver(@NonNull OnActivityCreatedListener listener) {
            this.listener = listener;
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                ActivityLifecycleMonitor.unregisterActivityCreatedListener(this.listener);
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    private static class ActivityLifecycleCallbacksImpl
    implements Application.ActivityLifecycleCallbacks {
        @NonNull
        private ActivityLifecycleMonitor monitor;

        ActivityLifecycleCallbacksImpl(@NonNull ActivityLifecycleMonitor monitor) {
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            int createdCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                this.monitor.createdActivityReverseList.add(0, new WeakReference<Activity>(activity));
                createdCount = this.monitor.createdActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList createdListeners = this.monitor.createdListeners;
                if (createdListeners != null && !createdListeners.isEmpty()) {
                    for (OnActivityCreatedListener listener : createdListeners) {
                        listener.onActivityCreated(activity, savedInstanceState, createdCount == 1);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStarted(Activity activity) {
            int startedCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                this.monitor.startedActivityReverseList.add(0, new WeakReference<Activity>(activity));
                startedCount = this.monitor.startedActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList startedListeners = this.monitor.startedListeners;
                if (startedListeners != null && !startedListeners.isEmpty()) {
                    for (OnActivityStartedListener listener : startedListeners) {
                        listener.onActivityStarted(activity, startedCount == 1);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 2);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityResumed(Activity activity) {
            int resumedCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                this.monitor.resumedActivityReverseList.add(0, new WeakReference<Activity>(activity));
                resumedCount = this.monitor.resumedActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList resumedListeners = this.monitor.resumedListeners;
                if (resumedListeners != null && !resumedListeners.isEmpty()) {
                    for (OnActivityResumedListener listener : resumedListeners) {
                        listener.onActivityResumed(activity, resumedCount == 1);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 3);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityPaused(Activity activity) {
            int resumedCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                Iterator iterator = this.monitor.resumedActivityReverseList.iterator();
                while (iterator.hasNext()) {
                    WeakReference activityWeakReference = (WeakReference)iterator.next();
                    Activity cacheActivity = (Activity)activityWeakReference.get();
                    if (cacheActivity != null && cacheActivity != activity) continue;
                    iterator.remove();
                }
                resumedCount = this.monitor.resumedActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList pausedListeners = this.monitor.pausedListeners;
                if (pausedListeners != null && !pausedListeners.isEmpty()) {
                    for (OnActivityPausedListener listener : pausedListeners) {
                        listener.onActivityPaused(activity, resumedCount <= 0);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 4);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStopped(Activity activity) {
            int startedCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                Iterator iterator = this.monitor.startedActivityReverseList.iterator();
                while (iterator.hasNext()) {
                    WeakReference activityWeakReference = (WeakReference)iterator.next();
                    Activity cacheActivity = (Activity)activityWeakReference.get();
                    if (cacheActivity != null && cacheActivity != activity) continue;
                    iterator.remove();
                }
                startedCount = this.monitor.startedActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList stoppedListeners = this.monitor.stoppedListeners;
                if (stoppedListeners != null && !stoppedListeners.isEmpty()) {
                    for (OnActivityStoppedListener listener : stoppedListeners) {
                        listener.onActivityStopped(activity, startedCount <= 0);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 5);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            Object object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList saveInstanceStateListeners = this.monitor.saveInstanceStateListeners;
                if (saveInstanceStateListeners != null && !saveInstanceStateListeners.isEmpty()) {
                    for (OnActivitySaveInstanceStateListener listener : saveInstanceStateListeners) {
                        listener.onActivitySaveInstanceState(activity, outState);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 6);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityDestroyed(Activity activity) {
            int createdCount;
            Object object = COUNT_EDIT_LOCK;
            synchronized (object) {
                Iterator iterator = this.monitor.createdActivityReverseList.iterator();
                while (iterator.hasNext()) {
                    WeakReference activityWeakReference = (WeakReference)iterator.next();
                    Activity cacheActivity = (Activity)activityWeakReference.get();
                    if (cacheActivity != null && cacheActivity != activity) continue;
                    iterator.remove();
                }
                createdCount = this.monitor.createdActivityReverseList.size();
            }
            object = LIST_EDIT_LOCK;
            synchronized (object) {
                LinkedList lifecycleChangedListeners;
                LinkedList destroyedListeners = this.monitor.destroyedListeners;
                if (destroyedListeners != null && !destroyedListeners.isEmpty()) {
                    for (OnActivityDestroyedListener listener : destroyedListeners) {
                        listener.onActivityDestroyed(activity, createdCount <= 0);
                    }
                }
                if ((lifecycleChangedListeners = this.monitor.lifecycleChangedListeners) != null && !lifecycleChangedListeners.isEmpty()) {
                    for (OnActivityLifecycleChangedListener listener : lifecycleChangedListeners) {
                        listener.onActivityLifecycleChanged(activity, 7);
                    }
                }
            }
        }
    }
}

