/*
 * Decompiled with CFR 0.152.
 */
package panda.roid.log;

import panda.lang.Strings;
import panda.log.Log;
import panda.log.LogEvent;
import panda.log.LogFormat;
import panda.log.LogLevel;
import panda.log.LogLog;
import panda.log.impl.AbstractLog;
import panda.log.impl.AbstractLogAdapter;

public class LogCatAdapter
extends AbstractLogAdapter {
    public static String TAG_NAME = "PANDA";
    private String tag = TAG_NAME;

    public LogCatAdapter() {
        this.format = LogFormat.SIMPLE;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        if (Strings.isEmpty((CharSequence)tag)) {
            LogLog.error((String)"Empty TAG");
            return;
        }
        this.tag = Strings.left((CharSequence)tag, (int)23);
    }

    protected Log getLogger(String name) {
        return new LogCatLog(this, name);
    }

    protected void setProperty(String name, String value) {
        if ("tag".equalsIgnoreCase(name)) {
            this.setTag(value);
        } else {
            super.setProperty(name, value);
        }
    }

    protected void write(LogEvent event) {
        String msg = this.format.format(event);
        if (event.getLevel() == LogLevel.FATAL) {
            android.util.Log.wtf((String)this.tag, (String)msg, (Throwable)event.getError());
        } else if (event.getLevel() == LogLevel.ERROR) {
            android.util.Log.e((String)this.tag, (String)msg, (Throwable)event.getError());
        } else if (event.getLevel() == LogLevel.WARN) {
            android.util.Log.w((String)this.tag, (String)msg, (Throwable)event.getError());
        } else if (event.getLevel() == LogLevel.INFO) {
            android.util.Log.i((String)this.tag, (String)msg, (Throwable)event.getError());
        } else if (event.getLevel() == LogLevel.DEBUG) {
            android.util.Log.d((String)this.tag, (String)msg, (Throwable)event.getError());
        } else if (event.getLevel() == LogLevel.TRACE) {
            android.util.Log.v((String)this.tag, (String)msg, (Throwable)event.getError());
        }
    }

    private static class LogCatLog
    extends AbstractLog {
        private LogCatAdapter adapter;

        protected LogCatLog(LogCatAdapter adapter, String name) {
            super(adapter.logs, name, adapter.threshold);
            this.adapter = adapter;
        }

        protected void write(LogEvent event) {
            this.adapter.write(event);
        }
    }
}

