/*
 * Decompiled with CFR 0.152.
 */
package panda.roid;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import panda.io.Settings;
import panda.io.Streams;
import panda.log.Logs;

public class Androids {
    public static final int LOGTAG_MAXLENGTH = 23;
    private static boolean initialized;
    private static File internalStorageDirectory;
    private static File externalStorageDirectory;

    public static void init(Context context) {
        if (initialized) {
            return;
        }
        internalStorageDirectory = context.getFilesDir();
        externalStorageDirectory = context.getExternalFilesDir(null);
        Androids.initLogs(context);
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLogs(Context context) {
        AssetManager am = context.getAssets();
        InputStream is = null;
        try {
            is = am.open("panda-logging.properties");
            Settings ss = new Settings();
            ss.load(is);
            Logs.init((Map)ss);
        }
        catch (IOException iOException) {
        }
        finally {
            Streams.safeClose((Closeable)is);
        }
    }

    public static File getInternalStorageDirectory() {
        return internalStorageDirectory;
    }

    public static File getExternalStorageDirectory() {
        if (externalStorageDirectory == null) {
            return Androids.getExternalStorageRootDirectory();
        }
        return externalStorageDirectory;
    }

    public static File getExternalStorageRootDirectory() {
        return Environment.getExternalStorageDirectory();
    }
}

