/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import io.codetail.animation.DynamicAnimation;
import io.codetail.animation.DynamicAnimator;
import io.codetail.animation.SpringAnimation;
import io.codetail.animation.SpringForce;
import io.codetail.animation.ViewRevealManager;

public class SpringViewAnimatorManager
extends ViewRevealManager {
    private static final DynamicAnimation.Property<ViewRevealManager.RevealValues> RADIUS_PROPERTY = new DynamicAnimation.Property<ViewRevealManager.RevealValues>("radius"){

        @Override
        public void setValue(ViewRevealManager.RevealValues view, float value) {
            view.radius = value;
            view.target.invalidate();
        }

        @Override
        public float getValue(ViewRevealManager.RevealValues view) {
            return view.radius;
        }
    };
    private SpringForce force = new SpringForce();

    public SpringViewAnimatorManager() {
        super((ViewRevealManager.ViewTransformation)new ViewRevealManager.PathTransformation());
    }

    protected boolean overrideNativeAnimator() {
        return true;
    }

    public void setStiffness(float stiffness) {
        this.force.setStiffness(stiffness);
    }

    public float getStiffness() {
        return this.force.getStiffness();
    }

    public void setDampingRatio(float dampingRatio) {
        this.force.setDampingRatio(dampingRatio);
    }

    public float getDampingRatio() {
        return this.force.getDampingRatio();
    }

    public void setDefaultThreshold(double threshold) {
        this.force.setDefaultThreshold(threshold);
    }

    protected Animator createAnimator(ViewRevealManager.RevealValues data) {
        this.force.setFinalPosition(data.endRadius);
        SpringAnimation animation = new SpringAnimation(data, RADIUS_PROPERTY);
        animation.setStartValue(data.startRadius);
        animation.setSpring(this.force);
        DynamicAnimator<SpringAnimation> animator = new DynamicAnimator<SpringAnimation>(animation);
        animator.addListener((Animator.AnimatorListener)this.getAnimatorCallback());
        return animator;
    }
}

