/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.os.Looper;
import android.util.AndroidRuntimeException;
import io.codetail.animation.DynamicAnimation;
import io.codetail.animation.SpringForce;

final class SpringAnimation
extends DynamicAnimation<SpringAnimation> {
    private SpringForce mSpring = null;
    private float mPendingPosition = Float.MAX_VALUE;
    private static final float UNSET = Float.MAX_VALUE;

    public <T> SpringAnimation(T v, DynamicAnimation.Property<T> property) {
        super(v, property);
    }

    public <T> SpringAnimation(T v, DynamicAnimation.Property<T> property, float finalPosition) {
        super(v, property);
        this.mSpring = new SpringForce(finalPosition);
        this.setSpringThreshold();
    }

    public SpringForce getSpring() {
        return this.mSpring;
    }

    public SpringAnimation setSpring(SpringForce force) {
        this.mSpring = force;
        this.setSpringThreshold();
        return this;
    }

    @Override
    public void start() {
        this.sanityCheck();
        super.start();
    }

    public void animateToFinalPosition(float finalPosition) {
        if (this.isRunning()) {
            this.mPendingPosition = finalPosition;
        } else {
            if (this.mSpring == null) {
                this.mSpring = new SpringForce(finalPosition);
            }
            this.mSpring.setFinalPosition(finalPosition);
            this.start();
        }
    }

    public void skipToEnd() {
        if (!this.canSkipToEnd()) {
            throw new UnsupportedOperationException("Spring animations can only come to an end when there is damping");
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AndroidRuntimeException("Animations may only be started on the main thread");
        }
        if (this.mRunning) {
            if (this.mPendingPosition != Float.MAX_VALUE) {
                this.mSpring.setFinalPosition(this.mPendingPosition);
                this.mPendingPosition = Float.MAX_VALUE;
            }
            this.mValue = this.mSpring.getFinalPosition();
            this.mVelocity = 0.0f;
            this.cancel();
        }
    }

    public boolean canSkipToEnd() {
        return this.mSpring.mDampingRatio > 0.0;
    }

    private void setSpringThreshold() {
        if (this.mViewProperty == ROTATION || this.mViewProperty == ROTATION_X || this.mViewProperty == ROTATION_Y) {
            this.mSpring.setDefaultThreshold(0.0020833333333333333);
        } else if (this.mViewProperty == ALPHA) {
            this.mSpring.setDefaultThreshold(0.0029411764705882353);
        } else if (this.mViewProperty == SCALE_X || this.mViewProperty == SCALE_Y) {
            this.mSpring.setDefaultThreshold(0.0015);
        } else {
            this.mSpring.setDefaultThreshold(0.75);
        }
    }

    private void sanityCheck() {
        if (this.mSpring == null) {
            throw new UnsupportedOperationException("Incomplete SpringAnimation: Either final position or a spring force needs to be set.");
        }
        double finalPosition = this.mSpring.getFinalPosition();
        if (finalPosition > (double)this.mMaxValue) {
            throw new UnsupportedOperationException("Final position of the spring cannot be greater than the max value.");
        }
        if (finalPosition < (double)this.mMinValue) {
            throw new UnsupportedOperationException("Final position of the spring cannot be less than the min value.");
        }
    }

    @Override
    boolean updateValueAndVelocity(long deltaT) {
        if (this.mPendingPosition != Float.MAX_VALUE) {
            double lastPosition = this.mSpring.getFinalPosition();
            SpringForce.MassState massState = this.mSpring.updateValues(this.mValue, this.mVelocity, deltaT / 2L);
            this.mSpring.setFinalPosition(this.mPendingPosition);
            this.mPendingPosition = Float.MAX_VALUE;
            massState = this.mSpring.updateValues(massState.mValue, massState.mVelocity, deltaT / 2L);
            this.mValue = massState.mValue;
            this.mVelocity = massState.mVelocity;
        } else {
            SpringForce.MassState massState = this.mSpring.updateValues(this.mValue, this.mVelocity, deltaT);
            this.mValue = massState.mValue;
            this.mVelocity = massState.mVelocity;
        }
        this.mValue = Math.max(this.mValue, this.mMinValue);
        this.mValue = Math.min(this.mValue, this.mMaxValue);
        if (this.isAtEquilibrium(this.mValue, this.mVelocity)) {
            this.mValue = this.mSpring.getFinalPosition();
            this.mVelocity = 0.0f;
            return true;
        }
        return false;
    }

    @Override
    float getAcceleration(float value, float velocity) {
        return this.mSpring.getAcceleration(value, velocity);
    }

    @Override
    boolean isAtEquilibrium(float value, float velocity) {
        return this.mSpring.isAtEquilibrium(value, velocity);
    }
}

