/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.view.View;

public class RevealLinearLayout
extends LinearLayoutCompat {
    Path mRevealPath = new Path();
    boolean mClipOutlines;
    float mCenterX;
    float mCenterY;
    float mRadius;
    View mTarget;

    public RevealLinearLayout(Context context) {
        this(context, null);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void setTarget(View view) {
        this.mTarget = view;
    }

    private void setCenter(float centerX, float centerY) {
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    private void setClipOutlines(boolean clip) {
        this.mClipOutlines = clip;
    }

    private void setRevealRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    private float getRevealRadius() {
        return this.mRadius;
    }

    protected boolean drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        if (!this.mClipOutlines && child != this.mTarget) {
            return super.drawChild(canvas, child, drawingTime);
        }
        int state = canvas.save();
        this.mRevealPath.reset();
        this.mRevealPath.addCircle(this.mCenterX, this.mCenterY, this.mRadius, Path.Direction.CW);
        canvas.clipPath(this.mRevealPath);
        boolean isInvalided = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(state);
        return isInvalided;
    }
}

