/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import io.codetail.animation.Animator;
import io.codetail.view.R;
import java.util.ArrayList;

public class FrameLayoutCompat
extends ViewGroup {
    static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    static final boolean FEATURES_HONEYCOMB = Build.VERSION.SDK_INT > 10;
    static final boolean FEATURES_KITKAT = Build.VERSION.SDK_INT > 16;
    static final boolean FEATURES_LOLLIPOP = Animator.LOLLIPOP;
    boolean mMeasureAllChildren = false;
    private Drawable mForeground;
    private ColorStateList mForegroundTintList = null;
    private PorterDuff.Mode mForegroundTintMode = null;
    private boolean mHasForegroundTint = false;
    private boolean mHasForegroundTintMode = false;
    private int mForegroundPaddingLeft = 0;
    private int mForegroundPaddingTop = 0;
    private int mForegroundPaddingRight = 0;
    private int mForegroundPaddingBottom = 0;
    private final Rect mSelfBounds = new Rect();
    private final Rect mOverlayBounds = new Rect();
    private int mForegroundGravity = 119;
    protected boolean mForegroundInPadding = true;
    boolean mForegroundBoundsChanged = false;
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public FrameLayoutCompat(Context context) {
        super(context);
    }

    public FrameLayoutCompat(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FrameLayoutCompat(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public FrameLayoutCompat(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameLayoutCompat, defStyleAttr, defStyleRes);
        this.mForegroundGravity = a.getInt(R.styleable.FrameLayoutCompat_foregroundGravity, this.mForegroundGravity);
        Drawable d = a.getDrawable(R.styleable.FrameLayoutCompat_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        if (a.getBoolean(R.styleable.FrameLayoutCompat_measureAllChildren, false)) {
            this.setMeasureAllChildren(true);
        }
        if (a.hasValue(R.styleable.FrameLayoutCompat_foregroundTintMode)) {
            this.mForegroundTintMode = FrameLayoutCompat.parseTintMode(a.getInt(R.styleable.FrameLayoutCompat_foregroundTintMode, -1), this.mForegroundTintMode);
            this.mHasForegroundTintMode = true;
        }
        if (a.hasValue(R.styleable.FrameLayoutCompat_foregroundTint)) {
            this.mForegroundTintList = a.getColorStateList(R.styleable.FrameLayoutCompat_foregroundTint);
            this.mHasForegroundTint = true;
        }
        this.mForegroundInPadding = a.getBoolean(R.styleable.FrameLayoutCompat_foregroundInsidePadding, true);
        a.recycle();
        this.applyForegroundTint();
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    public int getForegroundGravity() {
        return this.mForegroundGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundGravity != foregroundGravity) {
            if ((foregroundGravity & 0x800007) == 0) {
                foregroundGravity |= 0x800003;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                if (this.mForeground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mForeground != null) {
            this.mForeground.setVisible(visibility == 0, false);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mForeground;
    }

    @TargetApi(value=11)
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mForeground != null) {
            this.mForeground.setHotspot(x, y);
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -1);
    }

    public void setForeground(Drawable d) {
        if (this.mForeground != d) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = d;
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
            if (d != null) {
                Rect padding;
                this.setWillNotDraw(false);
                d.setCallback((Drawable.Callback)this);
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                this.applyForegroundTint();
                if (this.mForegroundGravity == 119 && d.getPadding(padding = new Rect())) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public void setForegroundTintList(ColorStateList tint) {
        this.mForegroundTintList = tint;
        this.mHasForegroundTint = true;
        this.applyForegroundTint();
    }

    public ColorStateList getForegroundTintList() {
        return this.mForegroundTintList;
    }

    public void setForegroundTintMode(PorterDuff.Mode tintMode) {
        this.mForegroundTintMode = tintMode;
        this.mHasForegroundTintMode = true;
        this.applyForegroundTint();
    }

    public PorterDuff.Mode getForegroundTintMode() {
        return this.mForegroundTintMode;
    }

    private void applyForegroundTint() {
        if (this.mForeground != null && (this.mHasForegroundTint || this.mHasForegroundTintMode)) {
            PorterDuffColorFilter filter;
            int color;
            this.mForeground = this.mForeground.mutate();
            if (this.mHasForegroundTint) {
                if (FEATURES_LOLLIPOP) {
                    this.mForeground.setTintList(this.mForegroundTintList);
                } else {
                    color = this.mForegroundTintList.getColorForState(this.getDrawableState(), 0);
                    filter = new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN);
                    this.mForeground.setColorFilter((ColorFilter)filter);
                }
            }
            if (this.mHasForegroundTintMode) {
                if (FEATURES_LOLLIPOP) {
                    this.mForeground.setTintMode(this.mForegroundTintMode);
                } else {
                    color = this.mForegroundTintList.getColorForState(this.getDrawableState(), 0);
                    filter = new PorterDuffColorFilter(color, this.mForegroundTintMode);
                    this.mForeground.setColorFilter((ColorFilter)filter);
                }
            }
        }
    }

    int getPaddingLeftWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingLeft(), this.mForegroundPaddingLeft) : this.getPaddingLeft() + this.mForegroundPaddingLeft;
    }

    int getPaddingRightWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingRight(), this.mForegroundPaddingRight) : this.getPaddingRight() + this.mForegroundPaddingRight;
    }

    private int getPaddingTopWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingTop(), this.mForegroundPaddingTop) : this.getPaddingTop() + this.mForegroundPaddingTop;
    }

    private int getPaddingBottomWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingBottom(), this.mForegroundPaddingBottom) : this.getPaddingBottom() + this.mForegroundPaddingBottom;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            if (FEATURES_HONEYCOMB) {
                childState = FrameLayoutCompat.combineMeasuredStates(childState, child.getMeasuredState());
            }
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
        maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayoutCompat.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), FrameLayoutCompat.resolveSizeAndState(maxHeight, heightMeasureSpec, FEATURES_HONEYCOMB ? childState << 16 : childState));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View child = this.mMatchParentChildren.get(i);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - lp.leftMargin - lp.rightMargin), (int)0x40000000) : FrameLayoutCompat.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + lp.leftMargin + lp.rightMargin), (int)lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - lp.topMargin - lp.bottomMargin), (int)0x40000000) : FrameLayoutCompat.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + lp.topMargin + lp.bottomMargin), (int)lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    @SuppressLint(value={"RtlHardcoded"})
    void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        this.mForegroundBoundsChanged = true;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            int absoluteGravity;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            if (FEATURES_KITKAT) {
                int layoutDirection = this.getLayoutDirection();
                absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            } else {
                absoluteGravity = gravity;
            }
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    if (!forceLeftGravity) {
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect selfBounds = this.mSelfBounds;
                Rect overlayBounds = this.mOverlayBounds;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                if (FEATURES_KITKAT) {
                    int layoutDirection = this.getLayoutDirection();
                    Gravity.apply((int)this.mForegroundGravity, (int)foreground.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds, (int)layoutDirection);
                } else {
                    Gravity.apply((int)this.mForegroundGravity, (int)foreground.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds);
                }
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    public void setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    @Deprecated
    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return this.getMeasureAllChildren();
    }

    public boolean getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new FrameLayout.LayoutParams(this.getContext(), attrs);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.LayoutParams(p);
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)FrameLayout.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)FrameLayout.class.getName());
    }
}

