/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.graphics.Rect;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import io.codetail.animation.Animator;
import io.codetail.animation.RevealAnimator;

public class ViewAnimationUtils {
    public static final int SCALE_UP_DURATION = 500;

    public static Animator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius) {
        if (Animator.LOLLIPOP) {
            return new Animator(android.view.ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius));
        }
        if (!(view.getParent() instanceof RevealAnimator)) {
            throw new IllegalArgumentException("View must be inside dreamers.widget.RevealLayout.");
        }
        RevealAnimator revealLayout = (RevealAnimator)view.getParent();
        revealLayout.setTarget(view);
        revealLayout.setCenter(centerX, centerY);
        Rect bounds = new Rect();
        view.getHitRect(bounds);
        ObjectAnimator reveal = ObjectAnimator.ofFloat((Object)revealLayout, (String)"revealRadius", (float[])new float[]{startRadius, endRadius});
        reveal.addListener((Animator.AnimatorListener)new RevealAnimator.RevealFinished(revealLayout, bounds));
        return new Animator((com.nineoldandroids.animation.Animator)reveal);
    }

    public static void liftingFromBottom(View view, float baseRotation, float fromY, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)fromY);
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    public static void liftingFromBottom(View view, float baseRotation, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    public static void liftingFromBottom(View view, float baseRotation, int duration) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).rotationX(0.0f).translationY(0.0f).start();
    }

    public static class SimpleAnimationListener
    implements Animator.AnimatorListener {
        public void onAnimationStart(com.nineoldandroids.animation.Animator animation) {
        }

        public void onAnimationEnd(com.nineoldandroids.animation.Animator animation) {
        }

        public void onAnimationCancel(com.nineoldandroids.animation.Animator animation) {
        }

        public void onAnimationRepeat(com.nineoldandroids.animation.Animator animation) {
        }
    }
}

