/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import java.lang.ref.WeakReference;

@TargetApi(value=11)
final class SupportAnimatorImpl
extends SupportAnimator {
    WeakReference<Animator> mAnimator;

    SupportAnimatorImpl(Animator animator, RevealAnimator target) {
        super(target);
        this.mAnimator = new WeakReference<Animator>(animator);
    }

    @Override
    public boolean isNativeAnimator() {
        return true;
    }

    @Override
    public Object get() {
        return this.mAnimator.get();
    }

    @Override
    public void start() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.start();
        }
    }

    public Animator setDuration(long duration) {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setDuration(duration);
        }
        return this;
    }

    public void setInterpolator(TimeInterpolator value) {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setInterpolator(value);
        }
    }

    @Override
    public void addListener(final SupportAnimator.AnimatorListener listener) {
        Animator a = (Animator)this.mAnimator.get();
        if (a == null) {
            return;
        }
        if (listener == null) {
            a.addListener(null);
            return;
        }
        a.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd();
            }

            public void onAnimationCancel(Animator animation) {
                listener.onAnimationCancel();
            }

            public void onAnimationRepeat(Animator animation) {
                listener.onAnimationRepeat();
            }
        });
    }

    @Override
    public boolean isRunning() {
        Animator a = (Animator)this.mAnimator.get();
        return a != null && a.isRunning();
    }

    @Override
    public void cancel() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.cancel();
        }
    }

    @Override
    public void end() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.end();
        }
    }

    public long getStartDelay() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            return a.getStartDelay();
        }
        return 0L;
    }

    public void setStartDelay(long startDelay) {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setStartDelay(startDelay);
        }
    }

    public long getDuration() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            return a.getDuration();
        }
        return 0L;
    }

    @Override
    public void setupStartValues() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setupEndValues();
        }
    }
}

