/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.Rect;
import android.util.Property;
import android.view.View;
import io.codetail.animation.SupportAnimator;
import java.lang.ref.WeakReference;

public interface RevealAnimator {
    public static final RevealRadius CLIP_RADIUS = new RevealRadius();

    public void onRevealAnimationStart();

    public void onRevealAnimationEnd();

    public void onRevealAnimationCancel();

    public void setRevealRadius(float var1);

    public float getRevealRadius();

    public void invalidate(Rect var1);

    public void attachRevealInfo(RevealInfo var1);

    public SupportAnimator startReverseAnimation();

    public static class RevealRadius
    extends Property<RevealAnimator, Float> {
        public RevealRadius() {
            super(Float.class, "revealRadius");
        }

        public void set(RevealAnimator object, Float value) {
            object.setRevealRadius(value.floatValue());
        }

        public Float get(RevealAnimator object) {
            return Float.valueOf(object.getRevealRadius());
        }
    }

    public static class RevealFinishedIceCreamSandwich
    extends AnimatorListenerAdapter {
        WeakReference<RevealAnimator> mReference;
        int mFeaturedLayerType;
        int mLayerType;

        RevealFinishedIceCreamSandwich(RevealAnimator target, int layerType) {
            this.mReference = new WeakReference<RevealAnimator>(target);
            this.mLayerType = ((View)target).getLayerType();
            this.mFeaturedLayerType = layerType;
        }

        public void onAnimationStart(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            ((View)target).setLayerType(this.mFeaturedLayerType, null);
            target.onRevealAnimationStart();
        }

        public void onAnimationCancel(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            ((View)target).setLayerType(this.mLayerType, null);
            target.onRevealAnimationCancel();
        }

        public void onAnimationEnd(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            ((View)target).setLayerType(this.mLayerType, null);
            target.onRevealAnimationEnd();
        }
    }

    public static class RevealInfo {
        public final int centerX;
        public final int centerY;
        public final float startRadius;
        public final float endRadius;
        public final WeakReference<View> target;

        public RevealInfo(int centerX, int centerY, float startRadius, float endRadius, WeakReference<View> target) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.startRadius = startRadius;
            this.endRadius = endRadius;
            this.target = target;
        }

        public View getTarget() {
            return (View)this.target.get();
        }

        public boolean hasTarget() {
            return this.getTarget() != null;
        }
    }
}

