/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.ViewAnimationUtils;

public class RevealLinearLayout
extends LinearLayout
implements RevealAnimator {
    private Path mRevealPath;
    private final Rect mTargetBounds = new Rect();
    private RevealAnimator.RevealInfo mRevealInfo;
    private boolean mRunning;
    private float mRadius;

    public RevealLinearLayout(Context context) {
        this(context, null);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.mRevealPath = new Path();
    }

    @Override
    public void onRevealAnimationStart() {
        this.mRunning = true;
    }

    @Override
    public void onRevealAnimationEnd() {
        this.mRunning = false;
        this.invalidate(this.mTargetBounds);
    }

    @Override
    public void onRevealAnimationCancel() {
        this.onRevealAnimationEnd();
    }

    @Override
    public void setRevealRadius(float radius) {
        this.mRadius = radius;
        this.mRevealInfo.getTarget().getHitRect(this.mTargetBounds);
        this.invalidate(this.mTargetBounds);
    }

    @Override
    public float getRevealRadius() {
        return this.mRadius;
    }

    @Override
    public void attachRevealInfo(RevealAnimator.RevealInfo info) {
        this.mRevealInfo = info;
    }

    @Override
    public SupportAnimator startReverseAnimation() {
        if (this.mRevealInfo != null && this.mRevealInfo.hasTarget() && !this.mRunning) {
            return ViewAnimationUtils.createCircularReveal(this.mRevealInfo.getTarget(), this.mRevealInfo.centerX, this.mRevealInfo.centerY, this.mRevealInfo.endRadius, this.mRevealInfo.startRadius);
        }
        return null;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (this.mRunning && child == this.mRevealInfo.getTarget()) {
            int state = canvas.save();
            this.mRevealPath.reset();
            this.mRevealPath.addCircle((float)this.mRevealInfo.centerX, (float)this.mRevealInfo.centerY, this.mRadius, Path.Direction.CW);
            canvas.clipPath(this.mRevealPath);
            boolean isInvalided = super.drawChild(canvas, child, drawingTime);
            canvas.restoreToCount(state);
            return isInvalided;
        }
        return super.drawChild(canvas, child, drawingTime);
    }
}

