/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.config.Casting;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;

final class PoijiHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private T instance;
    private Consumer<? super T> consumer;
    private int internalRow;
    private int internalCount;
    private int limit;
    private Class<T> type;
    private PoijiOptions options;
    private final Casting casting;
    private Map<String, Integer> columnIndexPerTitle;
    private Map<Integer, String> titlePerColumnIndex;
    private Map<String, Object> fieldInstances;
    private Map<Integer, Field> columnToField;
    private Map<Integer, Field> columnToSuperClassField;

    PoijiHandler(Class<T> type, PoijiOptions options, Consumer<? super T> consumer) {
        this.type = type;
        this.options = options;
        this.consumer = consumer;
        this.limit = options.getLimit();
        this.casting = options.getCasting();
        this.columnIndexPerTitle = new HashMap<String, Integer>();
        this.titlePerColumnIndex = new HashMap<Integer, String>();
        this.columnToField = new HashMap<Integer, Field>();
        this.columnToSuperClassField = new HashMap<Integer, Field>();
    }

    private void setFieldValue(String content, Class<? super T> subclass, int column) {
        if (subclass != Object.class) {
            if (this.setValue(content, subclass, column)) {
                return;
            }
            this.setFieldValue(content, subclass.getSuperclass(), column);
        }
    }

    private Object getInstance(Field field) {
        Object ins = null;
        if (this.fieldInstances.containsKey(field.getName())) {
            ins = this.fieldInstances.get(field.getName());
        } else {
            ins = ReflectUtil.newInstanceOf(field.getType());
            this.fieldInstances.put(field.getName(), ins);
        }
        return ins;
    }

    private boolean setValue(String content, Class<? super T> type, int column) {
        Field field2;
        Stream.of(type.getDeclaredFields()).filter(field -> field.getAnnotation(ExcelUnknownCells.class) == null).forEach(field -> {
            ExcelCellRange range;
            ExcelRow excelRow = field.getAnnotation(ExcelRow.class);
            if (excelRow != null) {
                Object o = this.casting.castValue(field.getType(), String.valueOf(this.internalRow), this.options);
                this.setFieldData((Field)field, o, this.instance);
                this.columnToField.put(-1, (Field)field);
            }
            if ((range = field.getAnnotation(ExcelCellRange.class)) != null) {
                Object ins = null;
                ins = this.getInstance((Field)field);
                for (Field f : field.getType().getDeclaredFields()) {
                    if (!this.setValue(f, column, content, ins)) continue;
                    this.setFieldData((Field)field, ins, this.instance);
                    this.columnToField.put(column, f);
                    this.columnToSuperClassField.put(column, (Field)field);
                }
            } else if (this.setValue((Field)field, column, content, this.instance)) {
                this.columnToField.put(column, (Field)field);
            }
        });
        Stream.of(type.getDeclaredFields()).filter(field -> field.getAnnotation(ExcelUnknownCells.class) != null).forEach(field -> {
            if (!this.columnToField.containsKey(column)) {
                try {
                    Map<String, String> excelUnknownCellsMap;
                    field.setAccessible(true);
                    if (field.get(this.instance) == null) {
                        excelUnknownCellsMap = new HashMap();
                        this.setFieldData((Field)field, excelUnknownCellsMap, this.instance);
                    } else {
                        excelUnknownCellsMap = (Map)field.get(this.instance);
                    }
                    excelUnknownCellsMap.put(this.titlePerColumnIndex.get(column), content);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalCastException("Could not read content of field " + field.getName() + " on Object {" + this.instance + "}");
                }
            }
        });
        if (this.columnToField.containsKey(-1)) {
            field2 = this.columnToField.get(-1);
            Object o = this.casting.castValue(field2.getType(), String.valueOf(this.internalRow), this.options);
            this.setFieldData(field2, o, this.instance);
        }
        if (this.columnToField.containsKey(column)) {
            Object ins;
            field2 = this.columnToField.get(column);
            if (this.columnToSuperClassField.containsKey(column) && this.setValue(field2, column, content, ins = this.getInstance(this.columnToSuperClassField.get(column)))) {
                this.setFieldData(this.columnToSuperClassField.get(column), ins, this.instance);
                return true;
            }
            return this.setValue(field2, column, content, this.instance);
        }
        return false;
    }

    private boolean setValue(Field field, int column, String content, Object ins) {
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        if (index != null) {
            Class<?> fieldType = field.getType();
            if (column == index.value()) {
                Object o = this.casting.castValue(fieldType, content, this.options);
                this.setFieldData(field, o, ins);
                return true;
            }
        } else {
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName != null) {
                Class<?> fieldType = field.getType();
                String titleName = this.options.getCaseInsensitive() ? excelCellName.value().toLowerCase() : excelCellName.value();
                Integer titleColumn = this.columnIndexPerTitle.get(titleName);
                if (titleColumn != null && titleColumn == column) {
                    Object o = this.casting.castValue(fieldType, content, this.options);
                    this.setFieldData(field, o, ins);
                    return true;
                }
            }
        }
        return false;
    }

    private void setFieldData(Field field, Object o, Object instance) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }

    public void startRow(int rowNum) {
        if (rowNum + 1 > this.options.skip()) {
            ++this.internalCount;
            this.instance = ReflectUtil.newInstanceOf(this.type);
            this.fieldInstances = new HashMap<String, Object>();
        }
    }

    public void endRow(int rowNum) {
        if (this.internalRow != rowNum) {
            return;
        }
        if (rowNum + 1 > this.options.skip()) {
            this.consumer.accept(this.instance);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        CellAddress cellAddress = new CellAddress(cellReference);
        int row = cellAddress.getRow();
        int headers = this.options.getHeaderStart();
        int column = cellAddress.getColumn();
        if (row <= headers) {
            this.columnIndexPerTitle.put(this.options.getCaseInsensitive() ? formattedValue.toLowerCase() : formattedValue, column);
            this.titlePerColumnIndex.put(column, this.getTitleNameForMap(formattedValue, column));
        }
        if (row + 1 <= this.options.skip()) {
            return;
        }
        if (this.limit != 0 && this.internalCount > this.limit) {
            return;
        }
        this.internalRow = row;
        this.setFieldValue(formattedValue, this.type, column);
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        String titleName = this.titlePerColumnIndex.containsValue(cellContent) || cellContent.isEmpty() ? cellContent + "@" + columnIndex : cellContent;
        return titleName;
    }

    public void headerFooter(String text, boolean isHeader, String tagName) {
    }
}

