/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.SheetNameExtractor;
import com.poiji.config.Casting;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

abstract class HSSFUnmarshaller
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private Map<String, Integer> columnIndexPerTitle;
    private Map<Integer, String> titlePerColumnIndex;
    private int limit;
    private int internalCount;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.limit = options.getLimit();
        this.dataFormatter = new DataFormatter();
        this.columnIndexPerTitle = new HashMap<String, Integer>();
        this.titlePerColumnIndex = new HashMap<Integer, String>();
        this.casting = options.getCasting();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        Workbook workbook = this.workbook();
        Optional<String> maybeSheetName = SheetNameExtractor.getSheetName(type, this.options);
        Sheet sheet = this.getSheetToProcess(workbook, this.options, maybeSheetName.orElse(null));
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            ++this.internalCount;
            if (this.limit != 0 && this.internalCount > this.limit) {
                return;
            }
            T t = this.deserialize0(currentRow, type);
            consumer.accept(t);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options, String sheetName) {
        int nonHiddenSheetIndex = 0;
        int requestedIndex = options.sheetIndex();
        Sheet sheet = null;
        if (options.ignoreHiddenSheets()) {
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (sheetName == null ? nonHiddenSheetIndex == requestedIndex : workbook.getSheetName(i).equalsIgnoreCase(sheetName)) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        } else {
            sheet = sheetName == null ? workbook.getSheetAt(requestedIndex) : workbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            int row = this.options.getHeaderStart();
            Row firstRow = sheet.getRow(row);
            for (Cell cell : firstRow) {
                this.columnIndexPerTitle.put(cell.getStringCellValue(), cell.getColumnIndex());
                this.titlePerColumnIndex.put(cell.getColumnIndex(), this.getTitleNameForMap(cell.getStringCellValue(), cell.getColumnIndex()));
            }
        }
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        String titleName = this.titlePerColumnIndex.containsValue(cellContent) || cellContent.isEmpty() ? cellContent + "@" + columnIndex : cellContent;
        return titleName;
    }

    private <T> T deserialize0(Row currentRow, Class<T> type) {
        T instance = ReflectUtil.newInstanceOf(type);
        return this.setFieldValue(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        ArrayList<Integer> mappedColumnIndices = new ArrayList<Integer>();
        ArrayList<Field> unknownCells = new ArrayList<Field>();
        for (Field field2 : type.getDeclaredFields()) {
            Object o;
            ExcelRow excelRow = field2.getAnnotation(ExcelRow.class);
            ExcelCellRange excelCellRange = field2.getAnnotation(ExcelCellRange.class);
            ExcelUnknownCells excelUnknownCells = field2.getAnnotation(ExcelUnknownCells.class);
            if (excelRow != null) {
                o = this.casting.castValue(field2.getType(), String.valueOf(currentRow.getRowNum()), currentRow.getRowNum(), -1, this.options);
                this.setFieldData(instance, field2, o);
                continue;
            }
            if (excelCellRange != null) {
                o = field2.getType();
                Object ins = ReflectUtil.newInstanceOf(o);
                for (Field f : ((Class)o).getDeclaredFields()) {
                    mappedColumnIndices.add(this.tailSetFieldValue(currentRow, ins, f));
                }
                this.setFieldData(instance, field2, ins);
                continue;
            }
            if (excelUnknownCells != null) {
                unknownCells.add(field2);
                continue;
            }
            mappedColumnIndices.add(this.tailSetFieldValue(currentRow, instance, field2));
        }
        Map<String, String> excelUnknownCellsMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(currentRow.cellIterator(), 16), false).filter(cell -> !mappedColumnIndices.contains(cell.getColumnIndex())).filter(cell -> !cell.toString().isEmpty()).collect(Collectors.toMap(cell -> this.titlePerColumnIndex.get(cell.getColumnIndex()), Object::toString));
        unknownCells.forEach(field -> this.setFieldData(instance, (Field)field, excelUnknownCellsMap));
        return instance;
    }

    private <T> Integer tailSetFieldValue(Row currentRow, T instance, Field field) {
        Integer titleColumn;
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        if (index != null) {
            this.constructTypeValue(currentRow, instance, field, index.value());
            return index.value();
        }
        ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
        if (excelCellName != null && (titleColumn = this.columnIndexPerTitle.get(excelCellName.value())) != null) {
            this.constructTypeValue(currentRow, instance, field, titleColumn);
            return titleColumn;
        }
        return null;
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, int column) {
        Class<?> fieldType = field.getType();
        Cell cell = currentRow.getCell(column);
        if (cell != null) {
            String value = this.dataFormatter.formatCellValue(cell);
            Object o = this.casting.castValue(fieldType, value, currentRow.getRowNum(), column, this.options);
            this.setFieldData(instance, field, o);
        }
    }

    private <T> void setFieldData(T instance, Field field, Object o) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValue(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValue(currentRow, subclass.getSuperclass(), instance));
    }

    private boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    private boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    protected abstract Workbook workbook();
}

