/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.encoder;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Build;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import oupson.apng.chunks.IDAT;
import oupson.apng.encoder.ExperimentalApngEncoder;
import oupson.apng.encoder.ExperimentalApngEncoder$WhenMappings;
import oupson.apng.imageUtils.PngEncoder;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\u0006\u0010$\u001a\u00020\u0018JL\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010'\u001a\u00020(H\u0007JL\u0010%\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010'\u001a\u00020(H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Loupson/apng/encoder/ExperimentalApngEncoder;", "", "outputStream", "Ljava/io/OutputStream;", "width", "", "height", "numberOfFrames", "config", "Landroid/graphics/Bitmap$Config;", "(Ljava/io/OutputStream;IIILandroid/graphics/Bitmap$Config;)V", "frameIndex", "idatName", "", "", "getIdatName", "()Ljava/util/List;", "idatName$delegate", "Lkotlin/Lazy;", "seq", "generateACTL", "", "num", "generateFCTL", "", "btm", "Landroid/graphics/Bitmap;", "delay", "", "disposeOp", "Loupson/apng/utils/Utils$Companion$DisposeOp;", "blendOp", "Loupson/apng/utils/Utils$Companion$BlendOp;", "xOffsets", "yOffsets", "generateIhdr", "writeEnd", "writeFrame", "b", "usePngEncoder", "", "inputStream", "Ljava/io/InputStream;", "apng_library_release"})
public final class ExperimentalApngEncoder {
    private int frameIndex;
    private int seq;
    private final Lazy idatName$delegate;
    private final OutputStream outputStream;
    private final int width;
    private final int height;
    private final Bitmap.Config config;

    private final List<Byte> getIdatName() {
        Lazy lazy = this.idatName$delegate;
        ExperimentalApngEncoder experimentalApngEncoder = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp, boolean usePngEncoder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)blendOp), (String)"blendOp");
        Intrinsics.checkNotNullParameter((Object)((Object)disposeOp), (String)"disposeOp");
        BitmapFactory.Options options = new BitmapFactory.Options();
        boolean bl = false;
        boolean bl2 = false;
        BitmapFactory.Options options2 = options;
        Rect rect = null;
        InputStream inputStream2 = inputStream;
        boolean bl3 = false;
        if (Build.VERSION.SDK_INT >= 26) {
            conf.outConfig = this.config;
        }
        Unit unit = Unit.INSTANCE;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream2, rect, (BitmapFactory.Options)options);
        if (bitmap != null) {
            options = bitmap;
            bl = false;
            bl2 = false;
            BitmapFactory.Options it = options;
            boolean bl4 = false;
            BitmapFactory.Options options3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)options3, (String)"it");
            object = options3.getConfig() != this.config ? it.copy(this.config, it.isMutable()) : it;
        } else {
            object = null;
        }
        Intrinsics.checkNotNull(object);
        BitmapFactory.Options btm = object;
        inputStream.close();
        this.writeFrame((Bitmap)btm, delay, xOffsets, yOffsets, blendOp, disposeOp, usePngEncoder);
    }

    public static /* synthetic */ void writeFrame$default(ExperimentalApngEncoder experimentalApngEncoder, InputStream inputStream, float f, int n, int n2, Utils.Companion.BlendOp blendOp, Utils.Companion.DisposeOp disposeOp, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            f = 1000.0f;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        }
        if ((n3 & 0x20) != 0) {
            disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        experimentalApngEncoder.writeFrame(inputStream, f, n, n2, blendOp, disposeOp, bl);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, yOffsets, blendOp, disposeOp, false, 64, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, yOffsets, blendOp, null, false, 96, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, yOffsets, null, null, false, 112, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, 0, null, null, false, 120, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, delay, 0, 0, null, null, false, 124, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream) {
        ExperimentalApngEncoder.writeFrame$default(this, inputStream, 0.0f, 0, 0, null, null, false, 126, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp, boolean usePngEncoder) {
        int n;
        byte[] byArray;
        byte[] byArray2;
        Bitmap btm;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)((Object)blendOp), (String)"blendOp");
        Intrinsics.checkNotNullParameter((Object)((Object)disposeOp), (String)"disposeOp");
        Bitmap bitmap = btm = b.getConfig() != this.config ? b.copy(this.config, b.isMutable()) : b;
        if (this.frameIndex == 0) {
            Bitmap bitmap2 = btm;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"btm");
            if (bitmap2.getWidth() != this.width) {
                throw (Throwable)new Exception("Width of first frame must be equal to width of APNG. (" + btm.getWidth() + " != " + this.width + ')');
            }
            if (btm.getHeight() != this.height) {
                throw (Throwable)new Exception("Height of first frame must be equal to height of APNG. (" + btm.getHeight() + " != " + this.height + ')');
            }
        }
        Bitmap bitmap3 = btm;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"btm");
        this.generateFCTL(bitmap3, delay, disposeOp, blendOp, xOffsets, yOffsets);
        IDAT iDAT = new IDAT();
        boolean bl = false;
        boolean bl2 = false;
        IDAT $this$apply = iDAT;
        boolean bl3 = false;
        if (usePngEncoder) {
            byArray2 = PngEncoder.encode$default(new PngEncoder(), btm, true, 0, 0, 12, null);
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            btm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
            outputStream.close();
            byArray2 = outputStream.toByteArray();
        }
        Object byteArray = byArray2;
        for (int cursor = 8; cursor < ((byte[])byteArray).length; cursor += Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n)) + 12) {
            Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
            byArray = byteArray;
            byte[] byArray3 = byteArray;
            int n2 = cursor + 4;
            boolean bl4 = false;
            n = cursor + Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])byArray3, (int)cursor, (int)n2)) + 12;
            n2 = 0;
            byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n);
            $this$apply.parse(chunk);
            byArray = byteArray;
            n = cursor + 4;
            n2 = 0;
        }
        IDAT idat = iDAT;
        Iterable $this$forEach$iv = idat.getIDATBody();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object crc1;
            boolean bl5;
            byte[] idatBody = (byte[])element$iv;
            boolean bl6 = false;
            if (this.frameIndex == 0) {
                byteArray = new ArrayList();
                bl5 = false;
                n = 0;
                Object i = byteArray;
                boolean bl7 = false;
                ((ArrayList)i).addAll((Collection)this.getIdatName());
                ((ArrayList)i).addAll(ArraysKt.asList((byte[])idatBody));
                byte[] idatChunk = CollectionsKt.toByteArray((Collection)((Collection)i));
                this.outputStream.write(Utils.Companion.to4BytesArray(idatBody.length));
                crc1 = new CRC32();
                ((CRC32)crc1).update(idatChunk, 0, idatChunk.length);
                this.outputStream.write(idatChunk);
                this.outputStream.write(Utils.Companion.to4BytesArray((int)((CRC32)crc1).getValue()));
                continue;
            }
            crc1 = new ArrayList();
            bl5 = false;
            n = 0;
            ArrayList fdat = crc1;
            boolean bl8 = false;
            fdat.addAll(ArraysKt.asList((byte[])new byte[]{102, 100, 65, 84}));
            int n3 = this.seq;
            this.seq = n3 + 1;
            fdat.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(n3)));
            fdat.addAll(ArraysKt.asList((byte[])idatBody));
            byte[] fdat2 = CollectionsKt.toByteArray((Collection)fdat);
            this.outputStream.write(Utils.Companion.to4BytesArray(idatBody.length + 4));
            crc1 = new CRC32();
            ((CRC32)crc1).update(fdat2, 0, fdat2.length);
            this.outputStream.write(fdat2);
            this.outputStream.write(Utils.Companion.to4BytesArray((int)((CRC32)crc1).getValue()));
        }
        int n4 = this.frameIndex;
        this.frameIndex = n4 + 1;
    }

    public static /* synthetic */ void writeFrame$default(ExperimentalApngEncoder experimentalApngEncoder, Bitmap bitmap, float f, int n, int n2, Utils.Companion.BlendOp blendOp, Utils.Companion.DisposeOp disposeOp, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            f = 1000.0f;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        }
        if ((n3 & 0x20) != 0) {
            disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        experimentalApngEncoder.writeFrame(bitmap, f, n, n2, blendOp, disposeOp, bl);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp) {
        ExperimentalApngEncoder.writeFrame$default(this, b, delay, xOffsets, yOffsets, blendOp, disposeOp, false, 64, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp) {
        ExperimentalApngEncoder.writeFrame$default(this, b, delay, xOffsets, yOffsets, blendOp, null, false, 96, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay, int xOffsets, int yOffsets) {
        ExperimentalApngEncoder.writeFrame$default(this, b, delay, xOffsets, yOffsets, null, null, false, 112, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay, int xOffsets) {
        ExperimentalApngEncoder.writeFrame$default(this, b, delay, xOffsets, 0, null, null, false, 120, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b, float delay) {
        ExperimentalApngEncoder.writeFrame$default(this, b, delay, 0, 0, null, null, false, 124, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap b) {
        ExperimentalApngEncoder.writeFrame$default(this, b, 0.0f, 0, 0, null, null, false, 126, null);
    }

    public final void writeEnd() {
        this.outputStream.write(Utils.Companion.to4BytesArray(0));
        byte[] iend = new byte[]{73, 69, 78, 68};
        CRC32 crC32 = new CRC32();
        crC32.update(iend, 0, iend.length);
        this.outputStream.write(iend);
        this.outputStream.write(Utils.Companion.to4BytesArray((int)crC32.getValue()));
    }

    private final byte[] generateIhdr() {
        ArrayList ihdr = new ArrayList();
        ArrayList<Byte> ihdrBody = new ArrayList<Byte>();
        ihdr.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)0, (byte)0, (byte)0, (byte)13}));
        ihdrBody.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
        ihdrBody.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(this.width)));
        ihdrBody.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(this.height)));
        if (Build.VERSION.SDK_INT >= 26) {
            byte by;
            switch (ExperimentalApngEncoder$WhenMappings.$EnumSwitchMapping$0[this.config.ordinal()]) {
                case 1: {
                    by = (byte)8;
                    break;
                }
                case 2: {
                    by = (byte)8;
                    break;
                }
                case 3: {
                    by = (byte)8;
                    break;
                }
                default: {
                    throw (Throwable)new Exception("CONFIG IS NOT SUPPORTED");
                }
            }
            ihdrBody.add(by);
        } else {
            byte by;
            if (this.config == Bitmap.Config.ARGB_8888) {
                by = (byte)8;
            } else if (this.config == Bitmap.Config.RGB_565) {
                by = (byte)8;
            } else {
                throw (Throwable)new Exception("CONFIG IS NOT SUPPORTED");
            }
            ihdrBody.add(by);
        }
        ihdrBody.add(this.config == Bitmap.Config.RGB_565 ? (byte)2 : (byte)6);
        ihdrBody.add((byte)0);
        ihdrBody.add((byte)0);
        ihdrBody.add((byte)0);
        CRC32 crC32 = new CRC32();
        crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
        ihdr.addAll(ihdrBody);
        ihdr.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crC32.getValue())));
        return CollectionsKt.toByteArray((Collection)ihdr);
    }

    private final byte[] generateACTL(int num) {
        ArrayList res = new ArrayList();
        ArrayList actl = new ArrayList();
        res.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)0, (byte)0, (byte)0, (byte)8}));
        actl.addAll(ArraysKt.asList((byte[])new byte[]{97, 99, 84, 76}));
        actl.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(num)));
        actl.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(0)));
        res.addAll(actl);
        CRC32 crc = new CRC32();
        crc.update(CollectionsKt.toByteArray((Collection)actl), 0, actl.size());
        res.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crc.getValue())));
        return CollectionsKt.toByteArray((Collection)res);
    }

    private final void generateFCTL(Bitmap btm, float delay, Utils.Companion.DisposeOp disposeOp, Utils.Companion.BlendOp blendOp, int xOffsets, int yOffsets) {
        ArrayList<Byte> fcTL2 = new ArrayList<Byte>();
        this.outputStream.write(new byte[]{0, 0, 0, 26});
        fcTL2.addAll(ArraysKt.asList((byte[])new byte[]{102, 99, 84, 76}));
        int n = this.seq;
        this.seq = n + 1;
        fcTL2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(n)));
        fcTL2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(btm.getWidth())));
        fcTL2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(btm.getHeight())));
        fcTL2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(xOffsets)));
        fcTL2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(yOffsets)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to2Bytes((int)delay)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to2Bytes(1000)));
        fcTL2.add((byte)Utils.Companion.getDisposeOp(disposeOp));
        fcTL2.add((byte)Utils.Companion.getBlendOp(blendOp));
        CRC32 crc = new CRC32();
        crc.update(CollectionsKt.toByteArray((Collection)fcTL2), 0, fcTL2.size());
        this.outputStream.write(CollectionsKt.toByteArray((Collection)fcTL2));
        this.outputStream.write(Utils.Companion.to4BytesArray((int)crc.getValue()));
    }

    public ExperimentalApngEncoder(@NotNull OutputStream outputStream, int width, int height, int numberOfFrames, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.outputStream = outputStream;
        this.width = width;
        this.height = height;
        this.config = config;
        this.idatName$delegate = LazyKt.lazy((Function0)idatName.2.INSTANCE);
        this.outputStream.write(Utils.Companion.getPngSignature());
        this.outputStream.write(this.generateIhdr());
        this.outputStream.write(this.generateACTL(numberOfFrames));
    }

    public /* synthetic */ ExperimentalApngEncoder(OutputStream outputStream, int n, int n2, int n3, Bitmap.Config config, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        this(outputStream, n, n2, n3, config);
    }
}

