/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.encoder;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import oupson.apng.chunks.IDAT;
import oupson.apng.encoder.ApngEncoder;
import oupson.apng.imageUtils.PngEncoder;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\u0006\u0010\"\u001a\u00020\u0016J@\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Loupson/apng/encoder/ApngEncoder;", "", "outputStream", "Ljava/io/OutputStream;", "width", "", "height", "numberOfFrames", "(Ljava/io/OutputStream;III)V", "frameIndex", "idatName", "", "", "getIdatName", "()Ljava/util/List;", "idatName$delegate", "Lkotlin/Lazy;", "seq", "generateACTL", "", "num", "generateFCTL", "", "btm", "Landroid/graphics/Bitmap;", "delay", "", "disposeOp", "Loupson/apng/utils/Utils$Companion$DisposeOp;", "blendOp", "Loupson/apng/utils/Utils$Companion$BlendOp;", "xOffsets", "yOffsets", "generateIhdr", "writeEnd", "writeFrame", "inputStream", "Ljava/io/InputStream;", "apng_library_release"})
public final class ApngEncoder {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private int frameIndex;
    private int seq;
    private final Lazy idatName$delegate;
    private final OutputStream outputStream;
    private final int width;
    private final int height;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ApngEncoder.class), "idatName", "getIdatName()Ljava/util/List;"))};
    }

    private final List<Byte> getIdatName() {
        Lazy lazy = this.idatName$delegate;
        ApngEncoder apngEncoder = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)((Object)blendOp), (String)"blendOp");
        Intrinsics.checkParameterIsNotNull((Object)((Object)disposeOp), (String)"disposeOp");
        Bitmap btm = BitmapFactory.decodeStream((InputStream)inputStream);
        inputStream.close();
        if (this.frameIndex == 0) {
            Bitmap bitmap = btm;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
            if (bitmap.getWidth() != this.width) {
                throw (Throwable)new Exception("Width of first frame must be equal to width of APNG. (" + btm.getWidth() + " != " + this.width + ')');
            }
            if (btm.getHeight() != this.height) {
                throw (Throwable)new Exception("Height of first frame must be equal to height of APNG. (" + btm.getHeight() + " != " + this.height + ')');
            }
        }
        Bitmap bitmap = btm;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
        this.generateFCTL(bitmap, delay, disposeOp, blendOp, xOffsets, yOffsets);
        IDAT iDAT = new IDAT();
        boolean bl = false;
        boolean bl2 = false;
        IDAT $this$apply = iDAT;
        boolean bl3 = false;
        byte[] byteArray = PngEncoder.Companion.encode$default(PngEncoder.Companion, btm, true, 0, 0, 12, null);
        int cursor2 = 8;
        while (cursor2 < byteArray.length) {
            byte[] byArray = byteArray;
            byte[] byArray2 = byteArray;
            int n3 = cursor2 + 4;
            Utils.Companion companion = Utils.Companion;
            int n4 = cursor2;
            n2 = 0;
            byte[] byArray3 = ArraysKt.copyOfRange((byte[])byArray2, (int)cursor2, (int)n3);
            n = n4 + companion.parseLength(byArray3) + 12;
            n3 = 0;
            byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)cursor2, (int)n);
            $this$apply.parse(chunk);
            byArray = byteArray;
            n = cursor2 + 4;
            companion = Utils.Companion;
            n4 = cursor2;
            n3 = 0;
            byArray3 = ArraysKt.copyOfRange((byte[])byArray, (int)cursor2, (int)n);
            cursor2 = n4 + (companion.parseLength(byArray3) + 12);
        }
        IDAT idat = iDAT;
        Iterable $this$forEach$iv = idat.getIDATBody();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object crc1;
            boolean bl4;
            byte[] idatBody = (byte[])element$iv;
            boolean bl5 = false;
            if (this.frameIndex == 0) {
                ArrayList cursor2 = new ArrayList();
                bl4 = false;
                n = 0;
                ArrayList i = cursor2;
                boolean bl6 = false;
                i.addAll(this.getIdatName());
                i.addAll(ArraysKt.asList((byte[])idatBody));
                byte[] idatChunk = CollectionsKt.toByteArray((Collection)i);
                this.outputStream.write(Utils.Companion.to4Bytes(idatBody.length));
                crc1 = new CRC32();
                ((CRC32)crc1).update(idatChunk, 0, idatChunk.length);
                this.outputStream.write(idatChunk);
                this.outputStream.write(Utils.Companion.to4Bytes((int)((CRC32)crc1).getValue()));
                continue;
            }
            crc1 = new ArrayList();
            bl4 = false;
            n = 0;
            ArrayList fdat = crc1;
            boolean bl7 = false;
            fdat.addAll(ArraysKt.asList((byte[])new byte[]{102, 100, 65, 84}));
            n2 = this.seq;
            this.seq = n2 + 1;
            fdat.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(n2)));
            fdat.addAll(ArraysKt.asList((byte[])idatBody));
            byte[] fdat2 = CollectionsKt.toByteArray((Collection)fdat);
            this.outputStream.write(Utils.Companion.to4Bytes(idatBody.length + 4));
            crc1 = new CRC32();
            ((CRC32)crc1).update(fdat2, 0, fdat2.length);
            this.outputStream.write(fdat2);
            this.outputStream.write(Utils.Companion.to4Bytes((int)((CRC32)crc1).getValue()));
        }
        int n5 = this.frameIndex;
        this.frameIndex = n5 + 1;
    }

    public static /* synthetic */ void writeFrame$default(ApngEncoder apngEncoder, InputStream inputStream, float f, int n, int n2, Utils.Companion.BlendOp blendOp, Utils.Companion.DisposeOp disposeOp, int n3, Object object) {
        if ((n3 & 2) != 0) {
            f = 1000.0f;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        }
        if ((n3 & 0x20) != 0) {
            disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        }
        apngEncoder.writeFrame(inputStream, f, n, n2, blendOp, disposeOp);
    }

    public final void writeEnd() {
        this.outputStream.write(Utils.Companion.to4Bytes(0));
        byte[] iend = new byte[]{73, 69, 78, 68};
        CRC32 crC32 = new CRC32();
        crC32.update(iend, 0, iend.length);
        this.outputStream.write(iend);
        this.outputStream.write(Utils.Companion.to4Bytes((int)crC32.getValue()));
    }

    private final byte[] generateIhdr() {
        ArrayList ihdr = new ArrayList();
        ArrayList<Byte> ihdrBody = new ArrayList<Byte>();
        ihdr.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)0, (byte)0, (byte)0, (byte)13}));
        ihdrBody.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
        ihdrBody.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(this.width)));
        ihdrBody.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(this.height)));
        ihdrBody.add((byte)8);
        ihdrBody.add((byte)6);
        ihdrBody.add((byte)0);
        ihdrBody.add((byte)0);
        ihdrBody.add((byte)0);
        CRC32 crC32 = new CRC32();
        crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
        ihdr.addAll(ihdrBody);
        ihdr.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
        return CollectionsKt.toByteArray((Collection)ihdr);
    }

    private final byte[] generateACTL(int num) {
        ArrayList res = new ArrayList();
        ArrayList actl = new ArrayList();
        res.addAll(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)0, (byte)0, (byte)0, (byte)8}));
        actl.addAll(ArraysKt.asList((byte[])new byte[]{97, 99, 84, 76}));
        actl.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(num)));
        actl.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(0)));
        res.addAll(actl);
        CRC32 crc = new CRC32();
        crc.update(CollectionsKt.toByteArray((Collection)actl), 0, actl.size());
        res.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crc.getValue())));
        return CollectionsKt.toByteArray((Collection)res);
    }

    private final void generateFCTL(Bitmap btm, float delay, Utils.Companion.DisposeOp disposeOp, Utils.Companion.BlendOp blendOp, int xOffsets, int yOffsets) {
        ArrayList<Byte> fcTL2 = new ArrayList<Byte>();
        this.outputStream.write(new byte[]{0, 0, 0, 26});
        fcTL2.addAll(ArraysKt.asList((byte[])new byte[]{102, 99, 84, 76}));
        int n = this.seq;
        this.seq = n + 1;
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(n)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(btm.getWidth())));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(btm.getHeight())));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(xOffsets)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(yOffsets)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to2Bytes((int)delay)));
        fcTL2.addAll(ArraysKt.asList((byte[])Utils.Companion.to2Bytes(1000)));
        fcTL2.add((byte)Utils.Companion.getDisposeOp(disposeOp));
        fcTL2.add((byte)Utils.Companion.getBlendOp(blendOp));
        CRC32 crc = new CRC32();
        crc.update(CollectionsKt.toByteArray((Collection)fcTL2), 0, fcTL2.size());
        this.outputStream.write(CollectionsKt.toByteArray((Collection)fcTL2));
        this.outputStream.write(Utils.Companion.to4Bytes((int)crc.getValue()));
    }

    public ApngEncoder(@NotNull OutputStream outputStream, int width, int height, int numberOfFrames) {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
        this.width = width;
        this.height = height;
        this.idatName$delegate = LazyKt.lazy((Function0)idatName.2.INSTANCE);
        this.outputStream.write(Utils.Companion.getPngSignature());
        this.outputStream.write(this.generateIhdr());
        this.outputStream.write(this.generateACTL(numberOfFrames));
    }
}

